/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.helper;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public class RpcUserAuthCounter {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator", "\n");
    private final ConcurrentMap<String, AtomicInteger> counterMap = new ConcurrentHashMap<String, AtomicInteger>(8, 0.9f, 1);

    public int incrementAndGet(String authPrefix) {
        if (authPrefix != null) {
            this.counterMap.putIfAbsent(authPrefix, new AtomicInteger(0));
            return ((AtomicInteger)this.counterMap.get(authPrefix)).incrementAndGet();
        }
        return 0;
    }

    public int decrementAndGet(String authPrefix) {
        if (authPrefix != null && this.counterMap.get(authPrefix) != null) {
            return ((AtomicInteger)this.counterMap.get(authPrefix)).decrementAndGet();
        }
        return 0;
    }

    public int getCount(String authPrefix) {
        if (authPrefix != null && this.counterMap.get(authPrefix) != null) {
            return ((AtomicInteger)this.counterMap.get(authPrefix)).intValue();
        }
        return 0;
    }

    public void clearCount() {
        this.counterMap.clear();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (Map.Entry entry : this.counterMap.entrySet()) {
            if (entry == null || entry.getKey() == null || entry.getValue() == null) continue;
            sb.append((String)entry.getKey()).append(": ").append(entry.getValue()).append(LINE_SEPARATOR);
        }
        return sb.toString();
    }
}

