/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.deploy;

import java.io.File;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.deployer.ArtifactDeployer;
import org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractDeployMojo
extends AbstractMojo {
    @Component
    private ArtifactDeployer deployer;
    @Component
    protected ArtifactFactory artifactFactory;
    @Component
    ArtifactRepositoryFactory repositoryFactory;
    @Component(role=ArtifactRepositoryLayout.class)
    private Map<String, ArtifactRepositoryLayout> repositoryLayouts;
    @Parameter(defaultValue="${localRepository}", required=true, readonly=true)
    private ArtifactRepository localRepository;
    @Parameter(defaultValue="${settings.offline}", readonly=true)
    private boolean offline;
    @Parameter(property="updateReleaseInfo", defaultValue="false")
    protected boolean updateReleaseInfo;
    @Parameter(property="retryFailedDeploymentCount", defaultValue="1")
    private int retryFailedDeploymentCount;

    public ArtifactDeployer getDeployer() {
        return this.deployer;
    }

    public void setDeployer(ArtifactDeployer deployer) {
        this.deployer = deployer;
    }

    public ArtifactRepository getLocalRepository() {
        return this.localRepository;
    }

    public void setLocalRepository(ArtifactRepository localRepository) {
        this.localRepository = localRepository;
    }

    void failIfOffline() throws MojoFailureException {
        if (this.offline) {
            throw new MojoFailureException("Cannot deploy artifacts when Maven is in offline mode");
        }
    }

    ArtifactRepositoryLayout getLayout(String id) throws MojoExecutionException {
        ArtifactRepositoryLayout layout = this.repositoryLayouts.get(id);
        if (layout == null) {
            throw new MojoExecutionException("Invalid repository layout: " + id);
        }
        return layout;
    }

    boolean isUpdateReleaseInfo() {
        return this.updateReleaseInfo;
    }

    int getRetryFailedDeploymentCount() {
        return this.retryFailedDeploymentCount;
    }

    protected void deploy(File source, Artifact artifact, ArtifactRepository deploymentRepository, ArtifactRepository localRepository, int retryFailedDeploymentCount) throws ArtifactDeploymentException {
        int retryFailedDeploymentCounter = Math.max(1, Math.min(10, retryFailedDeploymentCount));
        ArtifactDeploymentException exception = null;
        for (int count = 0; count < retryFailedDeploymentCounter; ++count) {
            try {
                if (count > 0) {
                    this.getLog().info("Retrying deployment attempt " + (count + 1) + " of " + retryFailedDeploymentCounter);
                }
                this.getDeployer().deploy(source, artifact, deploymentRepository, localRepository);
                exception = null;
                break;
            }
            catch (ArtifactDeploymentException e) {
                if (count + 1 < retryFailedDeploymentCounter) {
                    this.getLog().warn("Encountered issue during deployment: " + e.getLocalizedMessage());
                    this.getLog().debug(e);
                }
                if (exception != null) continue;
                exception = e;
                continue;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }
}

