/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.descriptor;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.descriptor.DuplicateMojoDescriptorException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.lifecycle.Lifecycle;
import org.apache.maven.plugin.lifecycle.LifecycleConfiguration;
import org.apache.maven.plugin.lifecycle.io.xpp3.LifecycleMappingsXpp3Reader;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.ComponentSetDescriptor;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginDescriptor
extends ComponentSetDescriptor
implements Cloneable {
    private static final String LIFECYCLE_DESCRIPTOR = "META-INF/maven/lifecycle.xml";
    private String groupId;
    private String artifactId;
    private String version;
    private String goalPrefix;
    private String source;
    private boolean inheritedByDefault = true;
    private List<Artifact> artifacts;
    private ClassRealm classRealm;
    private Map<String, Artifact> artifactMap;
    private Set<Artifact> introducedDependencyArtifacts;
    private String name;
    private String description;
    private String requiredMavenVersion;
    private Plugin plugin;
    private Artifact pluginArtifact;
    private Map<String, Lifecycle> lifecycleMappings;

    public List<MojoDescriptor> getMojos() {
        return this.getComponents();
    }

    public void addMojo(MojoDescriptor mojoDescriptor) throws DuplicateMojoDescriptorException {
        ComponentDescriptor existing = null;
        List<MojoDescriptor> mojos = this.getMojos();
        if (mojos != null && mojos.contains(mojoDescriptor)) {
            int indexOf = mojos.indexOf(mojoDescriptor);
            existing = mojos.get(indexOf);
        }
        if (existing != null) {
            throw new DuplicateMojoDescriptorException(this.getGoalPrefix(), mojoDescriptor.getGoal(), existing.getImplementation(), mojoDescriptor.getImplementation());
        }
        this.addComponentDescriptor(mojoDescriptor);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public static String constructPluginKey(String groupId, String artifactId, String version) {
        return groupId + ":" + artifactId + ":" + version;
    }

    public String getPluginLookupKey() {
        return this.groupId + ":" + this.artifactId;
    }

    @Override
    public String getId() {
        return PluginDescriptor.constructPluginKey(this.groupId, this.artifactId, this.version);
    }

    public static String getDefaultPluginArtifactId(String id) {
        return "maven-" + id + "-plugin";
    }

    public static String getDefaultPluginGroupId() {
        return "org.apache.maven.plugins";
    }

    public static String getGoalPrefixFromArtifactId(String artifactId) {
        if ("maven-plugin-plugin".equals(artifactId)) {
            return "plugin";
        }
        return artifactId.replaceAll("-?maven-?", "").replaceAll("-?plugin-?", "");
    }

    public String getGoalPrefix() {
        return this.goalPrefix;
    }

    public void setGoalPrefix(String goalPrefix) {
        this.goalPrefix = goalPrefix;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    public boolean isInheritedByDefault() {
        return this.inheritedByDefault;
    }

    public void setInheritedByDefault(boolean inheritedByDefault) {
        this.inheritedByDefault = inheritedByDefault;
    }

    public List<Artifact> getArtifacts() {
        return this.artifacts;
    }

    public void setArtifacts(List<Artifact> artifacts) {
        this.artifacts = artifacts;
        this.artifactMap = null;
    }

    public Map<String, Artifact> getArtifactMap() {
        if (this.artifactMap == null) {
            this.artifactMap = ArtifactUtils.artifactMapByVersionlessId(this.getArtifacts());
        }
        return this.artifactMap;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return this.getId().equals(((PluginDescriptor)object).getId());
    }

    public int hashCode() {
        return 10 + this.getId().hashCode();
    }

    public MojoDescriptor getMojo(String goal) {
        if (this.getMojos() == null) {
            return null;
        }
        for (MojoDescriptor desc : this.getMojos()) {
            if (!goal.equals(desc.getGoal())) continue;
            return desc;
        }
        return null;
    }

    public void setClassRealm(ClassRealm classRealm) {
        this.classRealm = classRealm;
    }

    public ClassRealm getClassRealm() {
        return this.classRealm;
    }

    public void setIntroducedDependencyArtifacts(Set<Artifact> introducedDependencyArtifacts) {
        this.introducedDependencyArtifacts = introducedDependencyArtifacts;
    }

    public Set<Artifact> getIntroducedDependencyArtifacts() {
        return this.introducedDependencyArtifacts != null ? this.introducedDependencyArtifacts : Collections.emptySet();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setRequiredMavenVersion(String requiredMavenVersion) {
        this.requiredMavenVersion = requiredMavenVersion;
    }

    public String getRequiredMavenVersion() {
        return this.requiredMavenVersion;
    }

    public void setPlugin(Plugin plugin) {
        this.plugin = plugin;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public Artifact getPluginArtifact() {
        return this.pluginArtifact;
    }

    public void setPluginArtifact(Artifact pluginArtifact) {
        this.pluginArtifact = pluginArtifact;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lifecycle getLifecycleMapping(String lifecycleId) throws IOException, XmlPullParserException {
        block3: {
            LifecycleConfiguration lifecycleConfiguration;
            if (this.lifecycleMappings != null) break block3;
            XmlStreamReader reader = null;
            try {
                reader = ReaderFactory.newXmlReader(this.getDescriptorStream(LIFECYCLE_DESCRIPTOR));
                lifecycleConfiguration = new LifecycleMappingsXpp3Reader().read(reader);
            }
            catch (Throwable throwable) {
                IOUtil.close(reader);
                throw throwable;
            }
            IOUtil.close(reader);
            this.lifecycleMappings = new HashMap<String, Lifecycle>();
            for (Lifecycle lifecycle : lifecycleConfiguration.getLifecycles()) {
                this.lifecycleMappings.put(lifecycle.getId(), lifecycle);
            }
        }
        return this.lifecycleMappings.get(lifecycleId);
    }

    private InputStream getDescriptorStream(String descriptor) throws IOException {
        File pluginFile;
        File file = pluginFile = this.pluginArtifact != null ? this.pluginArtifact.getFile() : null;
        if (pluginFile == null) {
            throw new IllegalStateException("plugin main artifact has not been resolved for " + this.getId());
        }
        if (pluginFile.isFile()) {
            try {
                return new URL("jar:" + pluginFile.toURI() + "!/" + descriptor).openStream();
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException(e);
            }
        }
        return new FileInputStream(new File(pluginFile, descriptor));
    }

    public PluginDescriptor clone() {
        try {
            return (PluginDescriptor)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new UnsupportedOperationException(e);
        }
    }
}

