/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.InputSource;
import org.apache.maven.project.DefaultDependencyResolutionResult;
import org.apache.maven.project.DependencyResolutionException;
import org.apache.maven.project.DependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.RequestTrace;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.artifact.ArtifactTypeRegistry;
import org.sonatype.aether.collection.CollectRequest;
import org.sonatype.aether.collection.DependencyCollectionException;
import org.sonatype.aether.graph.Dependency;
import org.sonatype.aether.graph.DependencyFilter;
import org.sonatype.aether.graph.DependencyNode;
import org.sonatype.aether.graph.DependencyVisitor;
import org.sonatype.aether.resolution.ArtifactResult;
import org.sonatype.aether.resolution.DependencyRequest;
import org.sonatype.aether.util.DefaultRequestTrace;
import org.sonatype.aether.util.artifact.ArtifacIdUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=ProjectDependenciesResolver.class)
public class DefaultProjectDependenciesResolver
implements ProjectDependenciesResolver {
    @Requirement
    private Logger logger;
    @Requirement
    private RepositorySystem repoSystem;

    @Override
    public DependencyResolutionResult resolve(DependencyResolutionRequest request) throws DependencyResolutionException {
        DependencyNode node;
        DependencyManagement depMngt;
        RequestTrace trace = DefaultRequestTrace.newChild(null, request);
        DefaultDependencyResolutionResult result = new DefaultDependencyResolutionResult();
        MavenProject project = request.getMavenProject();
        RepositorySystemSession session = request.getRepositorySession();
        DependencyFilter filter = request.getResolutionFilter();
        ArtifactTypeRegistry stereotypes = session.getArtifactTypeRegistry();
        CollectRequest collect = new CollectRequest();
        collect.setRequestContext("project");
        collect.setRepositories(project.getRemoteProjectRepositories());
        if (project.getDependencyArtifacts() == null) {
            for (org.apache.maven.model.Dependency dependency : project.getDependencies()) {
                collect.addDependency(RepositoryUtils.toDependency(dependency, stereotypes));
            }
        } else {
            String key;
            HashMap<String, org.apache.maven.model.Dependency> dependencies = new HashMap<String, org.apache.maven.model.Dependency>();
            for (org.apache.maven.model.Dependency dependency : project.getDependencies()) {
                key = dependency.getManagementKey();
                dependencies.put(key, dependency);
            }
            Iterator<Object> i$ = project.getDependencyArtifacts().iterator();
            while (i$.hasNext()) {
                org.apache.maven.artifact.Artifact artifact;
                key = (artifact = (org.apache.maven.artifact.Artifact)i$.next()).getDependencyConflictId();
                org.apache.maven.model.Dependency dependency = (org.apache.maven.model.Dependency)dependencies.get(key);
                List<Exclusion> exclusions = dependency != null ? dependency.getExclusions() : null;
                Dependency dep = RepositoryUtils.toDependency(artifact, exclusions);
                if (!"system".equals(dep.getScope()) && dep.getArtifact().getFile() != null) {
                    Artifact art = dep.getArtifact();
                    art = art.setFile(null).setVersion(art.getBaseVersion());
                    dep = dep.setArtifact(art);
                }
                collect.addDependency(dep);
            }
        }
        if ((depMngt = project.getDependencyManagement()) != null) {
            for (org.apache.maven.model.Dependency dependency : depMngt.getDependencies()) {
                collect.addManagedDependency(RepositoryUtils.toDependency(dependency, stereotypes));
            }
        }
        DependencyRequest depRequest = new DependencyRequest(collect, filter);
        depRequest.setTrace(trace);
        try {
            collect.setTrace(DefaultRequestTrace.newChild(trace, depRequest));
            node = this.repoSystem.collectDependencies(session, collect).getRoot();
            result.setDependencyGraph(node);
        }
        catch (DependencyCollectionException e) {
            result.setDependencyGraph(e.getResult().getRoot());
            result.setCollectionErrors(e.getResult().getExceptions());
            throw new DependencyResolutionException(result, "Could not resolve dependencies for project " + project.getId() + ": " + e.getMessage(), e);
        }
        depRequest.setRoot(node);
        if (this.logger.isWarnEnabled()) {
            for (DependencyNode child : node.getChildren()) {
                if (child.getRelocations().isEmpty()) continue;
                this.logger.warn("The artifact " + child.getRelocations().get(0) + " has been relocated to " + child.getDependency().getArtifact());
            }
        }
        if (this.logger.isDebugEnabled()) {
            node.accept(new GraphLogger(project));
        }
        try {
            this.process(result, this.repoSystem.resolveDependencies(session, depRequest).getArtifactResults());
        }
        catch (org.sonatype.aether.resolution.DependencyResolutionException e) {
            this.process(result, e.getResult().getArtifactResults());
            throw new DependencyResolutionException(result, "Could not resolve dependencies for project " + project.getId() + ": " + e.getMessage(), e);
        }
        return result;
    }

    private void process(DefaultDependencyResolutionResult result, Collection<ArtifactResult> results) {
        for (ArtifactResult ar : results) {
            DependencyNode node = ar.getRequest().getDependencyNode();
            if (ar.isResolved()) {
                result.addResolvedDependency(node.getDependency());
                continue;
            }
            result.setResolutionErrors(node.getDependency(), ar.getExceptions());
        }
    }

    class GraphLogger
    implements DependencyVisitor {
        private final MavenProject project;
        private String indent = "";
        private Map<String, org.apache.maven.model.Dependency> managed;

        public GraphLogger(MavenProject project) {
            this.project = project;
        }

        public boolean visitEnter(DependencyNode node) {
            StringBuilder buffer = new StringBuilder(128);
            buffer.append(this.indent);
            Dependency dep = node.getDependency();
            if (dep != null) {
                Artifact art = dep.getArtifact();
                buffer.append(art);
                buffer.append(':').append(dep.getScope());
                if (node.getPremanagedScope() != null && !node.getPremanagedScope().equals(dep.getScope())) {
                    buffer.append(" (scope managed from ").append(node.getPremanagedScope());
                    this.appendManagementSource(buffer, art, "scope");
                    buffer.append(")");
                }
                if (node.getPremanagedVersion() != null && !node.getPremanagedVersion().equals(art.getVersion())) {
                    buffer.append(" (version managed from ").append(node.getPremanagedVersion());
                    this.appendManagementSource(buffer, art, "version");
                    buffer.append(")");
                }
            } else {
                buffer.append(this.project.getGroupId());
                buffer.append(':').append(this.project.getArtifactId());
                buffer.append(':').append(this.project.getPackaging());
                buffer.append(':').append(this.project.getVersion());
            }
            DefaultProjectDependenciesResolver.this.logger.debug(buffer.toString());
            this.indent = this.indent + "   ";
            return true;
        }

        public boolean visitLeave(DependencyNode node) {
            this.indent = this.indent.substring(0, this.indent.length() - 3);
            return true;
        }

        private void appendManagementSource(StringBuilder buffer, Artifact artifact, String field) {
            InputSource source;
            InputLocation location;
            String key;
            org.apache.maven.model.Dependency dependency;
            if (this.managed == null) {
                this.managed = new HashMap<String, org.apache.maven.model.Dependency>();
                if (this.project.getDependencyManagement() != null) {
                    for (org.apache.maven.model.Dependency dep : this.project.getDependencyManagement().getDependencies()) {
                        this.managed.put(dep.getManagementKey(), dep);
                    }
                }
            }
            if ((dependency = this.managed.get(key = ArtifacIdUtils.toVersionlessId(artifact.getGroupId(), artifact.getArtifactId(), artifact.getProperty("type", "jar"), artifact.getClassifier()))) != null && (location = dependency.getLocation(field)) != null && (source = location.getSource()) != null) {
                buffer.append(" by ").append(source.getModelId());
            }
        }
    }
}

