/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util;

import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.codehaus.plexus.util.SelectorUtils;

public class MatchPattern {
    private final String source;
    private final String regexPattern;
    private final String separator;
    private final String[] tokenized;

    private MatchPattern(String source, String separator) {
        this.regexPattern = SelectorUtils.isRegexPrefixedPattern((String)source) ? source.substring("%regex[".length(), source.length() - "]".length()) : null;
        this.source = SelectorUtils.isAntPrefixedPattern((String)source) ? source.substring("%ant[".length(), source.length() - "]".length()) : source;
        this.separator = separator;
        this.tokenized = MatchPattern.tokenizePathToString(this.source, separator);
    }

    public boolean matchPath(String str, boolean isCaseSensitive) {
        if (this.regexPattern != null) {
            return str.matches(this.regexPattern);
        }
        return SelectorUtils.matchAntPathPattern((MatchPattern)this, (String)str, (String)this.separator, (boolean)isCaseSensitive);
    }

    boolean matchPath(String str, String[] strDirs, boolean isCaseSensitive) {
        if (this.regexPattern != null) {
            return str.matches(this.regexPattern);
        }
        return SelectorUtils.matchAntPathPattern((String[])this.getTokenizedPathString(), (String[])strDirs, (boolean)isCaseSensitive);
    }

    public boolean matchPatternStart(String str, boolean isCaseSensitive) {
        if (this.regexPattern != null) {
            return true;
        }
        String altStr = this.source.replace('\\', '/');
        return SelectorUtils.matchAntPathPatternStart((MatchPattern)this, (String)str, (String)File.separator, (boolean)isCaseSensitive) || SelectorUtils.matchAntPathPatternStart((MatchPattern)this, (String)altStr, (String)"/", (boolean)isCaseSensitive);
    }

    public String[] getTokenizedPathString() {
        return this.tokenized;
    }

    public boolean startsWith(String string) {
        return this.source.startsWith(string);
    }

    static String[] tokenizePathToString(String path, String separator) {
        ArrayList<String> ret = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(path, separator);
        while (st.hasMoreTokens()) {
            ret.add(st.nextToken());
        }
        return ret.toArray(new String[ret.size()]);
    }

    public static MatchPattern fromString(String source) {
        return new MatchPattern(source, File.separator);
    }
}

