/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.admin;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.ObjectMapper;
import org.jfrog.bamboo.admin.ServerConfig;
import org.jfrog.bamboo.admin.ServerConfigManager;

public class ArtifactoryConfigServlet
extends HttpServlet {
    private Logger log = Logger.getLogger(ArtifactoryConfigServlet.class);
    private ServerConfigManager serverConfigManager;

    public ArtifactoryConfigServlet(ServerConfigManager serverConfigManager) {
        this.serverConfigManager = serverConfigManager;
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        long serverId;
        String serverIdValue = req.getParameter("serverId");
        if (StringUtils.isBlank(serverIdValue)) {
            resp.sendError(400, "Please provide a server ID.");
            this.log.error("Unable to retrieve server configuration information. No server ID was provided.");
            return;
        }
        try {
            serverId = Long.parseLong(serverIdValue);
        }
        catch (NumberFormatException e) {
            resp.sendError(400, "Please provide a valid long-type server ID.");
            this.log.error("Unable to retrieve server configuration information. An invalid server ID was provided (" + serverIdValue + ").");
            return;
        }
        ServerConfig serverConfig = this.serverConfigManager.getServerConfigById(serverId);
        if (serverConfig == null) {
            resp.sendError(404, "Could not find an Artifactory server configuration with the ID " + serverId + ".");
            this.log.error("Unable to retrieve server configuration. No configuration was found with the ID " + serverId + ".");
            return;
        }
        String deployableReposValue = req.getParameter("deployableRepos");
        String resolvingReposValue = req.getParameter("resolvingRepos");
        if (StringUtils.isNotBlank(deployableReposValue) && Boolean.valueOf(deployableReposValue).booleanValue()) {
            List<String> deployableRepoList = this.serverConfigManager.getDeployableRepos(serverId, req, resp);
            this.returnJsonObject(resp, deployableRepoList);
        } else if (StringUtils.isNotBlank(resolvingReposValue) && Boolean.valueOf(resolvingReposValue).booleanValue()) {
            List<String> resolvingRepoList = this.serverConfigManager.getResolvingRepos(serverId, req, resp);
            this.returnJsonObject(resp, resolvingRepoList);
        } else {
            this.returnJsonObject(resp, serverConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnJsonObject(HttpServletResponse resp, Object toReturn) throws IOException {
        JsonFactory jsonFactory = new JsonFactory();
        ObjectMapper mapper = new ObjectMapper();
        jsonFactory.setCodec(mapper);
        PrintWriter writer = null;
        try {
            writer = resp.getWriter();
            JsonGenerator jsonGenerator = jsonFactory.createJsonGenerator(writer);
            jsonGenerator.writeObject(toReturn);
            writer.flush();
        }
        finally {
            IOUtils.closeQuietly(writer);
        }
    }
}

