/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.admin;

import com.atlassian.bamboo.configuration.GlobalAdminAction;
import com.atlassian.bamboo.ww2.aware.permissions.GlobalAdminSecurityAware;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jfrog.bamboo.admin.BintrayConfig;
import org.jfrog.bamboo.admin.ServerConfigManager;
import org.jfrog.bamboo.util.TaskUtils;

public class ConfigureBintrayAction
extends GlobalAdminAction
implements GlobalAdminSecurityAware {
    private static final Logger log = Logger.getLogger(ConfigureBintrayAction.class);
    private String bintrayUsername;
    private String bintrayApiKey;
    private String sonatypeOssUsername;
    private String sonatypeOssPassword;
    private String isSendTest;
    private ServerConfigManager serverConfigManager;
    private BintrayConfig bintrayConfig;

    public ConfigureBintrayAction(ServerConfigManager serverConfigManager) {
        this.serverConfigManager = serverConfigManager;
        if (serverConfigManager != null) {
            this.bintrayConfig = serverConfigManager.getBintrayConfig();
            this.setBintrayConfig(this.bintrayConfig);
        }
    }

    public String execute() throws Exception {
        if (this.isTesting()) {
            this.bintrayTest();
            return "input";
        }
        BintrayConfig newBintrayConf = new BintrayConfig(this.bintrayUsername, this.bintrayApiKey, this.sonatypeOssUsername, this.sonatypeOssPassword);
        this.serverConfigManager.updateBintrayConfiguration(newBintrayConf);
        this.setBintrayConfig(newBintrayConf);
        return "success";
    }

    public void bintrayTest() {
        String bintrayUrl = TaskUtils.getBintrayUrl();
        try {
            int bintrayStatus = TaskUtils.testBintrayConnection(bintrayUrl, this.bintrayUsername, this.bintrayApiKey);
            if (bintrayStatus == 200) {
                this.addActionMessage("Connection with Bintray established successfully!");
            } else {
                this.addActionError("Could not establish connection with Bintray. Server returned status: " + bintrayStatus);
            }
        }
        catch (IOException e) {
            this.addActionError("Error while checking connection to Bintray: " + e.getMessage());
        }
    }

    public String doBrowse() throws Exception {
        return super.execute();
    }

    public String browse() throws Exception {
        return super.execute();
    }

    public void validate() {
        this.clearErrorsAndMessages();
        if (StringUtils.isNotEmpty((CharSequence)this.bintrayUsername)) {
            if (!StringUtils.isNotEmpty((CharSequence)this.bintrayApiKey)) {
                this.addFieldError("bintrayApiKey", "Please specify Bintray API key.");
            }
        } else if (StringUtils.isNotEmpty((CharSequence)this.sonatypeOssUsername)) {
            this.addFieldError("bintrayUsername", "Bintray Username and API key are mandatory for syncing with Maven Central.");
        }
    }

    public BintrayConfig getBintrayConfig() {
        if (this.bintrayConfig == null) {
            if (this.serverConfigManager != null) {
                this.bintrayConfig = this.serverConfigManager.getBintrayConfig();
                this.setBintrayConfig(this.bintrayConfig);
                return this.bintrayConfig;
            }
            this.addActionError("Server manager not loaded!" + new RuntimeException().getStackTrace());
        }
        return new BintrayConfig();
    }

    private void setBintrayConfig(BintrayConfig bintrayConfig) {
        if (bintrayConfig != null) {
            this.bintrayUsername = bintrayConfig.getBintrayUsername();
            this.bintrayApiKey = bintrayConfig.getBintrayApiKey();
            this.sonatypeOssUsername = bintrayConfig.getSonatypeOssUsername();
            this.sonatypeOssPassword = bintrayConfig.getSonatypeOssPassword();
            this.bintrayConfig = bintrayConfig;
        }
    }

    public boolean isMissedMigration() {
        return this.serverConfigManager.isMissedMigration();
    }

    public String getSendTest() {
        return this.isSendTest;
    }

    public void setSendTest(String sendTest) {
        this.isSendTest = sendTest;
    }

    private boolean isTesting() {
        return StringUtils.isNotBlank((CharSequence)this.isSendTest);
    }

    public String getBintrayUsername() {
        return this.bintrayUsername;
    }

    public void setBintrayUsername(String bintrayUsername) {
        this.bintrayUsername = StringUtils.trim((String)bintrayUsername);
    }

    public String getBintrayApiKey() {
        return this.bintrayApiKey;
    }

    public void setBintrayApiKey(String bintrayApiKey) {
        this.bintrayApiKey = bintrayApiKey;
    }

    public String getSonatypeOssUsername() {
        return this.sonatypeOssUsername;
    }

    public void setSonatypeOssUsername(String sonatypeOssUsername) {
        this.sonatypeOssUsername = sonatypeOssUsername;
    }

    public String getSonatypeOssPassword() {
        return this.sonatypeOssPassword;
    }

    public void setSonatypeOssPassword(String sonatypeOssPassword) {
        this.sonatypeOssPassword = sonatypeOssPassword;
    }
}

