/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.admin;

import com.atlassian.bamboo.bandana.BambooBandanaContext;
import com.atlassian.bamboo.bandana.PlanAwareBandanaContext;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.spring.container.ContainerManager;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.ObjectWriter;
import org.jetbrains.annotations.Nullable;
import org.jfrog.bamboo.admin.BintrayConfig;
import org.jfrog.bamboo.admin.ServerConfig;
import org.jfrog.bamboo.security.EncryptionHelper;
import org.jfrog.bamboo.util.BuildInfoLog;
import org.jfrog.bamboo.util.TaskUtils;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryBuildInfoClient;

public class ServerConfigManager
implements Serializable {
    private transient Logger log = Logger.getLogger(ServerConfigManager.class);
    private static final String ARTIFACTORY_CONFIG_KEY = "org.jfrog.bamboo.server.configurations.v2";
    private static final String BINTRAY_CONFIG_KEY = "org.jfrog.bamboo.bintray.configurations.v2";
    private final List<ServerConfig> configuredServers = new CopyOnWriteArrayList<ServerConfig>();
    private BintrayConfig bintrayConfig;
    private BandanaManager bandanaManager = null;
    private AtomicLong nextAvailableId = new AtomicLong(0L);
    private CustomVariableContext customVariableContext;

    public List<ServerConfig> getAllServerConfigs() {
        return Lists.newArrayList(this.configuredServers);
    }

    public ServerConfig getServerConfigById(long id) {
        for (ServerConfig configuredServer : this.configuredServers) {
            if (configuredServer.getId() != id) continue;
            return configuredServer;
        }
        return null;
    }

    public static ServerConfigManager getInstance() {
        ServerConfigManager serverConfigManager = new ServerConfigManager();
        ContainerManager.autowireComponent((Object)serverConfigManager);
        return serverConfigManager;
    }

    public void addServerConfiguration(ServerConfig serverConfig) {
        serverConfig.setId(this.nextAvailableId.getAndIncrement());
        this.configuredServers.add(serverConfig);
        try {
            this.persist();
        }
        catch (UnsupportedEncodingException | IllegalAccessException e) {
            this.log.error("Could not add Artifactory configuration.", e);
        }
    }

    public void deleteServerConfiguration(long id) {
        for (ServerConfig configuredServer : this.configuredServers) {
            if (configuredServer.getId() != id) continue;
            this.configuredServers.remove(configuredServer);
            try {
                this.persist();
            }
            catch (UnsupportedEncodingException | IllegalAccessException e) {
                this.log.error("Could not delete Artifactory configuration.", e);
            }
            break;
        }
    }

    public void updateServerConfiguration(ServerConfig updated) {
        for (ServerConfig configuredServer : this.configuredServers) {
            if (configuredServer.getId() != updated.getId()) continue;
            configuredServer.setUrl(updated.getUrl());
            configuredServer.setUsername(updated.getUsername());
            configuredServer.setPassword(updated.getPassword());
            configuredServer.setTimeout(updated.getTimeout());
            try {
                this.persist();
            }
            catch (UnsupportedEncodingException | IllegalAccessException e) {
                this.log.error("Could not update Artifactory configuration.", e);
            }
            break;
        }
    }

    public void updateBintrayConfiguration(BintrayConfig bintrayConfig) {
        this.bintrayConfig = bintrayConfig;
        try {
            this.persistBintray();
        }
        catch (UnsupportedEncodingException | IllegalAccessException e) {
            this.log.error("Could not update Bintray configuration.", e);
        }
    }

    public void setBandanaManager(BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
        try {
            this.setArtifactoryServers(bandanaManager);
        }
        catch (IOException | IllegalAccessException | InstantiationException e) {
            this.log.error("Could not load Artifactory configuration.", e);
        }
        try {
            this.setBintrayConfigurations(bandanaManager);
        }
        catch (IOException | IllegalAccessException | InstantiationException e) {
            this.log.error("Could not load Bintray configuration.", e);
        }
    }

    public boolean isMissedMigration() {
        Iterator keysIterator = this.bandanaManager.getKeys((com.atlassian.bandana.BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT).iterator();
        boolean isMissedMigration = false;
        while (keysIterator.hasNext()) {
            String key = (String)keysIterator.next();
            if (key.equals(ARTIFACTORY_CONFIG_KEY) || key.equals(BINTRAY_CONFIG_KEY)) {
                return false;
            }
            if (isMissedMigration) continue;
            isMissedMigration = key.contains("org.jfrog.bamboo");
        }
        return isMissedMigration;
    }

    private void setBintrayConfigurations(BandanaManager bandanaManager) throws IOException, InstantiationException, IllegalAccessException {
        String existingBintrayConfig = (String)bandanaManager.getValue((com.atlassian.bandana.BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, BINTRAY_CONFIG_KEY);
        if (existingBintrayConfig != null && !"".equals(existingBintrayConfig)) {
            BintrayConfig tempBintrayConfig = this.getObjectFromStringXml(existingBintrayConfig, BintrayConfig.class);
            ObjectWriter ow = new ObjectMapper().writer().withDefaultPrettyPrinter();
            String json = ow.writeValueAsString(tempBintrayConfig);
            tempBintrayConfig = new ObjectMapper().readValue(json, BintrayConfig.class);
            this.bintrayConfig = this.decryptExistingBintrayConfig(tempBintrayConfig);
        }
    }

    private void setArtifactoryServers(BandanaManager bandanaManager) throws IOException, InstantiationException, IllegalAccessException {
        String existingArtifactoryConfig = (String)bandanaManager.getValue((com.atlassian.bandana.BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, ARTIFACTORY_CONFIG_KEY);
        if (StringUtils.isNotBlank(existingArtifactoryConfig)) {
            List<ServerConfig> serverConfigList = this.getServersFromXml(existingArtifactoryConfig);
            for (ServerConfig serverConfig : serverConfigList) {
                ObjectWriter ow = new ObjectMapper().writer().withDefaultPrettyPrinter();
                String json = ow.writeValueAsString(serverConfig);
                ServerConfig tempServerConfig = new ObjectMapper().readValue(json, ServerConfig.class);
                if (this.nextAvailableId.get() <= tempServerConfig.getId()) {
                    this.nextAvailableId.set(tempServerConfig.getId() + 1L);
                }
                this.configuredServers.add(new ServerConfig(tempServerConfig.getId(), tempServerConfig.getUrl(), tempServerConfig.getUsername(), EncryptionHelper.decrypt(tempServerConfig.getPassword()), tempServerConfig.getTimeout()));
            }
        }
    }

    private BintrayConfig decryptExistingBintrayConfig(BintrayConfig bintrayConfig) {
        String bintrayApi = bintrayConfig.getBintrayApiKey();
        String sonatypeOssPassword = bintrayConfig.getSonatypeOssPassword();
        bintrayApi = TaskUtils.decryptIfNeeded(bintrayApi);
        sonatypeOssPassword = TaskUtils.decryptIfNeeded(sonatypeOssPassword);
        return new BintrayConfig(bintrayConfig.getBintrayUsername(), bintrayApi, bintrayConfig.getSonatypeOssUsername(), sonatypeOssPassword);
    }

    public void setBintrayConfig(BintrayConfig bintrayConfig) {
        this.bintrayConfig = bintrayConfig;
    }

    public BintrayConfig getBintrayConfig() {
        return this.bintrayConfig;
    }

    public List<String> getDeployableRepos(long serverId) {
        return this.getDeployableRepos(serverId, null, null);
    }

    public List<String> getDeployableRepos(long serverId, HttpServletRequest req, HttpServletResponse resp) {
        ServerConfig serverConfig = this.getServerConfigById(serverId);
        if (serverConfig == null) {
            this.log.error("Error while retrieving target repository list: Could not find Artifactory server configuration by the ID " + serverId);
            return Lists.newArrayList();
        }
        String serverUrl = this.substituteVariables(serverConfig.getUrl());
        String username = null;
        String password = null;
        if (req != null) {
            username = req.getParameter("user");
            password = req.getParameter("password");
        }
        if (StringUtils.isNotBlank(username) && StringUtils.isNotBlank(password)) {
            password = TaskUtils.decryptIfNeeded(password);
        } else {
            username = serverConfig.getUsername();
            password = serverConfig.getPassword();
        }
        username = this.substituteVariables(username);
        password = this.substituteVariables(password);
        ArtifactoryBuildInfoClient client = StringUtils.isBlank(username) ? new ArtifactoryBuildInfoClient(serverUrl, new BuildInfoLog(this.log)) : new ArtifactoryBuildInfoClient(serverUrl, username, password, new BuildInfoLog(this.log));
        client.setConnectionTimeout(serverConfig.getTimeout());
        try {
            return client.getLocalRepositoriesKeys();
        }
        catch (IOException ioe) {
            this.log.error("Error while retrieving target repository list from: " + serverUrl, ioe);
            try {
                if (resp != null && ioe.getMessage().contains("401")) {
                    resp.sendError(401);
                }
                if (resp != null && ioe.getMessage().contains("404")) {
                    resp.sendError(404);
                }
            }
            catch (IOException e) {
                this.log.error("Error while sending error to response", e);
            }
            return Lists.newArrayList();
        }
    }

    public String substituteVariables(String s) {
        return s != null ? this.customVariableContext.substituteString(s) : null;
    }

    public List<String> getResolvingRepos(long serverId, HttpServletRequest req, HttpServletResponse resp) {
        String password;
        String username;
        ServerConfig serverConfig = this.getServerConfigById(serverId);
        if (serverConfig == null) {
            this.log.error("Error while retrieving resolving repository list: Could not find Artifactory server configuration by the ID " + serverId);
            return Lists.newArrayList();
        }
        String serverUrl = this.substituteVariables(serverConfig.getUrl());
        if (StringUtils.isNotBlank(req.getParameter("user")) && StringUtils.isNotBlank(req.getParameter("password"))) {
            username = this.substituteVariables(req.getParameter("user"));
            password = this.substituteVariables(TaskUtils.decryptIfNeeded(req.getParameter("password")));
        } else {
            username = this.substituteVariables(serverConfig.getUsername());
            password = this.substituteVariables(serverConfig.getPassword());
        }
        ArtifactoryBuildInfoClient client = StringUtils.isBlank(username) ? new ArtifactoryBuildInfoClient(serverUrl, new BuildInfoLog(this.log)) : new ArtifactoryBuildInfoClient(serverUrl, username, password, new BuildInfoLog(this.log));
        client.setConnectionTimeout(serverConfig.getTimeout());
        try {
            return client.getVirtualRepositoryKeys();
        }
        catch (IOException ioe) {
            this.log.error("Error while retrieving resolving repository list from: " + serverUrl, ioe);
            try {
                if (ioe.getMessage().contains("401")) {
                    resp.sendError(401);
                }
                if (ioe.getMessage().contains("404")) {
                    resp.sendError(404);
                }
            }
            catch (IOException e) {
                this.log.error("Error while sending error to response", e);
            }
            return Lists.newArrayList();
        }
    }

    private synchronized void persist() throws IllegalAccessException, UnsupportedEncodingException {
        ArrayList<ServerConfig> serverConfigs = Lists.newArrayList();
        for (ServerConfig serverConfig : this.configuredServers) {
            serverConfigs.add(new ServerConfig(serverConfig.getId(), serverConfig.getUrl(), serverConfig.getUsername(), EncryptionHelper.encrypt(serverConfig.getPassword()), serverConfig.getTimeout()));
        }
        String serverConfigsString = this.toXMLString(serverConfigs);
        this.bandanaManager.setValue((com.atlassian.bandana.BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, ARTIFACTORY_CONFIG_KEY, (Object)serverConfigsString);
    }

    private synchronized void persistBintray() throws IllegalAccessException, UnsupportedEncodingException {
        if (this.bintrayConfig != null) {
            String stringbintrayConfig = this.toXMLString(this.createEncryptedBintrayConfig(this.bintrayConfig));
            this.bandanaManager.setValue((com.atlassian.bandana.BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, BINTRAY_CONFIG_KEY, (Object)stringbintrayConfig);
        }
    }

    private BintrayConfig createEncryptedBintrayConfig(BintrayConfig bintrayConfig) {
        BintrayConfig encConfig = new BintrayConfig();
        String apiKey = EncryptionHelper.encrypt(bintrayConfig.getBintrayApiKey());
        String sonatypeOssPassword = bintrayConfig.getSonatypeOssPassword();
        encConfig.setBintrayApiKey(apiKey);
        encConfig.setSonatypeOssPassword(EncryptionHelper.encrypt(sonatypeOssPassword));
        encConfig.setBintrayUsername(bintrayConfig.getBintrayUsername());
        encConfig.setSonatypeOssUsername(bintrayConfig.getSonatypeOssUsername());
        return encConfig;
    }

    public void setCustomVariableContext(CustomVariableContext customVariableContext) {
        this.customVariableContext = customVariableContext;
    }

    private List<ServerConfig> getServersFromXml(String stringXml) throws IllegalAccessException, InstantiationException {
        ArrayList<ServerConfig> serverConfigs = Lists.newArrayList();
        List<String> stringServerConfigs = this.findAllObjects(ServerConfig.class, stringXml);
        for (String stringServerConfig : stringServerConfigs) {
            serverConfigs.add(this.getObjectFromStringXml(stringServerConfig, ServerConfig.class));
        }
        return serverConfigs;
    }

    private <T> T getObjectFromStringXml(String stringT, Class<T> tClass) throws IllegalAccessException, InstantiationException {
        T object = tClass.newInstance();
        for (Field field : tClass.getDeclaredFields()) {
            boolean accsessable = field.isAccessible();
            field.setAccessible(true);
            String value = this.findFirstObject(field.getName(), stringT, true);
            if (field.getType().equals(Long.TYPE)) {
                field.set(object, Long.parseLong(value));
            } else if (field.getType().equals(Integer.TYPE)) {
                field.set(object, Integer.parseInt(value));
            } else {
                field.set(object, this.findFirstObject(field.getName(), stringT, true));
            }
            field.setAccessible(accsessable);
        }
        return object;
    }

    private List<String> findAllObjects(Class providedClass, String scannedString) {
        ArrayList<String> foundStrings = Lists.newArrayList();
        String foundString = this.findFirstObject(providedClass.getSimpleName(), scannedString, false);
        while (!"".equals(foundString)) {
            foundStrings.add(foundString);
            scannedString = scannedString.replaceFirst(foundString, "");
            foundString = this.findFirstObject(providedClass.getSimpleName(), scannedString, false);
        }
        return foundStrings;
    }

    private String findFirstObject(String objectToFind, String stringToScan, boolean dataOnly) {
        String patternString = String.format("<%s>?(.*?)</%s>", objectToFind, objectToFind);
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(stringToScan);
        if (matcher.find()) {
            if (dataOnly) {
                return new String(Base64.getDecoder().decode(matcher.group(1).getBytes()));
            }
            return matcher.group(0);
        }
        return "";
    }

    private String toXMLString(List<ServerConfig> serverConfigs) throws IllegalAccessException, UnsupportedEncodingException {
        StringBuilder stringBuilder = new StringBuilder();
        this.openTag(stringBuilder, "List");
        for (ServerConfig serverConfig : serverConfigs) {
            stringBuilder.append(this.toXMLString(serverConfig));
        }
        this.closeTag(stringBuilder, "List");
        return stringBuilder.toString();
    }

    private String toXMLString(Object object) throws IllegalAccessException, UnsupportedEncodingException {
        StringBuilder stringBuilder = new StringBuilder();
        this.openTag(stringBuilder, object.getClass().getSimpleName());
        for (Field field : object.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            String value = field.get(object) == null ? "" : field.get(object).toString();
            this.appendAttribute(stringBuilder, field.getName(), value);
        }
        this.closeTag(stringBuilder, object.getClass().getSimpleName());
        return stringBuilder.toString();
    }

    private void appendAttribute(StringBuilder stringBuilder, String field, String value) throws UnsupportedEncodingException {
        this.openTag(stringBuilder, field);
        stringBuilder.append(Base64.getEncoder().encodeToString(value.getBytes("utf-8")));
        this.closeTag(stringBuilder, field);
    }

    private void openTag(StringBuilder stringBuilder, String fieldName) {
        stringBuilder.append("<");
        stringBuilder.append(fieldName);
        stringBuilder.append(">");
    }

    private void closeTag(StringBuilder stringBuilder, String fieldName) {
        stringBuilder.append("</");
        stringBuilder.append(fieldName);
        stringBuilder.append(">");
    }

    public class BandanaContext
    extends PlanAwareBandanaContext {
        public BandanaContext(BambooBandanaContext parentContext, @Nullable long planId, String pluginKey) {
            super(parentContext, planId, pluginKey);
        }
    }
}

