/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.bintray;

import com.atlassian.bamboo.build.ViewBuildResults;
import com.atlassian.bamboo.plugin.RemoteAgentSupported;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jfrog.bamboo.admin.BintrayConfig;
import org.jfrog.bamboo.admin.ServerConfig;
import org.jfrog.bamboo.bintray.PushToBintrayRunnable;
import org.jfrog.bamboo.bintray.client.BintrayClient;
import org.jfrog.bamboo.promotion.PromotionContext;
import org.jfrog.bamboo.util.TaskUtils;

@RemoteAgentSupported
public class BintrayPushAction
extends ViewBuildResults {
    public static Logger log = Logger.getLogger(BintrayPushAction.class);
    public static PromotionContext context = new PromotionContext();
    private static final String BINTRAY_CONFIG_PREFIX = "bintray.";
    private static Map<String, String> signMethodList = ImmutableMap.of("false", "Don't Sign", "true", "Sign", "descriptor", "According to descriptor file");
    private static BintrayClient bintrayClient;
    private boolean pushing = true;
    private boolean overrideDescriptorFile;
    private String subject;
    private String repository;
    private String packageName;
    private String version;
    private String licenses;
    private String vcsUrl;
    private String gpgPassphrase;
    private String signMethod;
    private boolean mavenSync;

    public String execute() throws Exception {
        context.clearLog();
        String result = super.execute();
        if ("error".equals(result)) {
            return "error";
        }
        try {
            context.setBuildNumber(this.getBuildNumber());
            context.setBuildKey(this.getImmutableBuild().getName());
            BintrayConfig bintrayConfig = TaskUtils.getBintrayConfig();
            bintrayClient = new BintrayClient(bintrayConfig);
            Map<String, String> buildTaskConfiguration = TaskUtils.findConfigurationForBuildTask(this);
            this.addDefaultValuesForInput(buildTaskConfiguration);
            return "input";
        }
        catch (Exception e) {
            log.error("Error occurred while loading Push to Bintray configuration page.", e);
            return "error";
        }
    }

    public String push() {
        String result;
        ServerConfig serverConfig = TaskUtils.getArtifactoryServerConfig(this.getImmutablePlan());
        try {
            new Thread(new PushToBintrayRunnable(this, serverConfig, bintrayClient)).start();
            this.pushing = false;
            result = "success";
        }
        catch (Exception e) {
            result = "error";
        }
        return result;
    }

    public String getPushToBintrayLog() {
        return "success";
    }

    private boolean validPushToBintrayFields() {
        return StringUtils.isNotBlank(this.packageName);
    }

    public Map<String, String> getSignMethodList() {
        return signMethodList;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getGpgPassphrase() {
        return this.gpgPassphrase;
    }

    public void setGpgPassphrase(String gpgPassphrase) {
        this.gpgPassphrase = gpgPassphrase;
    }

    public String getLicenses() {
        return this.licenses;
    }

    public void setLicenses(String licenses) {
        this.licenses = licenses;
    }

    public String getVcsUrl() {
        return this.vcsUrl;
    }

    public void setVcsUrl(String vcsUrl) {
        this.vcsUrl = vcsUrl;
    }

    public String getRepository() {
        return this.repository;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public String getSignMethod() {
        return this.signMethod;
    }

    public void setSignMethod(String signMethod) {
        this.signMethod = signMethod;
    }

    public String isOverrideDescriptorFile() {
        return String.valueOf(this.overrideDescriptorFile);
    }

    public void setOverrideDescriptorFile(boolean overrideDescriptorFile) {
        this.overrideDescriptorFile = overrideDescriptorFile;
    }

    public boolean getOverrideDescriptorFile() {
        return this.overrideDescriptorFile;
    }

    public boolean isMavenSync() {
        return this.mavenSync;
    }

    public void setMavenSync(boolean mavenSync) {
        this.mavenSync = mavenSync;
    }

    public boolean isPushing() {
        return this.pushing;
    }

    public void setPushing(boolean pushing) {
        this.pushing = pushing;
    }

    public List<String> getResult() {
        return context.getLog();
    }

    public boolean isDone() {
        return context.isDone();
    }

    private void addDefaultValuesForInput(Map<String, String> buildTaskConfiguration) throws IllegalAccessException, NoSuchFieldException {
        this.setSubject(buildTaskConfiguration.get("bintray.subject"));
        this.setRepository(buildTaskConfiguration.get("bintray.repository"));
        this.setPackageName(buildTaskConfiguration.get("bintray.packageName"));
        this.setLicenses(buildTaskConfiguration.get("bintray.licenses"));
        this.setSignMethod(buildTaskConfiguration.get("bintray.signMethod"));
        this.setVcsUrl(buildTaskConfiguration.get("bintray.vcsUrl"));
        this.setGpgPassphrase(buildTaskConfiguration.get("bintray.gpgSign"));
        this.setMavenSync(Boolean.valueOf(buildTaskConfiguration.get("bintray.mavenSync")));
        this.setOverrideDescriptorFile(Boolean.valueOf(buildTaskConfiguration.get("bintrayConfiguration")));
    }
}

