/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.bintray;

import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.bamboo.bintray.BintrayPushAction;

public class MavenSyncHelper {
    public static void updateBintrayActionContext(BintrayPushAction action, Map<String, Object> bintrayJsonMap) {
        Map aPackage = (Map)bintrayJsonMap.get("package");
        action.setPackageName((String)aPackage.get("name"));
        action.setRepository((String)aPackage.get("repo"));
        action.setSubject((String)aPackage.get("subject"));
        Map version = (Map)bintrayJsonMap.get("version");
        action.setVersion((String)version.get("name"));
    }

    public static String getBintrayDescriptorFileUrl(Map<String, Object> response) {
        ArrayList results = (ArrayList)response.get("results");
        if (results.size() == 0) {
            throw new IllegalStateException("No Bintray descriptor files were find in the build.");
        }
        Map jsonUrl = (Map)results.get(0);
        return (String)jsonUrl.get("downloadUri");
    }

    public static String createArtifactBuildSearchQuery(String buildName, String buildNumber) {
        return "{\n    \"buildName\": \"" + buildName + "\",\n    \"buildNumber\":  \"" + buildNumber + "\",\n    \"mappings\": [\n        {\n            \"input\": \"(?i)[\\\\s\\\\S]*bintray-info[\\\\s\\\\S]*.json\"\n        }\n    ]\n}";
    }

    public static String getMavenSyncEndpoint() {
        String bintrayUrl = System.getenv("BAMBOO_BINTRAY_URL");
        if (StringUtils.isEmpty((CharSequence)bintrayUrl)) {
            bintrayUrl = "https://api.bintray.com/";
        }
        return bintrayUrl + "/maven_central_sync/";
    }
}

