/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.bintray;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jfrog.bamboo.admin.ServerConfig;
import org.jfrog.bamboo.bintray.BintrayPushAction;
import org.jfrog.bamboo.bintray.MavenSyncHelper;
import org.jfrog.bamboo.bintray.client.BintrayClient;
import org.jfrog.bamboo.util.ActionLog;
import org.jfrog.bamboo.util.BuildInfoLog;
import org.jfrog.build.api.release.BintrayUploadInfoOverride;
import org.jfrog.build.client.ArtifactoryVersion;
import org.jfrog.build.client.bintrayResponse.BintrayResponse;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryBaseClient;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryBuildInfoClient;

public class PushToBintrayRunnable
implements Runnable {
    private static final String MINIMAL_SUPPORTED_VERSION = "3.6";
    private Logger log = Logger.getLogger(PushToBintrayRunnable.class);
    private BintrayClient bintrayClient;
    private ServerConfig serverConfig;
    private BintrayPushAction action;
    private ActionLog bintrayLog;
    private String buildName;
    private String buildNumber;

    public PushToBintrayRunnable(BintrayPushAction bintrayPushAction, ServerConfig serverConfig, BintrayClient bintrayClient) {
        this.action = bintrayPushAction;
        this.serverConfig = serverConfig;
        this.bintrayClient = bintrayClient;
        this.bintrayLog = BintrayPushAction.context.getActionLog();
        this.buildName = BintrayPushAction.context.getBuildKey();
        this.buildNumber = Integer.toString(BintrayPushAction.context.getBuildNumber());
    }

    @Override
    public void run() {
        ArtifactoryBaseClient artifactoryClient = null;
        try {
            this.bintrayLog.logMessage("Starting Push to Bintray action.");
            BintrayPushAction.context.getLock().lock();
            BintrayPushAction.context.setDone(false);
            artifactoryClient = this.getArtifactoryBuildInfoClient();
            if (!this.isValidArtifactoryVersion((ArtifactoryBuildInfoClient)artifactoryClient)) {
                this.bintrayLog.logError("Push to Bintray supported from Artifactory version 3.6");
                BintrayPushAction.context.setDone(true);
                return;
            }
            this.performPushToBintray((ArtifactoryBuildInfoClient)artifactoryClient);
            if (this.action.isMavenSync()) {
                this.bintrayLog.logMessage("Starting MavenSync.");
                this.mavenCentralSync();
            }
        }
        catch (Exception e) {
            this.bintrayLog.logError("Error while trying to Push build to Bintray.", e);
            this.log.error("Error while trying to Push build to Bintray.", e);
        }
        finally {
            if (artifactoryClient != null) {
                artifactoryClient.close();
            }
            BintrayPushAction.context.setDone(true);
            BintrayPushAction.context.getLock().unlock();
        }
    }

    private void performPushToBintray(ArtifactoryBuildInfoClient artifactoryClient) {
        BintrayResponse response;
        String subject = this.action.getSubject();
        String repoName = this.action.getRepository();
        String packageName = this.action.getPackageName();
        String versionName = this.action.getVersion();
        String vcsUrl = this.action.getVcsUrl();
        String signMethod = this.action.getSignMethod();
        String passphrase = this.action.getGpgPassphrase();
        List<String> licenses = this.createLicensesListFromString(this.action.getLicenses());
        BintrayUploadInfoOverride uploadInfoOverride = new BintrayUploadInfoOverride(subject, repoName, packageName, versionName, licenses, vcsUrl);
        try {
            response = artifactoryClient.pushToBintray(this.buildName, this.buildNumber, signMethod, passphrase, uploadInfoOverride);
            this.bintrayLog.logMessage(response.toString());
            this.log.info("Push to Bintray finished: " + response.toString());
        }
        catch (Exception e) {
            throw new RuntimeException("Push to Bintray failed with Exception.", e);
        }
        if (!response.isSuccessful()) {
            throw new RuntimeException("Push to Bintray failed with Exception");
        }
    }

    private void mavenCentralSync() {
        if (!Boolean.valueOf(this.action.isOverrideDescriptorFile()).booleanValue()) {
            this.prepareMavenCentralSync();
        }
        try {
            this.bintrayLog.logMessage("Syncing version to Maven Central.");
            String response = this.bintrayClient.mavenCentralSync(this.action.getSubject(), this.action.getRepository(), this.action.getPackageName(), this.action.getVersion());
            this.bintrayLog.logMessage(response);
        }
        catch (Exception e) {
            this.bintrayLog.logError("Error while trying to sync with Maven Central", e);
            this.log.error("Error while trying to sync with Maven Central", e);
        }
    }

    private void prepareMavenCentralSync() {
        Map<String, Object> response = this.bintrayClient.getBintrayJsonFileLocation(this.serverConfig, this.buildName, this.buildNumber);
        String fileUrl = MavenSyncHelper.getBintrayDescriptorFileUrl(response);
        Map<String, Object> bintrayJsonMap = this.bintrayClient.downloadBintrayInfoDescriptor(this.serverConfig, fileUrl);
        MavenSyncHelper.updateBintrayActionContext(this.action, bintrayJsonMap);
    }

    private boolean isValidArtifactoryVersion(ArtifactoryBuildInfoClient client) {
        boolean validVersion = false;
        try {
            ArtifactoryVersion version = client.verifyCompatibleArtifactoryVersion();
            validVersion = version.isAtLeast(new ArtifactoryVersion(MINIMAL_SUPPORTED_VERSION));
        }
        catch (Exception e) {
            this.bintrayLog.logError("Error while checking Artifactory version", e);
            this.log.error("Error while checking Artifactory version", e);
        }
        return validVersion;
    }

    private ArtifactoryBuildInfoClient getArtifactoryBuildInfoClient() {
        String username = this.serverConfig.getUsername();
        String password = this.serverConfig.getPassword();
        String artifactoryUrl = this.serverConfig.getUrl();
        return new ArtifactoryBuildInfoClient(artifactoryUrl, username, password, new BuildInfoLog(this.log));
    }

    private List<String> createLicensesListFromString(String licenses) {
        String[] licensesArray = StringUtils.split(licenses, ",");
        for (int i = 0; i < licensesArray.length; ++i) {
            licensesArray[i] = licensesArray[i].trim();
        }
        return Lists.newArrayList(licensesArray);
    }
}

