/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.builder;

import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.util.BuildUtils;
import com.atlassian.bamboo.utils.EscapeChars;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.trigger.DependencyTriggerReason;
import com.atlassian.bamboo.v2.build.trigger.ManualBuildTriggerReason;
import com.atlassian.bamboo.v2.build.trigger.TriggerReason;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jfrog.bamboo.admin.ServerConfig;
import org.jfrog.bamboo.builder.BaseBuildInfoHelper;
import org.jfrog.bamboo.configuration.BuildParamsOverrideManager;
import org.jfrog.bamboo.context.AbstractBuildContext;
import org.jfrog.bamboo.util.TaskUtils;
import org.jfrog.bamboo.util.version.VcsHelper;
import org.jfrog.build.api.util.NullLog;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.build.extractor.clientConfiguration.IncludeExcludePatterns;
import org.joda.time.DateTime;

public abstract class ArtifactoryBuildInfoDataHelper
extends BaseBuildInfoHelper {
    private static final Logger log = Logger.getLogger(ArtifactoryBuildInfoDataHelper.class);
    protected ServerConfig serverConfig;
    protected ArtifactoryClientConfiguration clientConf;

    public ArtifactoryBuildInfoDataHelper(BuildParamsOverrideManager buildParamsOverrideManager, TaskContext context, AbstractBuildContext abstractBuildContext, EnvironmentVariableAccessor envVarAccessor, String artifactoryPluginVersion) {
        BuildContext buildContext = context.getBuildContext();
        super.init(buildParamsOverrideManager, buildContext);
        long selectedServerId = abstractBuildContext.getArtifactoryServerId();
        if (selectedServerId != -1L) {
            this.serverConfig = this.serverConfigManager.getServerConfigById(selectedServerId);
            if (this.serverConfig == null) {
                String warning = "Found an ID of a selected Artifactory server configuration (" + selectedServerId + ") but could not find a matching configuration. Build info collection is disabled.";
                context.getBuildLogger().addErrorLogEntry(warning);
                log.warn(warning);
                return;
            }
            this.clientConf = new ArtifactoryClientConfiguration(new NullLog());
            this.setBuilderData(abstractBuildContext, this.serverConfig, this.clientConf, envVarAccessor.getEnvironment((CommonTaskContext)context), envVarAccessor.getEnvironment(), artifactoryPluginVersion);
            this.setDataToContext(buildContext, abstractBuildContext);
        }
    }

    private void setDataToContext(BuildContext context, AbstractBuildContext buildContext) {
        String serverUrl = this.serverConfigManager.substituteVariables(this.serverConfig.getUrl());
        context.getBuildResult().getCustomBuildData().put("org.jfrog.bamboo.buildInfo.activated", "true");
        context.getBuildResult().getCustomBuildData().put("org.jfrog.bamboo.buildInfo.serverUrl", serverUrl);
        context.getBuildResult().getCustomBuildData().put("org.jfrog.bamboo.release.activated", String.valueOf(buildContext.releaseManagementContext.isActivateReleaseManagement()));
    }

    public String createBuildInfoPropsFileAndGetItsPath() throws IOException {
        if (this.serverConfig == null) {
            return null;
        }
        try {
            File tempPropertiesFile = File.createTempFile("buildInfo", ".properties");
            this.clientConf.setPropertiesFile(tempPropertiesFile.getAbsolutePath());
            this.clientConf.persistToPropertiesFile();
            return tempPropertiesFile.getCanonicalPath();
        }
        catch (IOException e) {
            log.error("Error occurred while writing build info properties to a temp file. Build info collection is disabled.", e);
            throw e;
        }
    }

    @NotNull
    public Map<String, String> getPasswordsMap(AbstractBuildContext buildContext) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (this.serverConfig == null) {
            return result;
        }
        String password = this.overrideParam(buildContext.getDeployerPassword(), "artifactory.override.deployer.password");
        if (StringUtils.isBlank(password)) {
            password = this.serverConfig.getPassword();
        }
        result.put(this.clientConf.publisher.getPrefix() + "password", password);
        return result;
    }

    private void setBuilderData(AbstractBuildContext buildContext, ServerConfig serverConfig, ArtifactoryClientConfiguration clientConf, Map<String, String> environment, Map<String, String> generalEnv, String pluginVersion) {
        String vcsUrl;
        String buildName = this.context.getPlanName();
        clientConf.info.setArtifactoryPluginVersion(pluginVersion);
        clientConf.info.setBuildName(buildName);
        clientConf.publisher.addMatrixParam("build.name", buildName);
        String buildNumber = String.valueOf(this.context.getBuildNumber());
        clientConf.info.setBuildNumber(buildNumber);
        clientConf.publisher.addMatrixParam("build.number", buildNumber);
        String vcsRevision = VcsHelper.getRevisionKey(this.context);
        if (StringUtils.isNotBlank(vcsRevision)) {
            clientConf.info.setVcsRevision(vcsRevision);
            clientConf.publisher.addMatrixParam("vcs.revision", vcsRevision);
        }
        if (StringUtils.isNotBlank(vcsUrl = VcsHelper.getVcsUrl(this.context))) {
            clientConf.info.setVcsUrl(vcsUrl);
        }
        String buildTimeStampVal = (String)this.context.getBuildResult().getCustomBuildData().get("buildTimeStamp");
        long buildTimeStamp = System.currentTimeMillis();
        if (StringUtils.isNotBlank(buildTimeStampVal)) {
            buildTimeStamp = new DateTime((Object)buildTimeStampVal).getMillis();
        }
        String buildTimeStampString = String.valueOf(buildTimeStamp);
        clientConf.info.setBuildTimestamp(buildTimeStampString);
        clientConf.publisher.addMatrixParam("build.timestamp", buildTimeStampString);
        clientConf.setActivateRecorder(true);
        StringBuilder summaryUrlBuilder = new StringBuilder(this.bambooBaseUrl);
        if (!this.bambooBaseUrl.endsWith("/")) {
            summaryUrlBuilder.append("/");
        }
        String buildUrl = summaryUrlBuilder.append("browse/").append(EscapeChars.forFormSubmission((String)this.context.getPlanResultKey().getKey())).toString();
        clientConf.info.setBuildUrl(buildUrl);
        this.setBuildParentData(clientConf, this.context.getTriggerReason());
        String principal = this.getTriggeringUserNameRecursively(this.context);
        if (StringUtils.isBlank(principal)) {
            principal = "auto";
        }
        clientConf.info.setPrincipal(principal);
        clientConf.info.setAgentName("Bamboo");
        clientConf.info.setAgentVersion(BuildUtils.getVersionAndBuild());
        clientConf.info.licenseControl.setRunChecks(buildContext.isRunLicenseChecks());
        clientConf.info.licenseControl.setViolationRecipients(buildContext.getLicenseViolationRecipients());
        clientConf.info.licenseControl.setScopes(buildContext.getScopes());
        clientConf.info.licenseControl.setIncludePublishedArtifacts(buildContext.isIncludePublishedArtifacts());
        clientConf.info.licenseControl.setAutoDiscover(!buildContext.isDisableAutomaticLicenseDiscovery());
        clientConf.info.setReleaseEnabled(buildContext.releaseManagementContext.isActivateReleaseManagement());
        clientConf.info.setReleaseComment(buildContext.releaseManagementContext.getStagingComment());
        try {
            BeanUtils.copyProperties((Object)clientConf.info.blackDuckProperties, (Object)buildContext.blackDuckProperties);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not integrate black duck properties", e);
        }
        this.setClientData(buildContext, clientConf, serverConfig, environment);
        this.setPublisherData(buildContext, clientConf, serverConfig, environment);
        Map<String, String> props = Maps.newHashMap(environment);
        props.putAll(generalEnv);
        props = TaskUtils.getEscapedEnvMap(props);
        props.putAll(this.getBuildInfoConfigPropertiesFileParams(props.get("buildInfoConfig.propertiesFile")));
        IncludeExcludePatterns patterns = new IncludeExcludePatterns(buildContext.getEnvVarsIncludePatterns(), buildContext.getEnvVarsExcludePatterns());
        clientConf.info.addBuildVariables(props, patterns);
        clientConf.fillFromProperties(props, patterns);
    }

    private String getTriggeringUserNameRecursively(BuildContext context) {
        BuildContext parentContext;
        String principal = null;
        TriggerReason triggerReason = context.getTriggerReason();
        if (triggerReason instanceof ManualBuildTriggerReason && StringUtils.isBlank(principal = ((ManualBuildTriggerReason)triggerReason).getUserName()) && (parentContext = context.getParentBuildContext()) != null) {
            principal = this.getTriggeringUserNameRecursively(parentContext);
        }
        return principal;
    }

    private void setBuildParentData(ArtifactoryClientConfiguration clientConf, TriggerReason triggerReason) {
        String triggeringBuildResultKey;
        if (triggerReason instanceof DependencyTriggerReason && StringUtils.isNotBlank(triggeringBuildResultKey = ((DependencyTriggerReason)triggerReason).getTriggeringBuildResultKey()) && StringUtils.split(triggeringBuildResultKey, "-").length == 3) {
            String triggeringBuildKey = triggeringBuildResultKey.substring(0, triggeringBuildResultKey.lastIndexOf("-"));
            String triggeringBuildNumber = triggeringBuildResultKey.substring(triggeringBuildResultKey.lastIndexOf("-") + 1);
            String parentBuildName = this.getBuildName(triggeringBuildKey);
            if (StringUtils.isBlank(parentBuildName)) {
                log.error("Received a null build parent name.");
            }
            clientConf.info.setParentBuildName(parentBuildName);
            clientConf.publisher.addMatrixParam("build.parentName", parentBuildName);
            clientConf.info.setParentBuildNumber(triggeringBuildNumber);
            clientConf.publisher.addMatrixParam("build.parentNumber", triggeringBuildNumber);
        }
    }

    protected abstract void setClientData(AbstractBuildContext var1, ArtifactoryClientConfiguration var2, ServerConfig var3, Map<String, String> var4);

    private void setPublisherData(AbstractBuildContext buildContext, ArtifactoryClientConfiguration clientConf, ServerConfig serverConfig, Map<String, String> environment) {
        String serverUrl = this.serverConfigManager.substituteVariables(serverConfig.getUrl());
        clientConf.publisher.setContextUrl(serverUrl);
        clientConf.setTimeout(serverConfig.getTimeout());
        String deployerUsername = this.overrideParam(buildContext.getDeployerUsername(), "artifactory.override.deployer.username");
        if (StringUtils.isBlank(deployerUsername)) {
            deployerUsername = serverConfig.getUsername();
        }
        if (StringUtils.isNotBlank(deployerUsername)) {
            clientConf.publisher.setUsername(deployerUsername);
        }
        clientConf.publisher.setRepoKey(this.getPublishingRepoKey(buildContext, environment));
        clientConf.publisher.setPublishArtifacts(buildContext.isPublishArtifacts());
        clientConf.publisher.setIncludePatterns(buildContext.getIncludePattern());
        clientConf.publisher.setExcludePatterns(buildContext.getExcludePattern());
        clientConf.publisher.setFilterExcludedArtifactsFromBuild(buildContext.isFilterExcludedArtifactsFromBuild());
        clientConf.publisher.setPublishBuildInfo(buildContext.isPublishBuildInfo());
        clientConf.setIncludeEnvVars(buildContext.isIncludeEnvVars());
        clientConf.setEnvVarsIncludePatterns(buildContext.getEnvVarsIncludePatterns());
        clientConf.setEnvVarsExcludePatterns(buildContext.getEnvVarsExcludePatterns());
    }
}

