/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.builder;

import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.utils.EscapeChars;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.spring.container.ContainerManager;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jfrog.bamboo.admin.ServerConfigManager;
import org.jfrog.bamboo.configuration.BuildParamsOverrideManager;
import org.jfrog.bamboo.context.AbstractBuildContext;
import org.jfrog.bamboo.util.TaskUtils;
import org.jfrog.bamboo.util.Utils;

public abstract class BaseBuildInfoHelper {
    private static final Logger log = Logger.getLogger(BaseBuildInfoHelper.class);
    protected BuildContext context;
    protected ServerConfigManager serverConfigManager;
    protected AdministrationConfiguration administrationConfiguration;
    protected AdministrationConfigurationAccessor administrationConfigurationAccessor;
    private HttpClient httpClient;
    protected String bambooBaseUrl;
    protected BuildParamsOverrideManager buildParamsOverrideManager;

    public void init(BuildParamsOverrideManager buildParamsOverrideManager, BuildContext context) {
        this.context = context;
        this.serverConfigManager = ServerConfigManager.getInstance();
        ContainerManager.autowireComponent((Object)this);
        this.httpClient = new HttpClient();
        this.bambooBaseUrl = this.determineBambooBaseUrl();
        this.buildParamsOverrideManager = buildParamsOverrideManager;
    }

    public void setAdministrationConfiguration(AdministrationConfiguration administrationConfiguration) {
        this.administrationConfiguration = administrationConfiguration;
    }

    public void setAdministrationConfigurationAccessor(AdministrationConfigurationAccessor administrationConfigurationAccessor) {
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
    }

    protected String getBuildName(String triggeringBuildKey) {
        try {
            HashMap<String, String> params = Maps.newHashMap();
            params.put("buildKey", triggeringBuildKey);
            return this.getStringResource("artifactoryBuildServlet", params);
        }
        catch (IOException ioe) {
            log.error("Unable to determine triggering build name.", ioe);
            return null;
        }
    }

    protected String getPublishingRepoKey(AbstractBuildContext buildContext, Map<String, String> environment) {
        String releaseManagementPublishRepo = environment.get("bamboo_release_management_repoKey");
        if (StringUtils.isNotBlank(releaseManagementPublishRepo)) {
            return releaseManagementPublishRepo;
        }
        return this.overrideParam(buildContext.getPublishingRepo(), "artifactory.override.deploy.repo");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getStringResource(String servletName, Map<String, String> params) throws IOException {
        String requestUrl = this.prepareRequestUrl(servletName, params);
        GetMethod getMethod = new GetMethod(requestUrl);
        try {
            this.executeMethod(requestUrl, getMethod);
            String string = getMethod.getResponseBodyAsString();
            return string;
        }
        finally {
            getMethod.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, String> getBuildInfoConfigPropertiesFileParams(String propFilePath) {
        HashMap<String, String> variablesToReturn;
        block4: {
            File propFile;
            variablesToReturn = Maps.newHashMap();
            if (!StringUtils.isNotBlank(propFilePath) || !(propFile = new File(propFilePath)).isFile()) break block4;
            Properties fileProperties = new Properties();
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(propFile);
                fileProperties.load(inputStream);
            }
            catch (IOException ioe) {
                try {
                    log.error("Error occurred while trying to resolve build info properties from: " + propFilePath, ioe);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(inputStream);
                    throw throwable;
                }
                IOUtils.closeQuietly(inputStream);
            }
            IOUtils.closeQuietly(inputStream);
            variablesToReturn.putAll(Utils.filterPropertiesKeysByPrefix(fileProperties, "artifactory.deploy."));
            variablesToReturn.putAll(Utils.filterPropertiesKeysByPrefix(fileProperties, "buildInfo.property."));
        }
        return TaskUtils.getEscapedEnvMap(variablesToReturn);
    }

    private String prepareRequestUrl(String servletName, Map<String, String> params) {
        StringBuilder builder = new StringBuilder(this.bambooBaseUrl);
        if (!this.bambooBaseUrl.endsWith("/")) {
            builder.append("/");
        }
        StringBuilder requestUrlBuilder = builder.append("plugins/servlet/").append(servletName);
        if (params.size() != 0) {
            requestUrlBuilder.append("?");
            for (Map.Entry<String, String> param : params.entrySet()) {
                if (!requestUrlBuilder.toString().endsWith("?")) {
                    requestUrlBuilder.append("&");
                }
                requestUrlBuilder.append(param.getKey()).append("=").append(EscapeChars.forFormSubmission((String)param.getValue()));
            }
        }
        return requestUrlBuilder.toString();
    }

    private void executeMethod(String requestUrl, GetMethod getMethod) throws IOException {
        int responseCode = this.httpClient.executeMethod((HttpMethod)getMethod);
        if (responseCode == 404) {
            throw new IOException("Unable to find requested resource: " + requestUrl);
        }
        if (responseCode != 200) {
            throw new IOException("Failed to retrieve requested resource: " + requestUrl + ". Response code: " + responseCode + ", Message: " + getMethod.getStatusText());
        }
    }

    protected String determineBambooBaseUrl() {
        if (this.administrationConfiguration != null) {
            return this.administrationConfiguration.getBaseUrl();
        }
        if (this.administrationConfigurationAccessor != null) {
            return this.administrationConfigurationAccessor.getAdministrationConfiguration().getBaseUrl();
        }
        return null;
    }

    public String overrideParam(String originalValue, String overrideKey) {
        String overriddenValue = this.buildParamsOverrideManager.getOverrideValue(overrideKey);
        return overriddenValue.isEmpty() ? originalValue : overriddenValue;
    }
}

