/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.builder;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.util.BuildUtils;
import com.atlassian.bamboo.utils.EscapeChars;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.trigger.DependencyTriggerReason;
import com.atlassian.bamboo.v2.build.trigger.ManualBuildTriggerReason;
import com.atlassian.bamboo.v2.build.trigger.TriggerReason;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jfrog.bamboo.admin.ServerConfig;
import org.jfrog.bamboo.builder.BaseBuildInfoHelper;
import org.jfrog.bamboo.context.GradleBuildContext;
import org.jfrog.bamboo.util.ConfigurationPathHolder;
import org.jfrog.bamboo.util.TaskUtils;
import org.jfrog.bamboo.util.version.VcsHelper;
import org.jfrog.build.api.util.NullLog;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.build.extractor.clientConfiguration.IncludeExcludePatterns;
import org.joda.time.DateTime;

public class GradleInitScriptHelper
extends BaseBuildInfoHelper {
    private static final Logger log = Logger.getLogger(GradleInitScriptHelper.class);

    public ConfigurationPathHolder createAndGetGradleInitScriptPath(String dependenciesDir, GradleBuildContext buildContext, BuildLogger logger, String scriptTemplate, Map<String, String> taskEnv, Map<String, String> generalEnv, String artifactoryPluginVersion) {
        long selectedServerId = buildContext.getArtifactoryServerId();
        if (selectedServerId == -1L) {
            return null;
        }
        ServerConfig serverConfig = this.serverConfigManager.getServerConfigById(selectedServerId);
        if (serverConfig == null) {
            String warning = "Found an ID of a selected Artifactory server configuration (" + selectedServerId + ") but could not find a matching configuration. Build info collection is disabled.";
            logger.addErrorLogEntry(warning);
            log.warn(warning);
            return null;
        }
        String normalizedPath = FilenameUtils.separatorsToUnix(dependenciesDir);
        scriptTemplate = scriptTemplate.replace("${pluginLibDir}", normalizedPath);
        try {
            File buildProps = File.createTempFile("buildinfo", "properties");
            ArtifactoryClientConfiguration configuration = this.createClientConfiguration(buildContext, serverConfig, taskEnv, artifactoryPluginVersion);
            MapDifference<String, String> buildVarDifference = Maps.difference(generalEnv, System.getenv());
            Map<String, String> filteredBuildVarDifferences = buildVarDifference.entriesOnlyOnLeft();
            IncludeExcludePatterns patterns = new IncludeExcludePatterns(buildContext.getEnvVarsIncludePatterns(), buildContext.getEnvVarsExcludePatterns());
            configuration.info.addBuildVariables(filteredBuildVarDifferences, patterns);
            configuration.setPropertiesFile(buildProps.getAbsolutePath());
            configuration.persistToPropertiesFile();
            File tempInitScript = File.createTempFile("artifactory.init.script", "gradle");
            FileUtils.writeStringToFile(tempInitScript, scriptTemplate, "utf-8");
            if (buildContext.isPublishBuildInfo()) {
                this.context.getBuildResult().getCustomBuildData().put("org.jfrog.bamboo.buildInfo.activated", "true");
                this.context.getBuildResult().getCustomBuildData().put("org.jfrog.bamboo.buildInfo.serverUrl", serverConfig.getUrl());
                this.context.getBuildResult().getCustomBuildData().put("org.jfrog.bamboo.release.activated", String.valueOf(buildContext.releaseManagementContext.isActivateReleaseManagement()));
            }
            return new ConfigurationPathHolder(tempInitScript.getCanonicalPath(), buildProps.getCanonicalPath());
        }
        catch (IOException e) {
            log.warn("An error occurred while creating the gradle build info init script. Build-info task will not be added.", e);
            return null;
        }
    }

    private ArtifactoryClientConfiguration createClientConfiguration(GradleBuildContext buildContext, ServerConfig serverConfig, Map<String, String> taskEnv, String artifactoryPluginVersion) {
        String vcsUrl;
        ArtifactoryClientConfiguration clientConf = new ArtifactoryClientConfiguration(new NullLog());
        String buildName = this.context.getPlanName();
        clientConf.info.setBuildName(buildName);
        clientConf.info.setArtifactoryPluginVersion(artifactoryPluginVersion);
        clientConf.publisher.addMatrixParam("build.name", buildName);
        String buildNumber = String.valueOf(this.context.getBuildNumber());
        clientConf.info.setBuildNumber(buildNumber);
        clientConf.publisher.addMatrixParam("build.number", buildNumber);
        String vcsRevision = VcsHelper.getRevisionKey(this.context);
        if (StringUtils.isNotBlank(vcsRevision)) {
            clientConf.info.setVcsRevision(vcsRevision);
            clientConf.publisher.addMatrixParam("vcs.revision", vcsRevision);
        }
        if (StringUtils.isNotBlank(vcsUrl = VcsHelper.getVcsUrl(this.context))) {
            clientConf.info.setVcsUrl(vcsUrl);
        }
        String buildTimeStampVal = (String)this.context.getBuildResult().getCustomBuildData().get("buildTimeStamp");
        long buildTimeStamp = System.currentTimeMillis();
        if (StringUtils.isNotBlank(buildTimeStampVal)) {
            buildTimeStamp = new DateTime((Object)buildTimeStampVal).getMillis();
        }
        String buildTimeStampString = String.valueOf(buildTimeStamp);
        clientConf.info.setBuildTimestamp(buildTimeStampString);
        clientConf.publisher.addMatrixParam("build.timestamp", buildTimeStampString);
        StringBuilder summaryUrlBuilder = new StringBuilder(this.bambooBaseUrl);
        if (!this.bambooBaseUrl.endsWith("/")) {
            summaryUrlBuilder.append("/");
        }
        String buildUrl = summaryUrlBuilder.append("browse/").append(EscapeChars.forFormSubmission((String)this.context.getPlanResultKey().getKey())).toString();
        clientConf.info.setBuildUrl(buildUrl);
        String principal = this.getTriggeringUserNameRecursively(this.context);
        if (StringUtils.isBlank(principal)) {
            principal = "auto";
        }
        clientConf.info.setPrincipal(principal);
        this.addBuildParentProperties(clientConf, this.context.getTriggerReason());
        clientConf.info.setAgentName("Bamboo");
        clientConf.info.setAgentVersion(BuildUtils.getVersionAndBuild());
        clientConf.info.licenseControl.setRunChecks(buildContext.isRunLicenseChecks());
        clientConf.info.licenseControl.setViolationRecipients(buildContext.getLicenseViolationRecipients());
        clientConf.info.licenseControl.setScopes(buildContext.getScopes());
        clientConf.info.licenseControl.setIncludePublishedArtifacts(buildContext.isIncludePublishedArtifacts());
        clientConf.info.licenseControl.setAutoDiscover(!buildContext.isDisableAutomaticLicenseDiscovery());
        try {
            BeanUtils.copyProperties((Object)clientConf.info.blackDuckProperties, (Object)buildContext.blackDuckProperties);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not integrate black duck properties", e);
        }
        clientConf.info.setReleaseEnabled(buildContext.releaseManagementContext.isActivateReleaseManagement());
        clientConf.info.setReleaseComment(buildContext.releaseManagementContext.getStagingComment());
        this.addClientProperties(clientConf, serverConfig, buildContext, taskEnv);
        clientConf.setIncludeEnvVars(buildContext.isIncludeEnvVars());
        clientConf.setEnvVarsIncludePatterns(buildContext.getEnvVarsIncludePatterns());
        clientConf.setEnvVarsExcludePatterns(buildContext.getEnvVarsExcludePatterns());
        HashMap<String, String> props = Maps.newHashMap(TaskUtils.getEscapedEnvMap(taskEnv));
        props.putAll(this.getBuildInfoConfigPropertiesFileParams((String)props.get("buildInfoConfig.propertiesFile")));
        IncludeExcludePatterns patterns = new IncludeExcludePatterns(buildContext.getEnvVarsIncludePatterns(), buildContext.getEnvVarsExcludePatterns());
        clientConf.info.addBuildVariables(props, patterns);
        clientConf.fillFromProperties(props, patterns);
        return clientConf;
    }

    private String getTriggeringUserNameRecursively(BuildContext context) {
        BuildContext parentContext;
        String principal = null;
        TriggerReason triggerReason = context.getTriggerReason();
        if (triggerReason instanceof ManualBuildTriggerReason && StringUtils.isBlank(principal = ((ManualBuildTriggerReason)triggerReason).getUserName()) && (parentContext = context.getParentBuildContext()) != null) {
            principal = this.getTriggeringUserNameRecursively(parentContext);
        }
        return principal;
    }

    private void addBuildParentProperties(ArtifactoryClientConfiguration clientConf, TriggerReason triggerReason) {
        String triggeringBuildResultKey;
        if (triggerReason instanceof DependencyTriggerReason && StringUtils.isNotBlank(triggeringBuildResultKey = ((DependencyTriggerReason)triggerReason).getTriggeringBuildResultKey()) && StringUtils.split(triggeringBuildResultKey, "-").length == 3) {
            String triggeringBuildKey = triggeringBuildResultKey.substring(0, triggeringBuildResultKey.lastIndexOf("-"));
            String triggeringBuildNumber = triggeringBuildResultKey.substring(triggeringBuildResultKey.lastIndexOf("-") + 1);
            String parentBuildName = this.getBuildName(triggeringBuildKey);
            if (StringUtils.isBlank(parentBuildName)) {
                log.error("Received a null build parent name.");
            }
            clientConf.info.setParentBuildName(parentBuildName);
            clientConf.publisher.addMatrixParam("build.parentName", parentBuildName);
            clientConf.info.setParentBuildNumber(triggeringBuildNumber);
            clientConf.publisher.addMatrixParam("build.parentNumber", triggeringBuildNumber);
        }
    }

    private void addClientProperties(ArtifactoryClientConfiguration clientConf, ServerConfig serverConfig, GradleBuildContext buildContext, Map<String, String> environment) {
        String serverUrl = this.serverConfigManager.substituteVariables(serverConfig.getUrl());
        clientConf.publisher.setContextUrl(serverUrl);
        clientConf.resolver.setContextUrl(serverUrl);
        clientConf.publisher.setRepoKey(this.getPublishingRepoKey(buildContext, environment));
        String resolutionRepo = this.overrideParam(buildContext.getResolutionRepo(), "artifactory.override.resolve.repo");
        if (StringUtils.isNotBlank(resolutionRepo) && !"noResolutionRepoKeyConfigured".equals(resolutionRepo)) {
            clientConf.resolver.setRepoKey(resolutionRepo);
        }
        String globalServerUsername = this.serverConfigManager.substituteVariables(serverConfig.getUsername());
        clientConf.resolver.setUsername(globalServerUsername);
        String deployerUsername = this.overrideParam(this.serverConfigManager.substituteVariables(buildContext.getDeployerUsername()), "artifactory.override.deployer.username");
        if (StringUtils.isBlank(deployerUsername)) {
            deployerUsername = globalServerUsername;
        }
        if (StringUtils.isNotBlank(deployerUsername)) {
            clientConf.publisher.setUsername(deployerUsername);
        }
        boolean publishArtifacts = buildContext.isPublishArtifacts();
        clientConf.publisher.setPublishArtifacts(publishArtifacts);
        clientConf.publisher.setIncludePatterns(buildContext.getIncludePattern());
        clientConf.publisher.setExcludePatterns(buildContext.getExcludePattern());
        clientConf.publisher.setFilterExcludedArtifactsFromBuild(buildContext.isFilterExcludedArtifactsFromBuild());
        if (publishArtifacts) {
            boolean m2Compatible = buildContext.isMaven2Compatible();
            clientConf.publisher.setM2Compatible(m2Compatible);
            if (!m2Compatible) {
                clientConf.publisher.setIvyPattern(buildContext.getIvyPattern());
                clientConf.publisher.setIvyArtifactPattern(buildContext.getArtifactPattern());
            }
        }
        clientConf.publisher.setPublishBuildInfo(buildContext.isPublishBuildInfo());
        clientConf.publisher.setIvy(buildContext.isPublishIvyDescriptors());
        clientConf.publisher.setMaven(buildContext.isPublishMavenDescriptors());
        String artifactSpecs = buildContext.getArtifactSpecs();
        if (StringUtils.isNotBlank(artifactSpecs)) {
            clientConf.publisher.setArtifactSpecs(artifactSpecs);
        }
    }
}

