/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.buildinfo.action;

import com.atlassian.bamboo.build.ViewBuildResults;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import org.apache.log4j.Logger;

public class BuildInfoAction
extends ViewBuildResults {
    transient Logger log = Logger.getLogger(BuildInfoAction.class);
    private String artifactoryReleaseManagementUrl = "";

    public String execute() throws Exception {
        String superResult = super.execute();
        if ("error".equals(superResult)) {
            return "error";
        }
        BuildResultsSummary summary = this.getBuildResultsSummary();
        if (summary == null) {
            this.log.error("This build has no results summary");
            return "error";
        }
        StringBuilder builder = new StringBuilder((String)summary.getCustomBuildData().get("org.jfrog.bamboo.buildInfo.serverUrl"));
        if (!builder.toString().endsWith("/")) {
            builder.append("/");
        }
        builder.append("webapp/builds/").append(this.getImmutableBuild().getName()).append("/").append(this.getBuildNumber());
        this.artifactoryReleaseManagementUrl = builder.toString();
        return "input";
    }

    public String getArtifactoryReleaseManagementUrl() {
        return this.artifactoryReleaseManagementUrl;
    }

    public void setArtifactoryReleaseManagementUrl(String artifactoryReleaseManagementUrl) {
        this.artifactoryReleaseManagementUrl = artifactoryReleaseManagementUrl;
    }
}

