/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.buildinfo.action.condition;

import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import java.util.Map;

public class BuildInfoActionCondition
implements Condition {
    private PlanManager planManager;
    private ResultsSummaryManager resultsSummaryManager;

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        String buildNumber;
        String planKey = context.get("planKey") == null ? null : (String)context.get("planKey");
        String string = buildNumber = context.get("buildNumber") == null ? null : (String)context.get("buildNumber");
        if (planKey == null || buildNumber == null) {
            return false;
        }
        PlanIdentifier planIdentifierForPermissionCheckingByKey = this.planManager.getPlanIdentifierForPermissionCheckingByKey(planKey);
        if (planIdentifierForPermissionCheckingByKey == null) {
            return false;
        }
        Plan plan = this.planManager.getPlanByKey(planIdentifierForPermissionCheckingByKey.getPlanKey());
        if (plan == null) {
            return false;
        }
        PlanResultKey planResultKey = PlanKeys.getPlanResultKey((PlanKey)plan.getPlanKey(), (int)Integer.parseInt(buildNumber));
        ResultsSummary resultsSummary = this.resultsSummaryManager.getResultsSummary(planResultKey);
        if (resultsSummary == null) {
            return false;
        }
        if (resultsSummary.isSuccessful()) {
            Map customData = resultsSummary.getCustomBuildData();
            return customData.containsKey("org.jfrog.bamboo.buildInfo.activated") && Boolean.valueOf((String)customData.get("org.jfrog.bamboo.buildInfo.activated")) != false;
        }
        return false;
    }

    public void setPlanManager(PlanManager planManager) {
        this.planManager = planManager;
    }

    public void setResultsSummaryManager(ResultsSummaryManager resultsSummaryManager) {
        this.resultsSummaryManager = resultsSummaryManager;
    }
}

