/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.capability;

import com.atlassian.bamboo.command.SimpleExecuteStreamHandler;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.v2.build.agent.capability.AbstractHomeDirectoryCapabilityDefaultsHelper;
import com.atlassian.bamboo.v2.build.agent.capability.ExecutablePathUtils;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.ExecuteWatchdog;
import org.apache.tools.ant.types.Commandline;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Maven3CapabilityHelper
extends AbstractHomeDirectoryCapabilityDefaultsHelper {
    private static final Logger log = Logger.getLogger(Maven3CapabilityHelper.class);
    private static final String MAVEN3_HOME_POSIX = "/usr/share/maven3/";
    private static final Pattern MAVEN_VERSION_3 = Pattern.compile("3\\.\\d+\\.\\d+");
    private static final String M2_EXECUTABLE_NAME = "mvn";
    private static final long GET_VERSION_TIMEOUT = TimeUnit.SECONDS.toMillis(10L);
    private static final Pattern VERSION_PATTERN = Pattern.compile("Apache Maven (\\S+).*");

    @NotNull
    protected String getExecutableName() {
        return ExecutablePathUtils.makeBatchIfOnWindows((String)M2_EXECUTABLE_NAME);
    }

    @Nullable
    protected String getEnvHome() {
        return SystemProperty.MAVEN2_HOME.getValue();
    }

    @NotNull
    protected String getPosixHome() {
        return MAVEN3_HOME_POSIX;
    }

    @NotNull
    protected String getCapabilityKey() {
        return "system.builder.maven.Artifactory Maven 3";
    }

    public static class MavenVersionMatcher
    implements Predicate<File> {
        private final Pattern pattern;

        public MavenVersionMatcher(@NotNull Pattern pattern) {
            this.pattern = pattern;
        }

        @Override
        public boolean apply(@Nullable File input) {
            if (input == null) {
                return false;
            }
            String mavenVersion = MavenVersionMatcher.getMavenVersion(input);
            return mavenVersion != null && this.pattern.matcher(mavenVersion).matches();
        }

        @Nullable
        private static String getMavenVersion(File mavenExecutable) {
            if (!mavenExecutable.isFile()) {
                log.info("Failed to get Maven version, file does not exists: " + mavenExecutable);
                return null;
            }
            Commandline commandline = new Commandline();
            if (SystemUtils.IS_OS_WINDOWS) {
                commandline.setExecutable("cmd.exe");
                commandline.addArguments(new String[]{"/c", mavenExecutable.getPath()});
            } else {
                commandline.setExecutable(mavenExecutable.getPath());
            }
            commandline.addArguments(new String[]{"--version"});
            ArrayList<String> commandStdOut = Lists.newArrayList();
            ArrayList commandStdErr = Lists.newArrayList();
            ExecuteWatchdog watchdog = new ExecuteWatchdog(GET_VERSION_TIMEOUT);
            Execute execute = new Execute((ExecuteStreamHandler)new SimpleExecuteStreamHandler(commandStdOut, commandStdErr, "MavenVersion"), watchdog);
            execute.setWorkingDirectory(SystemUtils.getJavaIoTmpDir());
            execute.setEnvironment(new String[]{"M2_HOME=" + mavenExecutable.getParentFile().getParent()});
            execute.setCommandline(commandline.getCommandline());
            try {
                int exitValue = execute.execute();
                if (!Execute.isFailure((int)exitValue)) {
                    for (String line : commandStdOut) {
                        Matcher matcher = VERSION_PATTERN.matcher(line);
                        if (!matcher.matches()) continue;
                        return matcher.group(1);
                    }
                    log.warn("Failed to get Maven version, unable to analyze output: \n" + StringUtils.join(commandStdOut, "\n"));
                } else if (watchdog.killedProcess()) {
                    log.warn("Failed to get Maven version, command timed out");
                } else {
                    log.warn("Failed to get Maven version, command failed: \n" + StringUtils.join(commandStdErr, "\n"));
                }
            }
            catch (Exception e) {
                log.warn("Failed to execute command", e);
            }
            return null;
        }
    }
}

