/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.configuration;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.task.TaskDefinition;
import com.google.common.collect.Lists;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jfrog.bamboo.configuration.AbstractArtifactoryConfiguration;
import org.jfrog.bamboo.context.GenericContext;

public class ArtifactoryGenericBuildConfiguration
extends AbstractArtifactoryConfiguration {
    private static final Set<String> FIELDS_TO_COPY = GenericContext.getFieldsToCopy();

    @Override
    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
        context.put("build", context.get("plan"));
        context.put("dummyList", Lists.newArrayList());
        context.put("serverConfigManager", this.serverConfigManager);
        context.put("selectedServerId", -1);
        context.put("selectedRepoKey", "");
        context.put("artifactory.generic.publishBuildInfo", "true");
        context.put("artifactory.generic.envVarsExcludePatterns", "*password*,*secret*,*security*,*key*");
        context.put("signMethods", GenericContext.SIGN_METHOD_MAP);
    }

    @Override
    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        String selectedPublishingRepoKey;
        super.populateContextForEdit(context, taskDefinition);
        this.migrateServerKeyIfNeeded(taskDefinition.getConfiguration());
        this.populateContextWithConfiguration(context, taskDefinition, FIELDS_TO_COPY);
        String string = selectedPublishingRepoKey = context.get("builder.artifactoryGenericBuilder.deployableRepo") != null ? context.get("builder.artifactoryGenericBuilder.deployableRepo").toString() : null;
        if (StringUtils.isBlank(selectedPublishingRepoKey)) {
            selectedPublishingRepoKey = (String)taskDefinition.getConfiguration().get("artifactory.generic.deployableRepo");
        }
        context.put("selectedRepoKey", selectedPublishingRepoKey);
        context.put("selectedServerId", context.get("builder.artifactoryGenericBuilder.artifactoryServerId"));
        context.put("signMethods", GenericContext.SIGN_METHOD_MAP);
        context.put("serverConfigManager", this.serverConfigManager);
        String envVarsExcludePatterns = (String)context.get("artifactory.generic.envVarsExcludePatterns");
        if (envVarsExcludePatterns == null) {
            context.put("artifactory.generic.envVarsExcludePatterns", "*password*,*secret*,*security*,*key*");
        }
    }

    @Override
    protected String getKey() {
        return "artifactoryGenericBuilder";
    }

    @Override
    protected String getDeployableRepoKey() {
        return "deployableRepo";
    }

    public boolean taskProducesTestResults(@NotNull TaskDefinition definition) {
        return false;
    }

    @Override
    @NotNull
    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        Map<String, String> configMap = super.generateTaskConfigMap(params, previousTaskDefinition);
        this.taskConfiguratorHelper.populateTaskConfigMapWithActionParameters(configMap, params, FIELDS_TO_COPY);
        this.decryptFields(configMap);
        return configMap;
    }
}

