/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.configuration;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.task.TaskDefinition;
import com.google.common.collect.Lists;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jfrog.bamboo.configuration.AbstractArtifactoryConfiguration;
import org.jfrog.bamboo.context.GenericContext;

public class ArtifactoryGenericResolveConfiguration
extends AbstractArtifactoryConfiguration {
    private static final Set<String> FIELDS_TO_COPY = GenericContext.getFieldsToCopy();

    @Override
    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
        context.put("build", context.get("plan"));
        context.put("dummyList", Lists.newArrayList());
        context.put("serverConfigManager", this.serverConfigManager);
        context.put("selectedServerId", -1);
        context.put("selectedRepoKey", "");
    }

    @Override
    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        this.migrateServerKeyIfNeeded(taskDefinition.getConfiguration());
        this.populateContextWithConfiguration(context, taskDefinition, FIELDS_TO_COPY);
        String publishingKey = "builder.artifactoryGenericBuilder.deployableRepo";
        String selectedPublishingRepoKey = context.get(publishingKey) != null ? context.get(publishingKey).toString() : "noPublishingRepoKeyConfigured";
        context.put("selectedRepoKey", selectedPublishingRepoKey);
        context.put("selectedServerId", context.get("builder.artifactoryGenericBuilder.artifactoryServerId"));
        context.put("serverConfigManager", this.serverConfigManager);
    }

    @Override
    protected String getKey() {
        return "artifactoryGenericBuilder";
    }

    @Override
    protected String getDeployableRepoKey() {
        return null;
    }

    public boolean taskProducesTestResults(@NotNull TaskDefinition definition) {
        return false;
    }

    @Override
    @NotNull
    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        Map<String, String> configMap = super.generateTaskConfigMap(params, previousTaskDefinition);
        this.taskConfiguratorHelper.populateTaskConfigMapWithActionParameters(configMap, params, FIELDS_TO_COPY);
        this.decryptFields(configMap);
        return configMap;
    }
}

