/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.configuration;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.task.TaskDefinition;
import com.google.common.collect.Lists;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jfrog.bamboo.configuration.AbstractArtifactoryConfiguration;
import org.jfrog.bamboo.context.GradleBuildContext;

public class ArtifactoryGradleConfiguration
extends AbstractArtifactoryConfiguration {
    protected static final String DEFAULT_TEST_REPORTS_XML = "**/build/test-results/*.xml";
    private static final Set<String> FIELDS_TO_COPY = GradleBuildContext.getFieldsToCopy();

    public ArtifactoryGradleConfiguration() {
        super("builder.artifactoryGradleBuilder.");
    }

    @Override
    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
        context.put("artifactoryGradleTask", (Object)this);
        context.put("builderType", (Object)this);
        context.put("builder", (Object)this);
        context.put("adminConfig", this.administrationConfiguration);
        context.put("baseUrl", this.administrationConfiguration.getBaseUrl());
        Plan plan = (Plan)context.get("plan");
        context.put("build", plan);
        context.put("dummyList", Lists.newArrayList());
        context.put("serverConfigManager", this.serverConfigManager);
        context.put("selectedServerId", -1);
        context.put("selectedResolutionRepoKey", "");
        context.put("selectedPublishingRepoKey", "");
        context.put("builder.artifactoryGradleBuilder.gitReleaseBranch", "REL-BRANCH-");
        context.put("artifactory.vcs.git.vcs.type.list", this.getVcsTypes());
        context.put("artifactory.vcs.git.authenticationType.list", this.getGitAuthenticationTypes());
    }

    @Override
    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        this.populateContextWithConfiguration(context, taskDefinition, FIELDS_TO_COPY);
        context.put("selectedServerId", context.get("builder.artifactoryGradleBuilder.artifactoryServerId"));
        String resolutionRepoKey = "builder.artifactoryGradleBuilder.resolutionRepo";
        String selectedResolutionRepoKey = context.get(resolutionRepoKey) != null ? context.get(resolutionRepoKey).toString() : "noResolutionRepoKeyConfigured";
        context.put("selectedResolutionRepoKey", selectedResolutionRepoKey);
        String publishingKey = "builder.artifactoryGradleBuilder.publishingRepo";
        String selectedPublishingRepoKey = context.get(publishingKey) != null ? context.get(publishingKey).toString() : "noPublishingRepoKeyConfigured";
        context.put("selectedPublishingRepoKey", selectedPublishingRepoKey);
        GradleBuildContext buildContext = GradleBuildContext.createGradleContextFromMap(context);
        context.put("hasTests", buildContext.isTestChecked());
        context.put("serverConfigManager", this.serverConfigManager);
        String envVarsExcludePatterns = (String)context.get("envVarsExcludePatterns");
        if (envVarsExcludePatterns == null) {
            context.put("envVarsExcludePatterns", "*password*,*secret*,*security*,*key*");
        }
        context.put("artifactory.vcs.git.vcs.type.list", this.getVcsTypes());
        context.put("artifactory.vcs.git.authenticationType.list", this.getGitAuthenticationTypes());
    }

    @Override
    @NotNull
    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        Map<String, String> taskConfigMap = super.generateTaskConfigMap(params, previousTaskDefinition);
        this.taskConfiguratorHelper.populateTaskConfigMapWithActionParameters(taskConfigMap, params, FIELDS_TO_COPY);
        GradleBuildContext buildContext = new GradleBuildContext(taskConfigMap);
        this.resetConfigIfNeeded(buildContext);
        taskConfigMap.put("builder.artifactoryGradleBuilder.testResultsDirectory", this.getTestDirectory(buildContext));
        taskConfigMap.putAll(super.getSshFileContent(params, previousTaskDefinition));
        this.decryptFields(taskConfigMap);
        return taskConfigMap;
    }

    @Override
    protected String getKey() {
        return "artifactoryGradleBuilder";
    }

    @Override
    protected String getDeployableRepoKey() {
        return "publishingRepo";
    }

    @Override
    protected String getDefaultTestDirectory() {
        return DEFAULT_TEST_REPORTS_XML;
    }

    public boolean taskProducesTestResults(@NotNull TaskDefinition definition) {
        return new GradleBuildContext(definition.getConfiguration()).isTestChecked();
    }
}

