/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.configuration;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.task.TaskDefinition;
import com.google.common.collect.Lists;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jfrog.bamboo.configuration.AbstractArtifactoryConfiguration;
import org.jfrog.bamboo.context.IvyBuildContext;

public class ArtifactoryIvyConfiguration
extends AbstractArtifactoryConfiguration {
    protected static final String DEFAULT_TEST_REPORTS_XML = "**/test-reports/*.xml";
    private static final Set<String> FIELDS_TO_COPY = IvyBuildContext.getFieldsToCopy();

    public ArtifactoryIvyConfiguration() {
        super("builder.artifactoryIvyBuilder.", "system.builder.ivy");
    }

    @Override
    protected String getKey() {
        return "artifactoryIvyBuilder";
    }

    @Override
    protected String getDeployableRepoKey() {
        return "deployableRepo";
    }

    @Override
    protected String getDefaultTestDirectory() {
        return DEFAULT_TEST_REPORTS_XML;
    }

    @Override
    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
        context.put("artifactoryIvyTask", (Object)this);
        context.put("builderType", (Object)this);
        context.put("builder", (Object)this);
        context.put("adminConfig", this.administrationConfiguration);
        context.put("baseUrl", this.administrationConfiguration.getBaseUrl());
        context.put("build", context.get("plan"));
        context.put("dummyList", Lists.newArrayList());
        context.put("serverConfigManager", this.serverConfigManager);
        context.put("selectedServerId", -1);
        context.put("selectedRepoKey", "");
    }

    @Override
    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        this.populateContextWithConfiguration(context, taskDefinition, FIELDS_TO_COPY);
        String publishingKey = "builder.artifactoryIvyBuilder.deployableRepo";
        String selectedPublishingRepoKey = context.get(publishingKey) != null ? context.get(publishingKey).toString() : "noPublishingRepoKeyConfigured";
        context.put("selectedRepoKey", selectedPublishingRepoKey);
        context.put("selectedServerId", context.get("builder.artifactoryIvyBuilder.artifactoryServerId"));
        context.put("serverConfigManager", this.serverConfigManager);
        String envVarsExcludePatterns = (String)context.get("envVarsExcludePatterns");
        if (envVarsExcludePatterns == null) {
            context.put("envVarsExcludePatterns", "*password*,*secret*,*security*,*key*");
        }
    }

    @Override
    @NotNull
    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        Map<String, String> configMap = super.generateTaskConfigMap(params, previousTaskDefinition);
        this.taskConfiguratorHelper.populateTaskConfigMapWithActionParameters(configMap, params, FIELDS_TO_COPY);
        IvyBuildContext buildContext = new IvyBuildContext(configMap);
        this.resetConfigIfNeeded(buildContext);
        configMap.put("builder.artifactoryIvyBuilder.testResultsDirectory", this.getTestDirectory(buildContext));
        this.decryptFields(configMap);
        return configMap;
    }

    public boolean taskProducesTestResults(@NotNull TaskDefinition definition) {
        return new IvyBuildContext(definition.getConfiguration()).isTestChecked();
    }
}

