/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.configuration;

import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.utils.EscapeChars;
import com.atlassian.spring.container.ContainerManager;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.io.IOUtils;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.ObjectMapper;

public class ConfigurationHelper
implements Serializable {
    public static final String DEFAULT_JDK = "JAVA_HOME";
    private static ConfigurationHelper instance = new ConfigurationHelper();
    private AdministrationConfigurationAccessor administrationConfigurationAccessor;
    private HttpClient httpClient = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());

    private ConfigurationHelper() {
        ContainerManager.autowireComponent((Object)this);
    }

    public static ConfigurationHelper getInstance() {
        return instance;
    }

    public void setAdministrationConfigurationAccessor(AdministrationConfigurationAccessor administrationConfigurationAccessor) {
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
    }

    public Map<String, String> getAllVariables(PlanKey planKey) {
        Map map;
        JsonFactory jsonFactory;
        InputStream responseStream;
        GetMethod getMethod;
        String requestUrl;
        block5: {
            HashMap<String, PlanKey> params = Maps.newHashMap();
            params.put("planKey", planKey);
            requestUrl = this.prepareRequestUrl("artifactoryAdminConfigServlet", params);
            getMethod = new GetMethod(requestUrl);
            responseStream = null;
            this.executeMethod(requestUrl, getMethod);
            jsonFactory = new JsonFactory();
            ObjectMapper mapper = new ObjectMapper();
            jsonFactory.setCodec(mapper);
            responseStream = getMethod.getResponseBodyAsStream();
            if (responseStream != null) break block5;
            HashMap<String, String> hashMap = Maps.newHashMap();
            getMethod.releaseConnection();
            IOUtils.closeQuietly(responseStream);
            return hashMap;
        }
        try {
            JsonParser parser = jsonFactory.createJsonParser(responseStream);
            map = parser.readValueAs(Map.class);
        }
        catch (IOException e) {
            try {
                String message = "Failed while invoking URL " + requestUrl + " to get Bamboo variables. " + e.getMessage();
                throw new RuntimeException(message, e);
            }
            catch (Throwable throwable) {
                getMethod.releaseConnection();
                IOUtils.closeQuietly(responseStream);
                throw throwable;
            }
        }
        getMethod.releaseConnection();
        IOUtils.closeQuietly(responseStream);
        return map;
    }

    private String prepareRequestUrl(String servletName, Map<String, PlanKey> params) {
        String bambooBaseUrl = this.administrationConfigurationAccessor.getAdministrationConfiguration().getBaseUrl();
        StringBuilder builder = new StringBuilder(bambooBaseUrl);
        if (!bambooBaseUrl.endsWith("/")) {
            builder.append("/");
        }
        StringBuilder requestUrlBuilder = builder.append("plugins/servlet/").append(servletName);
        if (params.size() != 0) {
            requestUrlBuilder.append("?");
            for (Map.Entry<String, PlanKey> param : params.entrySet()) {
                if (!requestUrlBuilder.toString().endsWith("?")) {
                    requestUrlBuilder.append("&");
                }
                requestUrlBuilder.append(param.getKey()).append("=").append(EscapeChars.forFormSubmission((String)param.getValue().getKey()));
            }
        }
        return requestUrlBuilder.toString();
    }

    private void executeMethod(String requestUrl, GetMethod getMethod) throws IOException {
        int responseCode = this.httpClient.executeMethod((HttpMethod)getMethod);
        if (responseCode == 404) {
            throw new IOException("Unable to find requested resource: " + requestUrl);
        }
        if (responseCode != 200) {
            throw new IOException("Failed to retrieve requested resource: " + requestUrl + ". Response code: " + responseCode + ", Message: " + getMethod.getStatusText());
        }
    }
}

