/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.context;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.lang.StringUtils;
import org.jfrog.bamboo.bintray.PushToBintrayContext;
import org.jfrog.bamboo.context.GradleBuildContext;
import org.jfrog.bamboo.context.Maven3BuildContext;
import org.jfrog.bamboo.release.action.ModuleVersionHolder;
import org.jfrog.bamboo.util.BeanUtilsHelper;
import org.jfrog.build.api.BlackDuckProperties;

public abstract class AbstractBuildContext {
    public static final String SERVER_ID_PARAM = "artifactoryServerId";
    public static final String RESOLUTION_REPO_PARAM = "resolutionRepo";
    public static final String PUBLISHING_REPO_PARAM = "publishingRepo";
    public static final String DEPLOYER_USERNAME_PARAM = "deployerUsername";
    public static final String DEPLOYER_PASSWORD_PARAM = "deployerPassword";
    public static final String USE_ARTIFACTORY_GRADLE_PLUGIN = "useArtifactoryGradlePlugin";
    public static final String PUBLISH_BUILD_INFO_PARAM = "publishBuildInfo";
    public static final String INCLUDE_ENV_VARS_PARAM = "includeEnvVars";
    public static final String ENV_VARS_INCLUDE_PATTERNS = "envVarsIncludePatterns";
    public static final String ENV_VARS_EXCLUDE_PATTERNS = "envVarsExcludePatterns";
    public static final String RUN_LICENSE_CHECKS = "runLicenseChecks";
    public static final String LICENSE_VIOLATION_RECIPIENTS = "licenseViolationRecipients";
    public static final String LIMIT_CHECKS_TO_THE_FOLLOWING_SCOPES = "limitChecksToScopes";
    public static final String INCLUDE_PUBLISHED_ARTIFACTS = "includePublishedArtifacts";
    public static final String DISABLE_AUTOMATIC_LICENSE_DISCOVERY = "disableAutoLicenseDiscovery";
    public static final String TEST_CHECKED = "testChecked";
    public static final String TEST_RESULT_DIRECTORY = "testResultsDirectory";
    public static final String TEST_DIRECTORY_OPTION = "testDirectoryOption";
    public static final String ENVIRONMENT_VARIABLES = "environmentVariables";
    public static final String PUBLISH_ARTIFACTS_PARAM = "publishArtifacts";
    public static final String PUBLISH_MAVEN_DESCRIPTORS_PARAM = "publishMavenDescriptors";
    public static final String PUBLISH_IVY_DESCRIPTORS_PARAM = "publishIvyDescriptors";
    public static final String USE_M2_COMPATIBLE_PATTERNS_PARAM = "useM2CompatiblePatterns";
    public static final String IVY_PATTERN_PARAM = "ivyPattern";
    public static final String ARTIFACT_PATTERN_PARAM = "artifactPattern";
    public static final String PUBLISH_INCLUDE_PATTERNS_PARAM = "publishIncludePatterns";
    public static final String PUBLISH_EXCLUDE_PATTERNS_PARAM = "publishExcludePatterns";
    public static final String FILTER_EXCLUDED_ARTIFACTS_FROM_BUILD_PARAM = "filterExcludedArtifactsFromBuild";
    public static final String ARTIFACT_SPECS_PARAM = "artifactSpecs";
    public static final String NO_RESOLUTION_REPO_KEY_CONFIGURED = "noResolutionRepoKeyConfigured";
    public static final String NO_PUBLISHING_REPO_KEY_CONFIGURED = "noPublishingRepoKeyConfigured";
    public static final String JDK = "buildJdk";
    public static final String EXECUTABLE = "executable";
    public static final String BASE_URL = "baseUrl";
    public static final String ENABLE_BINTRAY_CONFIGURATION = "bintrayConfiguration";
    public static final String ENABLE_RELEASE_MANAGEMENT = "enableReleaseManagement";
    public static final String ACTIVATE_RELEASE_MANAGEMENT = "activateReleaseManagement";
    public static final String VCS_TAG_BASE = "vcsTagBase";
    public static final String GIT_RELEASE_BRANCH = "gitReleaseBranch";
    public static final String ALTERNATIVE_TASKS = "alternativeTasks";
    public static final String RELEASE_PROPS = "releaseProps";
    public static final String NEXT_INTEG_PROPS = "nextIntegProps";
    public static final String VCS_TYPE = "type";
    public static final String GIT_URL = "git.url";
    public static final String GIT_AUTHENTICATION_TYPE = "git.authenticationType";
    public static final String GIT_USERNAME = "git.username";
    public static final String GIT_PASSWORD = "git.password";
    public static final String GIT_SSH_KEY = "git.ssh.key";
    public static final String GIT_PASSPHRASE = "git.ssh.passphrase";
    public static final String PERFORCE_PORT = "p4.port";
    public static final String PERFORCE_CLIENT = "p4.client";
    public static final String PERFORCE_DEPOT = "p4.depot";
    public static final String PERFORCE_USERNAME = "p4.username";
    public static final String PERFORCE_PASSWORD = "p4.password";
    public static final String BLACKDUCK_PREFIX = "artifactory.common.blackduck.";
    public static final String VCS_PREFIX = "artifactory.vcs.";
    public static final String ENV_VARS_TO_EXCLUDE = "*password*,*secret*,*security*,*key*";
    public final ReleaseManagementContext releaseManagementContext = new ReleaseManagementContext();
    public final PushToBintrayContext pushToBintrayContext = new PushToBintrayContext();
    public final BlackDuckProperties blackDuckProperties;
    private final String prefix;
    protected final Map<String, String> env;

    public AbstractBuildContext(String prefix, Map<String, String> env) {
        this.prefix = prefix;
        this.env = env;
        this.blackDuckProperties = new BlackDuckProperties();
        BeanUtilsHelper.populateWithPrefix(this.blackDuckProperties, env, BLACKDUCK_PREFIX);
    }

    public static AbstractBuildContext createContextFromMap(Map<String, String> map) {
        if (map == null || map.isEmpty()) {
            throw new IllegalArgumentException("No empty map allowed");
        }
        String value = AbstractBuildContext.getBuilderValue(map);
        if (StringUtils.isBlank(value)) {
            return null;
        }
        if (StringUtils.startsWith(value, "builder.artifactoryGradleBuilder.")) {
            return new GradleBuildContext(AbstractBuildContext.sanitizeEntries(map));
        }
        if (StringUtils.startsWith(value, "builder.artifactoryMaven3Builder.")) {
            return new Maven3BuildContext(AbstractBuildContext.sanitizeEntries(map));
        }
        return null;
    }

    private static String getBuilderValue(Map<String, String> confMap) {
        for (Map.Entry<String, String> entry : confMap.entrySet()) {
            if (!StringUtils.startsWith(entry.getKey(), "builder.")) continue;
            return entry.getKey();
        }
        return null;
    }

    private static Map<String, String> sanitizeEntries(Map<String, String> confMap) {
        HashMap<String, String> result = Maps.newHashMap();
        for (Map.Entry<String, String> entry : confMap.entrySet()) {
            if (StringUtils.isBlank(entry.getValue())) {
                result.put(entry.getKey(), "");
                continue;
            }
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static List<String> getBlackDuckFieldsToCopy() {
        return Arrays.asList("artifactory.common.blackduck.runChecks", "artifactory.common.blackduck.appName", "artifactory.common.blackduck.appVersion", "artifactory.common.blackduck.reportRecipients", "artifactory.common.blackduck.scopes", "artifactory.common.blackduck.includePublishedArtifacts", "artifactory.common.blackduck.autoCreateMissingComponentRequests", "artifactory.common.blackduck.autoDiscardStaleComponentRequests");
    }

    public static List<String> getVcsFieldsToCopy() {
        return Arrays.asList("artifactory.vcs.type", "artifactory.vcs.git.authenticationType", "artifactory.vcs.git.username", "artifactory.vcs.git.password", "artifactory.vcs.git.url", "artifactory.vcs.git.ssh.passphrase", "artifactory.vcs.git.ssh.key", "artifactory.vcs.p4.client", "artifactory.vcs.p4.port", "artifactory.vcs.p4.depot", "artifactory.vcs.p4.username", "artifactory.vcs.p4.password");
    }

    public long getArtifactoryServerId() {
        String serverId = this.env.get(this.prefix + SERVER_ID_PARAM);
        if (StringUtils.isBlank(serverId)) {
            return -1L;
        }
        return Long.parseLong(serverId);
    }

    public String getBaseUrl() {
        return this.env.get(BASE_URL);
    }

    public String getEnvironmentVariables() {
        return this.env.get(this.prefix + ENVIRONMENT_VARIABLES);
    }

    public String getExecutable() {
        return this.env.get(this.prefix + EXECUTABLE);
    }

    public boolean isTestChecked() {
        return Boolean.parseBoolean(this.env.get(TEST_CHECKED));
    }

    public String getTestDirectory() {
        return this.env.get(this.prefix + TEST_RESULT_DIRECTORY);
    }

    public String getTestDirectoryOption() {
        return this.env.get(TEST_DIRECTORY_OPTION);
    }

    public String getPublishingRepo() {
        return this.env.get(this.prefix + PUBLISHING_REPO_PARAM);
    }

    public String getDeployerUsername() {
        return this.env.get(this.prefix + DEPLOYER_USERNAME_PARAM);
    }

    public String getDeployerPassword() {
        return this.env.get(this.prefix + DEPLOYER_PASSWORD_PARAM);
    }

    public String getJdkLabel() {
        return this.env.get(this.prefix + JDK);
    }

    public boolean useArtifactoryGradlePlugin() {
        return Boolean.parseBoolean(this.env.get(this.prefix + USE_ARTIFACTORY_GRADLE_PLUGIN));
    }

    public boolean isPublishBuildInfo() {
        return Boolean.parseBoolean(this.env.get(PUBLISH_BUILD_INFO_PARAM));
    }

    public boolean isIncludeEnvVars() {
        return Boolean.parseBoolean(this.env.get(INCLUDE_ENV_VARS_PARAM));
    }

    public String getEnvVarsIncludePatterns() {
        return this.env.get(ENV_VARS_INCLUDE_PATTERNS);
    }

    public String getEnvVarsExcludePatterns() {
        return this.env.get(ENV_VARS_EXCLUDE_PATTERNS);
    }

    public boolean isRunLicenseChecks() {
        return Boolean.parseBoolean(this.env.get(RUN_LICENSE_CHECKS));
    }

    public String getLicenseViolationRecipients() {
        return this.env.get(this.prefix + LICENSE_VIOLATION_RECIPIENTS);
    }

    public String getScopes() {
        return this.env.get(this.prefix + LIMIT_CHECKS_TO_THE_FOLLOWING_SCOPES);
    }

    public boolean isIncludePublishedArtifacts() {
        return Boolean.parseBoolean(this.env.get(this.prefix + INCLUDE_PUBLISHED_ARTIFACTS));
    }

    public boolean isDisableAutomaticLicenseDiscovery() {
        return Boolean.parseBoolean(this.env.get(this.prefix + DISABLE_AUTOMATIC_LICENSE_DISCOVERY));
    }

    public boolean isPublishArtifacts() {
        return Boolean.parseBoolean(this.env.get(PUBLISH_ARTIFACTS_PARAM));
    }

    public boolean isPublishMavenDescriptors() {
        return Boolean.parseBoolean(this.env.get(this.prefix + PUBLISH_MAVEN_DESCRIPTORS_PARAM));
    }

    public boolean isPublishIvyDescriptors() {
        return Boolean.parseBoolean(this.env.get(this.prefix + PUBLISH_IVY_DESCRIPTORS_PARAM));
    }

    public boolean isMaven2Compatible() {
        return Boolean.parseBoolean(this.env.get(USE_M2_COMPATIBLE_PATTERNS_PARAM));
    }

    public String getIvyPattern() {
        return this.env.get(this.prefix + IVY_PATTERN_PARAM);
    }

    public String getArtifactPattern() {
        return this.env.get(this.prefix + ARTIFACT_PATTERN_PARAM);
    }

    public String getIncludePattern() {
        return this.env.get(this.prefix + PUBLISH_INCLUDE_PATTERNS_PARAM);
    }

    public String getExcludePattern() {
        return this.env.get(this.prefix + PUBLISH_EXCLUDE_PATTERNS_PARAM);
    }

    public boolean isFilterExcludedArtifactsFromBuild() {
        return Boolean.parseBoolean(this.env.get(this.prefix + FILTER_EXCLUDED_ARTIFACTS_FROM_BUILD_PARAM));
    }

    public String getResolutionRepo() {
        return this.env.get(this.prefix + RESOLUTION_REPO_PARAM);
    }

    public String getArtifactSpecs() {
        return this.env.get(this.prefix + ARTIFACT_SPECS_PARAM);
    }

    public void resetContextToDefault() {
        this.env.put(this.prefix + SERVER_ID_PARAM, "-1");
        this.env.put(this.prefix + RESOLUTION_REPO_PARAM, "");
        this.env.put(this.prefix + DEPLOYER_USERNAME_PARAM, "");
        this.env.put(this.prefix + DEPLOYER_PASSWORD_PARAM, "");
        this.env.put(USE_M2_COMPATIBLE_PATTERNS_PARAM, "true");
        this.env.put(this.prefix + IVY_PATTERN_PARAM, "");
        this.env.put(this.prefix + ARTIFACT_PATTERN_PARAM, "");
        this.env.put(RUN_LICENSE_CHECKS, "false");
        this.env.put(this.prefix + LIMIT_CHECKS_TO_THE_FOLLOWING_SCOPES, "");
        this.env.put(this.prefix + INCLUDE_PUBLISHED_ARTIFACTS, "false");
        this.env.put(this.prefix + DISABLE_AUTOMATIC_LICENSE_DISCOVERY, "false");
        this.env.put(this.prefix + FILTER_EXCLUDED_ARTIFACTS_FROM_BUILD_PARAM, "false");
        this.env.put(PUBLISH_ARTIFACTS_PARAM, "false");
        this.env.put(ENABLE_RELEASE_MANAGEMENT, "false");
        this.env.put(ENV_VARS_EXCLUDE_PATTERNS, ENV_VARS_TO_EXCLUDE);
    }

    private List<String> splitAndTrim(String releaseProps) {
        ArrayList<String> tokens = Lists.newArrayList();
        for (String token : StringUtils.split(releaseProps, ",")) {
            if (!StringUtils.isNotBlank(token)) continue;
            tokens.add(token.trim());
        }
        return tokens;
    }

    public class ReleaseManagementContext {
        public static final String CREATE_VCS_TAG = "createVcsTag";
        public static final String USE_RELEASE_BRANCH = "useReleaseBranch";
        public static final String RELEASE_BRANCH = "releaseBranch";
        public static final String STAGING_COMMENT = "stagingComment";
        public static final String TAG_URL = "tagUrl";
        public static final String TAG_COMMENT = "tagComment";
        public static final String NEXT_DEVELOPMENT_COMMENT = "nextDevelopmentComment";
        public static final String REPO_KEY = "release.management.repoKey";

        public boolean isActivateReleaseManagement() {
            return Boolean.parseBoolean(AbstractBuildContext.this.env.get(AbstractBuildContext.ACTIVATE_RELEASE_MANAGEMENT));
        }

        public void setActivateReleaseManagement(boolean value) {
            AbstractBuildContext.this.env.put(AbstractBuildContext.ACTIVATE_RELEASE_MANAGEMENT, String.valueOf(value));
        }

        public String getTagUrl() {
            return AbstractBuildContext.this.env.get(TAG_URL);
        }

        public String getRepoKey() {
            return AbstractBuildContext.this.env.get(REPO_KEY);
        }

        public String getStagingComment() {
            return AbstractBuildContext.this.env.get(STAGING_COMMENT);
        }

        public boolean isUseReleaseBranch() {
            return Boolean.parseBoolean(AbstractBuildContext.this.env.get(USE_RELEASE_BRANCH));
        }

        public String getReleaseBranch() {
            return AbstractBuildContext.this.env.get(RELEASE_BRANCH);
        }

        public String getTagComment() {
            return AbstractBuildContext.this.env.get(TAG_COMMENT);
        }

        public boolean isCreateVcsTag() {
            return Boolean.parseBoolean(AbstractBuildContext.this.env.get(CREATE_VCS_TAG));
        }

        public String getNextDevelopmentComment() {
            return AbstractBuildContext.this.env.get(NEXT_DEVELOPMENT_COMMENT);
        }

        public List<ModuleVersionHolder> filterPropsForRelease(Map<String, String> props) {
            String nextIntegProps;
            ArrayList<ModuleVersionHolder> result = Lists.newArrayList();
            String releaseProps = AbstractBuildContext.this.env.get(AbstractBuildContext.this.prefix + AbstractBuildContext.RELEASE_PROPS);
            if (StringUtils.isNotBlank(releaseProps)) {
                ArrayList split = Lists.newArrayList(AbstractBuildContext.this.splitAndTrim(releaseProps));
                for (Map.Entry<String, String> entry : props.entrySet()) {
                    if (!Iterables.contains(split, entry.getKey())) continue;
                    result.add(new ModuleVersionHolder(entry.getKey(), entry.getValue(), true));
                }
            }
            if (StringUtils.isNotBlank(nextIntegProps = AbstractBuildContext.this.env.get(AbstractBuildContext.this.prefix + AbstractBuildContext.NEXT_INTEG_PROPS))) {
                ArrayList split = Lists.newArrayList(AbstractBuildContext.this.splitAndTrim(nextIntegProps));
                for (Map.Entry<String, String> entry : props.entrySet()) {
                    final String propertyKey = entry.getKey();
                    if (!Iterables.contains(split, propertyKey)) continue;
                    try {
                        ModuleVersionHolder existingReleaseProp = Iterables.find(result, new Predicate<ModuleVersionHolder>(){

                            @Override
                            public boolean apply(ModuleVersionHolder holder) {
                                return holder != null && holder.getKey().equals(propertyKey);
                            }
                        });
                        existingReleaseProp.setReleaseProp(false);
                    }
                    catch (NoSuchElementException e) {
                        result.add(new ModuleVersionHolder(propertyKey, entry.getValue(), false));
                    }
                }
            }
            return result;
        }

        public boolean isReleaseMgmtEnabled() {
            return Boolean.parseBoolean(AbstractBuildContext.this.env.get(AbstractBuildContext.ENABLE_RELEASE_MANAGEMENT));
        }

        public String getVcsTagBase() {
            return AbstractBuildContext.this.env.get(AbstractBuildContext.this.prefix + AbstractBuildContext.VCS_TAG_BASE);
        }

        public String getGitReleaseBranch() {
            return AbstractBuildContext.this.env.get(AbstractBuildContext.this.prefix + AbstractBuildContext.GIT_RELEASE_BRANCH);
        }

        public String getAlternativeTasks() {
            return AbstractBuildContext.this.env.get(AbstractBuildContext.this.prefix + AbstractBuildContext.ALTERNATIVE_TASKS);
        }

        public String getReleaseProps() {
            return AbstractBuildContext.this.env.get(AbstractBuildContext.this.prefix + AbstractBuildContext.RELEASE_PROPS);
        }

        public String getNextIntegProps() {
            return AbstractBuildContext.this.env.get(AbstractBuildContext.this.prefix + AbstractBuildContext.NEXT_INTEG_PROPS);
        }
    }
}

