/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.context;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jfrog.bamboo.bintray.PushToBintrayContext;

public class GenericContext {
    public static final String PREFIX = "builder.artifactoryGenericBuilder.";
    public static final String SERVER_ID_PARAM = "artifactoryServerId";
    public static final String REPO_KEY = "builder.artifactoryGenericBuilder.deployableRepo";
    public static final String REPO_RESOLVE_KEY = "artifactory.generic.resolveRepo";
    public static final String USERNAME = "artifactory.generic.username";
    public static final String PASSWORD = "artifactory.generic.password";
    public static final String DEPLOY_PATTERN = "artifactory.generic.deployPattern";
    public static final String USE_SPECS_CHOICE = "artifactory.generic.useSpecsChoice";
    public static final String SPEC_SOURCE_CHOICE = "artifactory.generic.specSourceChoice";
    public static final String SPEC_SOURCE_JOB_CONFIGURATION = "artifactory.generic.jobConfiguration";
    public static final String SPEC_SOURCE_FILE = "artifactory.generic.file";
    public static final String RESOLVE_PATTERN = "artifactory.generic.resolvePattern";
    public static final String PUBLISH_BUILD_INFO = "artifactory.generic.publishBuildInfo";
    public static final String INCLUDE_ENV_VARS = "artifactory.generic.includeEnvVars";
    public static final String ARTIFACT_SPECS = "artifactory.generic.artifactSpecs";
    public static final String ENV_VARS_INCLUDE_PATTERNS = "artifactory.generic.envVarsIncludePatterns";
    public static final String ENV_VARS_EXCLUDE_PATTERNS = "artifactory.generic.envVarsExcludePatterns";
    public static final String ENABLE_BINTRAY_CONFIGURATION = "bintrayConfiguration";
    public static final String SIGN_METHOD_MAP_KEY = "signMethods";
    public static final Map<String, String> SIGN_METHOD_MAP = ImmutableMap.of("false", "Don't Sign", "true", "Sign");
    private final Map<String, String> env;

    public GenericContext(Map<String, String> env) {
        this.env = env;
    }

    public static Set<String> getFieldsToCopy() {
        HashSet<String> fieldsToCopy = Sets.newHashSet("builder.artifactoryGenericBuilder.artifactoryServerId", REPO_KEY, REPO_RESOLVE_KEY, USERNAME, PASSWORD, DEPLOY_PATTERN, SPEC_SOURCE_JOB_CONFIGURATION, SPEC_SOURCE_FILE, ARTIFACT_SPECS, RESOLVE_PATTERN, PUBLISH_BUILD_INFO, INCLUDE_ENV_VARS, ENV_VARS_INCLUDE_PATTERNS, ENV_VARS_EXCLUDE_PATTERNS, ENABLE_BINTRAY_CONFIGURATION, USE_SPECS_CHOICE, SPEC_SOURCE_CHOICE);
        fieldsToCopy.addAll(PushToBintrayContext.bintrayFields);
        return fieldsToCopy;
    }

    public long getSelectedServerId() {
        String serverId = this.env.get("builder.artifactoryGenericBuilder.artifactoryServerId");
        if (StringUtils.isBlank(serverId)) {
            serverId = this.env.get("artifactory.generic.artifactoryServerId");
        }
        if (StringUtils.isBlank(serverId)) {
            return -1L;
        }
        return Long.parseLong(serverId);
    }

    public String getRepoKey() {
        String key = this.env.get(REPO_KEY);
        if (StringUtils.isBlank(key)) {
            return this.env.get("artifactory.generic.deployableRepo");
        }
        return key;
    }

    public String getUsername() {
        return this.env.get(USERNAME);
    }

    public String getPassword() {
        return this.env.get(PASSWORD);
    }

    public String getDeployPattern() {
        return this.env.get(DEPLOY_PATTERN);
    }

    public boolean isUseFileSpecs() {
        return "specs".equals(this.env.get(USE_SPECS_CHOICE));
    }

    public boolean isFileSpecInJobConfiguration() {
        return "jobConfiguration".equals(this.env.get(SPEC_SOURCE_CHOICE));
    }

    public String getJobConfigurationSpec() {
        return this.env.get(SPEC_SOURCE_JOB_CONFIGURATION);
    }

    public String getFilePathSpec() {
        return this.env.get(SPEC_SOURCE_FILE);
    }

    public String getResolvePattern() {
        return this.env.get(RESOLVE_PATTERN);
    }

    public boolean isPublishBuildInfo() {
        return Boolean.parseBoolean(this.env.get(PUBLISH_BUILD_INFO));
    }

    public boolean isIncludeEnvVars() {
        return Boolean.parseBoolean(this.env.get(INCLUDE_ENV_VARS));
    }

    public String getEnvVarsIncludePatterns() {
        return this.env.get(ENV_VARS_INCLUDE_PATTERNS);
    }

    public String getEnvVarsExcludePatterns() {
        return this.env.get(ENV_VARS_EXCLUDE_PATTERNS);
    }

    public String getArtifactSpecs() {
        return this.env.get(ARTIFACT_SPECS);
    }
}

