/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.context;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jfrog.bamboo.bintray.PushToBintrayContext;
import org.jfrog.bamboo.context.AbstractBuildContext;

public class GradleBuildContext
extends AbstractBuildContext {
    public static final String PREFIX = "builder.artifactoryGradleBuilder.";
    public static final String SWITCHES_PARAM = "switches";
    public static final String TASKS_PARAM = "tasks";
    public static final String BUILD_SCRIPT_PARAM = "buildScript";
    public static final String BUILD_FILE_PARAM = "buildFile";
    public static final String USE_GRADLE_WRAPPER_PARAM = "useGradleWrapper";
    public static final String GRADLE_WRAPPER_LOCATION_PARAM = "gradleWrapperLocation";

    public GradleBuildContext(Map<String, String> env) {
        super(PREFIX, env);
    }

    public String getSwitches() {
        return (String)this.env.get("builder.artifactoryGradleBuilder.switches");
    }

    public String getTasks() {
        return (String)this.env.get("builder.artifactoryGradleBuilder.tasks");
    }

    public String getBuildScript() {
        return (String)this.env.get("builder.artifactoryGradleBuilder.buildScript");
    }

    public String getBuildFile() {
        return (String)this.env.get("builder.artifactoryGradleBuilder.buildFile");
    }

    public String getReleaseProps() {
        return (String)this.env.get("builder.artifactoryGradleBuilder.releaseProps");
    }

    public String getNextIntegProps() {
        return (String)this.env.get("builder.artifactoryGradleBuilder.nextIntegProps");
    }

    @Override
    public String getArtifactSpecs() {
        return (String)this.env.get("builder.artifactoryGradleBuilder.artifactSpecs");
    }

    public boolean isUseGradleWrapper() {
        return Boolean.valueOf((String)this.env.get("builder.artifactoryGradleBuilder.useGradleWrapper"));
    }

    public String getGradleWrapperLocation() {
        return (String)this.env.get("builder.artifactoryGradleBuilder.gradleWrapperLocation");
    }

    public static GradleBuildContext createGradleContextFromMap(Map<String, Object> map) {
        Map<String, String> transformed = Maps.transformValues(map, new Function<Object, String>(){

            @Override
            public String apply(Object input) {
                if (input == null) {
                    return "";
                }
                return input.toString();
            }
        });
        return new GradleBuildContext(transformed);
    }

    public static Set<String> getFieldsToCopy() {
        HashSet<String> fieldsToCopy = Sets.newHashSet("builder.artifactoryGradleBuilder.switches", "builder.artifactoryGradleBuilder.tasks", "builder.artifactoryGradleBuilder.buildScript", "builder.artifactoryGradleBuilder.buildFile", "builder.artifactoryGradleBuilder.useGradleWrapper", "builder.artifactoryGradleBuilder.gradleWrapperLocation", "builder.artifactoryGradleBuilder.artifactoryServerId", "builder.artifactoryGradleBuilder.resolutionRepo", "builder.artifactoryGradleBuilder.publishingRepo", "builder.artifactoryGradleBuilder.deployerUsername", "builder.artifactoryGradleBuilder.deployerPassword", "builder.artifactoryGradleBuilder.useArtifactoryGradlePlugin", "publishBuildInfo", "includeEnvVars", "envVarsExcludePatterns", "envVarsIncludePatterns", "runLicenseChecks", "builder.artifactoryGradleBuilder.licenseViolationRecipients", "builder.artifactoryGradleBuilder.limitChecksToScopes", "builder.artifactoryGradleBuilder.environmentVariables", "builder.artifactoryGradleBuilder.includePublishedArtifacts", "builder.artifactoryGradleBuilder.disableAutoLicenseDiscovery", "publishArtifacts", "builder.artifactoryGradleBuilder.publishMavenDescriptors", "builder.artifactoryGradleBuilder.publishIvyDescriptors", "useM2CompatiblePatterns", "builder.artifactoryGradleBuilder.ivyPattern", "builder.artifactoryGradleBuilder.buildJdk", "builder.artifactoryGradleBuilder.artifactPattern", "builder.artifactoryGradleBuilder.publishIncludePatterns", "builder.artifactoryGradleBuilder.publishExcludePatterns", "builder.artifactoryGradleBuilder.filterExcludedArtifactsFromBuild", "builder.artifactoryGradleBuilder.artifactSpecs", "builder.artifactoryGradleBuilder.executable", "testChecked", "builder.artifactoryGradleBuilder.testResultsDirectory", "testDirectoryOption", "enableReleaseManagement", "bintrayConfiguration", "builder.artifactoryGradleBuilder.vcsTagBase", "builder.artifactoryGradleBuilder.gitReleaseBranch", "builder.artifactoryGradleBuilder.alternativeTasks", "builder.artifactoryGradleBuilder.releaseProps", "builder.artifactoryGradleBuilder.nextIntegProps");
        fieldsToCopy.addAll(GradleBuildContext.getBlackDuckFieldsToCopy());
        fieldsToCopy.addAll(GradleBuildContext.getOldCheckBoxFieldsToCopy());
        fieldsToCopy.addAll(PushToBintrayContext.bintrayFields);
        fieldsToCopy.addAll(GradleBuildContext.getVcsFieldsToCopy());
        return fieldsToCopy;
    }

    private static Set<String> getOldCheckBoxFieldsToCopy() {
        return Sets.newHashSet("builder.artifactoryGradleBuilder.publishBuildInfo", "builder.artifactoryGradleBuilder.includeEnvVars", "builder.artifactoryGradleBuilder.runLicenseChecks", "builder.artifactoryGradleBuilder.publishArtifacts", "builder.artifactoryGradleBuilder.testChecked", "builder.artifactoryGradleBuilder.testDirectoryOption", "builder.artifactoryGradleBuilder.enableReleaseManagement", "builder.artifactoryGradleBuilder.useM2CompatiblePatterns");
    }
}

