/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.context;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jfrog.bamboo.bintray.PushToBintrayContext;
import org.jfrog.bamboo.context.AbstractBuildContext;

public class IvyBuildContext
extends AbstractBuildContext {
    public static final String PREFIX = "builder.artifactoryIvyBuilder.";
    public static final String ANT_OPTS_PARAM = "antOpts";
    public static final String TARGET_OPTS_PARAM = "target";
    public static final String BUILD_FILE = "buildFile";
    public static final String DEPLOYABLE_REPO_KEY = "deployableRepo";
    public static final String PUBLISH_ARTIFACTS = "deployArtifacts";
    public static final String EXCLUDE_PATTERN = "deployExcludePatterns";
    public static final String INCLUDE_PATTERN = "deployIncludePatterns";
    public static final String WORKING_SUB_DIRECTORY = "workingSubDirectory";

    public IvyBuildContext(Map<String, String> env) {
        super(PREFIX, env);
    }

    @Override
    public String getPublishingRepo() {
        return (String)this.env.get("builder.artifactoryIvyBuilder.deployableRepo");
    }

    public String getAntOpts() {
        return (String)this.env.get("builder.artifactoryIvyBuilder.antOpts");
    }

    public String getBuildFile() {
        return (String)this.env.get("builder.artifactoryIvyBuilder.buildFile");
    }

    @Override
    public boolean isPublishArtifacts() {
        return Boolean.parseBoolean((String)this.env.get(PUBLISH_ARTIFACTS));
    }

    public String getTargets() {
        return (String)this.env.get("builder.artifactoryIvyBuilder.target");
    }

    public String getWorkingSubDirectory() {
        return (String)this.env.get("builder.artifactoryIvyBuilder.workingSubDirectory");
    }

    @Override
    public String getExcludePattern() {
        return (String)this.env.get("builder.artifactoryIvyBuilder.deployExcludePatterns");
    }

    @Override
    public void resetContextToDefault() {
        super.resetContextToDefault();
        this.env.put("builder.artifactoryIvyBuilder.deployableRepo", "");
        this.env.put("builder.artifactoryIvyBuilder.deployIncludePatterns", "");
        this.env.put(PUBLISH_ARTIFACTS, "true");
        this.env.put("builder.artifactoryIvyBuilder.deployExcludePatterns", "");
        this.env.put("builder.artifactoryIvyBuilder.deployIncludePatterns", "");
    }

    @Override
    public String getIncludePattern() {
        return (String)this.env.get("builder.artifactoryIvyBuilder.deployIncludePatterns");
    }

    public static IvyBuildContext createIvyContextFromMap(Map<String, Object> map) {
        Map<String, String> transformed = Maps.transformValues(map, new Function<Object, String>(){

            @Override
            public String apply(Object input) {
                return input.toString();
            }
        });
        return new IvyBuildContext(transformed);
    }

    public static Set<String> getFieldsToCopy() {
        HashSet<String> fieldsToCopy = Sets.newHashSet("builder.artifactoryIvyBuilder.antOpts", "builder.artifactoryIvyBuilder.artifactoryServerId", "builder.artifactoryIvyBuilder.resolutionRepo", "builder.artifactoryIvyBuilder.deployableRepo", "builder.artifactoryIvyBuilder.deployerUsername", "builder.artifactoryIvyBuilder.deployerPassword", "publishBuildInfo", "runLicenseChecks", "builder.artifactoryIvyBuilder.licenseViolationRecipients", "builder.artifactoryIvyBuilder.limitChecksToScopes", "builder.artifactoryIvyBuilder.environmentVariables", "includeEnvVars", "envVarsIncludePatterns", "envVarsExcludePatterns", "builder.artifactoryIvyBuilder.includePublishedArtifacts", "builder.artifactoryIvyBuilder.disableAutoLicenseDiscovery", PUBLISH_ARTIFACTS, "builder.artifactoryIvyBuilder.publishMavenDescriptors", "builder.artifactoryIvyBuilder.buildFile", "builder.artifactoryIvyBuilder.publishIvyDescriptors", "useM2CompatiblePatterns", "builder.artifactoryIvyBuilder.ivyPattern", "builder.artifactoryIvyBuilder.target", "builder.artifactoryIvyBuilder.buildJdk", "builder.artifactoryIvyBuilder.artifactPattern", "builder.artifactoryIvyBuilder.deployIncludePatterns", "builder.artifactoryIvyBuilder.filterExcludedArtifactsFromBuild", "builder.artifactoryIvyBuilder.executable", "builder.artifactoryIvyBuilder.deployExcludePatterns", "testChecked", "builder.artifactoryIvyBuilder.testResultsDirectory", "testDirectoryOption", "builder.artifactoryIvyBuilder.workingSubDirectory", "bintrayConfiguration");
        fieldsToCopy.addAll(IvyBuildContext.getBlackDuckFieldsToCopy());
        fieldsToCopy.addAll(IvyBuildContext.getOldCheckBoxFieldsToCopy());
        fieldsToCopy.addAll(PushToBintrayContext.bintrayFields);
        return fieldsToCopy;
    }

    private static Set<String> getOldCheckBoxFieldsToCopy() {
        return Sets.newHashSet("builder.artifactoryIvyBuilder.publishBuildInfo", "builder.artifactoryIvyBuilder.runLicenseChecks", "builder.artifactoryIvyBuilder.deployArtifacts", "builder.artifactoryIvyBuilder.testChecked", "builder.artifactoryIvyBuilder.testDirectoryOption", "builder.artifactoryIvyBuilder.enableReleaseManagement", "builder.artifactoryIvyBuilder.useM2CompatiblePatterns");
    }
}

