/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.context;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jfrog.bamboo.bintray.PushToBintrayContext;
import org.jfrog.bamboo.context.AbstractBuildContext;

public class Maven3BuildContext
extends AbstractBuildContext {
    public static final String PREFIX = "builder.artifactoryMaven3Builder.";
    public static final String DEPLOYABLE_REPO_KEY = "deployableRepo";
    public static final String PUBLISH_ARTIFACTS = "deployMavenArtifacts";
    public static final String RECORD_ALL_DEPENDENCIES = "recordAllDependencies";
    public static final String INCLUDE_PATTERN = "deployIncludePatterns";
    public static final String EXCLUDE_PATTERN = "deployExcludePatterns";
    public static final String GOALS = "goal";
    public static final String MAVEN_OPTS = "mavenOpts";
    public static final String PROJECT_FILE = "projectFile";
    public static final String ADDITIONAL_MAVEN_PARAMS = "additionalMavenParams";
    public static final String WORKING_SUB_DIRECTORY = "workingSubDirectory";
    public static final String RESOLVE_FROM_ARTIFACTORY = "resolveFromArtifacts";
    public static final String RESOLUTION_SERVER_ID = "resolutionArtifactoryServerId";
    public static final String RESOLVER_USER_NAME = "resolverUsername";
    public static final String RESOLVER_PASSWORD = "resolverPassword";

    public Maven3BuildContext(Map<String, String> env) {
        super(PREFIX, env);
    }

    public String getGoals() {
        return (String)this.env.get("builder.artifactoryMaven3Builder.goal");
    }

    public String getProjectFile() {
        return (String)this.env.get("builder.artifactoryMaven3Builder.projectFile");
    }

    public String getAdditionalMavenParams() {
        return (String)this.env.get("builder.artifactoryMaven3Builder.additionalMavenParams");
    }

    @Override
    public String getPublishingRepo() {
        return (String)this.env.get("builder.artifactoryMaven3Builder.deployableRepo");
    }

    @Override
    public boolean isPublishArtifacts() {
        return Boolean.parseBoolean((String)this.env.get(PUBLISH_ARTIFACTS));
    }

    public Boolean isRecordAllDependencies() {
        return Boolean.parseBoolean((String)this.env.get(RECORD_ALL_DEPENDENCIES));
    }

    public boolean isResolveFromArtifactory() {
        return Boolean.parseBoolean((String)this.env.get(RESOLVE_FROM_ARTIFACTORY));
    }

    public long getResolutionArtifactoryServerId() {
        String serverId = (String)this.env.get("builder.artifactoryMaven3Builder.resolutionArtifactoryServerId");
        if (StringUtils.isBlank(serverId)) {
            return -1L;
        }
        return Long.parseLong(serverId);
    }

    public String getResolverUserName() {
        return (String)this.env.get("builder.artifactoryMaven3Builder.resolverUsername");
    }

    public String getResolverPassword() {
        return (String)this.env.get("builder.artifactoryMaven3Builder.resolverPassword");
    }

    public String getMavenOpts() {
        return (String)this.env.get("builder.artifactoryMaven3Builder.mavenOpts");
    }

    public String getWorkingSubDirectory() {
        return (String)this.env.get("builder.artifactoryMaven3Builder.workingSubDirectory");
    }

    @Override
    public String getIncludePattern() {
        return (String)this.env.get("builder.artifactoryMaven3Builder.deployIncludePatterns");
    }

    @Override
    public String getExcludePattern() {
        return (String)this.env.get("builder.artifactoryMaven3Builder.deployExcludePatterns");
    }

    @Override
    public void resetContextToDefault() {
        super.resetContextToDefault();
        this.env.put("builder.artifactoryMaven3Builder.deployableRepo", "");
        this.env.put(PUBLISH_ARTIFACTS, "true");
        this.env.put(RECORD_ALL_DEPENDENCIES, "false");
        this.env.put("builder.artifactoryMaven3Builder.deployIncludePatterns", "");
        this.env.put("builder.artifactoryMaven3Builder.deployExcludePatterns", "");
    }

    public static Maven3BuildContext createMavenContextFromMap(Map<String, Object> map) {
        Map<String, String> transformed = Maps.transformValues(map, new Function<Object, String>(){

            @Override
            public String apply(Object input) {
                if (input == null) {
                    return "";
                }
                return input.toString();
            }
        });
        return new Maven3BuildContext(transformed);
    }

    public static Set<String> getFieldsToCopy() {
        HashSet<String> fieldsToCopy = Sets.newHashSet("builder.artifactoryMaven3Builder.artifactoryServerId", "builder.artifactoryMaven3Builder.resolutionRepo", "builder.artifactoryMaven3Builder.deployableRepo", "builder.artifactoryMaven3Builder.deployerUsername", "builder.artifactoryMaven3Builder.deployerPassword", "publishBuildInfo", "includeEnvVars", "envVarsExcludePatterns", "envVarsIncludePatterns", "runLicenseChecks", "builder.artifactoryMaven3Builder.licenseViolationRecipients", "builder.artifactoryMaven3Builder.limitChecksToScopes", "builder.artifactoryMaven3Builder.environmentVariables", "builder.artifactoryMaven3Builder.includePublishedArtifacts", "builder.artifactoryMaven3Builder.disableAutoLicenseDiscovery", PUBLISH_ARTIFACTS, RECORD_ALL_DEPENDENCIES, "builder.artifactoryMaven3Builder.publishMavenDescriptors", "builder.artifactoryMaven3Builder.projectFile", "builder.artifactoryMaven3Builder.publishIvyDescriptors", "useM2CompatiblePatterns", "builder.artifactoryMaven3Builder.ivyPattern", "builder.artifactoryMaven3Builder.artifactPattern", "builder.artifactoryMaven3Builder.deployIncludePatterns", "builder.artifactoryMaven3Builder.deployExcludePatterns", "builder.artifactoryMaven3Builder.filterExcludedArtifactsFromBuild", "builder.artifactoryMaven3Builder.goal", "builder.artifactoryMaven3Builder.additionalMavenParams", "builder.artifactoryMaven3Builder.buildJdk", "builder.artifactoryMaven3Builder.mavenOpts", "builder.artifactoryMaven3Builder.executable", "testChecked", "builder.artifactoryMaven3Builder.testResultsDirectory", "testDirectoryOption", "builder.artifactoryMaven3Builder.workingSubDirectory", "enableReleaseManagement", "bintrayConfiguration", "builder.artifactoryMaven3Builder.vcsTagBase", "builder.artifactoryMaven3Builder.gitReleaseBranch", "builder.artifactoryMaven3Builder.alternativeTasks", RESOLVE_FROM_ARTIFACTORY, "builder.artifactoryMaven3Builder.resolutionArtifactoryServerId", "builder.artifactoryMaven3Builder.resolverUsername", "builder.artifactoryMaven3Builder.resolverPassword");
        fieldsToCopy.addAll(Maven3BuildContext.getBlackDuckFieldsToCopy());
        fieldsToCopy.addAll(Maven3BuildContext.getOldCheckBoxFieldsToCopy());
        fieldsToCopy.addAll(PushToBintrayContext.bintrayFields);
        fieldsToCopy.addAll(Maven3BuildContext.getVcsFieldsToCopy());
        return fieldsToCopy;
    }

    private static Set<String> getOldCheckBoxFieldsToCopy() {
        return Sets.newHashSet("builder.artifactoryMaven3Builder.publishBuildInfo", "builder.artifactoryMaven3Builder.runLicenseChecks", "builder.artifactoryMaven3Builder.deployMavenArtifacts", "builder.artifactoryMaven3Builder.testChecked", "builder.artifactoryMaven3Builder.testDirectoryOption", "builder.artifactoryMaven3Builder.enableReleaseManagement", "builder.artifactoryMaven3Builder.useM2CompatiblePatterns");
    }
}

