/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.deployment;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.task.TaskDefinition;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jfrog.bamboo.configuration.AbstractArtifactoryConfiguration;

public class ArtifactoryDeploymentConfiguration
extends AbstractArtifactoryConfiguration {
    public static final String DEPLOYMENT_PREFIX = "artifactory.deployment.";
    public static final String DEPLOYMENT_REPOSITORY = "deploymentRepository";
    public static final String PASSWORD = "password";
    public static final String USERNAME = "username";

    private static Set<String> getFieldsToCopy() {
        return Sets.newHashSet("artifactory.deployment.artifactoryServerId", "artifactory.deployment.username", "artifactory.deployment.password", "artifactory.deployment.deploymentRepository");
    }

    @Override
    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
        context.put("serverConfigManager", this.serverConfigManager);
        context.put("selectedServerId", -1);
        context.put("artifactoryServerId", -1);
        this.contextPutEmpty(context, USERNAME);
        this.contextPutEmpty(context, PASSWORD);
        this.contextPutEmpty(context, DEPLOYMENT_REPOSITORY);
        this.contextPutEmpty(context, "artifactoryServerId");
    }

    @Override
    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        this.populateContextWithConfiguration(context, taskDefinition, ArtifactoryDeploymentConfiguration.getFieldsToCopy());
        String selectedServerId = (String)taskDefinition.getConfiguration().get("artifactory.deployment.artifactoryServerId");
        String selectedRepoKey = (String)taskDefinition.getConfiguration().get("artifactory.deployment.deploymentRepository");
        String username = (String)taskDefinition.getConfiguration().get("artifactory.deployment.username");
        String password = (String)taskDefinition.getConfiguration().get("artifactory.deployment.password");
        if (StringUtils.isBlank(selectedServerId)) {
            selectedServerId = (String)taskDefinition.getConfiguration().get("artifactoryServerId");
        }
        if (StringUtils.isBlank(selectedRepoKey)) {
            selectedRepoKey = (String)taskDefinition.getConfiguration().get(DEPLOYMENT_REPOSITORY);
        }
        if (StringUtils.isBlank(username)) {
            username = (String)taskDefinition.getConfiguration().get(USERNAME);
            context.put("artifactory.deployment.username", username);
        }
        if (StringUtils.isBlank(password)) {
            password = (String)taskDefinition.getConfiguration().get(PASSWORD);
            context.put("artifactory.deployment.password", password);
        }
        context.put("serverConfigManager", this.serverConfigManager);
        context.put("selectedServerId", selectedServerId);
        context.put("selectedRepoKey", selectedRepoKey);
    }

    @Override
    protected String getKey() {
        return DEPLOYMENT_PREFIX;
    }

    @Override
    protected String getDeployableRepoKey() {
        return DEPLOYMENT_REPOSITORY;
    }

    public boolean taskProducesTestResults(TaskDefinition taskDefinition) {
        return false;
    }

    private void contextPut(Map<String, Object> context, String key, String value) {
        context.put(DEPLOYMENT_PREFIX + key, value);
    }

    private void contextPutEmpty(Map<String, Object> context, String key) {
        context.put(DEPLOYMENT_PREFIX + key, "");
    }

    @Override
    @NotNull
    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        Map<String, String> taskConfigMap = super.generateTaskConfigMap(params, previousTaskDefinition);
        this.taskConfiguratorHelper.populateTaskConfigMapWithActionParameters(taskConfigMap, params, ArtifactoryDeploymentConfiguration.getFieldsToCopy());
        this.decryptFields(taskConfigMap);
        return taskConfigMap;
    }
}

