/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.deployment;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.deployments.execution.DeploymentTaskContext;
import com.atlassian.bamboo.deployments.execution.DeploymentTaskType;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.runtime.RuntimeTaskDefinition;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jfrog.bamboo.admin.ServerConfig;
import org.jfrog.bamboo.admin.ServerConfigManager;
import org.jfrog.bamboo.util.BuildInfoLog;
import org.jfrog.bamboo.util.TaskUtils;
import org.jfrog.bamboo.util.deployment.FilesCollector;
import org.jfrog.build.api.util.FileChecksumCalculator;
import org.jfrog.build.client.DeployDetails;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryBuildInfoClient;

public class ArtifactoryDeploymentTask
implements DeploymentTaskType {
    private static final Logger log = Logger.getLogger(ArtifactoryDeploymentTask.class);
    private String repositoryKey;
    private String artifactsRootDirectory;
    private BuildLogger buildLogger;
    private ArtifactoryBuildInfoClient client;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public TaskResult execute(@NotNull DeploymentTaskContext deploymentTaskContext) throws TaskException {
        TaskResult result;
        ServerConfig serverConfig;
        this.buildLogger = deploymentTaskContext.getBuildLogger();
        ServerConfigManager serverConfigManager = ServerConfigManager.getInstance();
        String serverId = (String)deploymentTaskContext.getConfigurationMap().get((Object)"artifactory.deployment.artifactoryServerId");
        if (StringUtils.isBlank(serverId)) {
            serverId = (String)deploymentTaskContext.getConfigurationMap().get((Object)"artifactoryServerId");
        }
        if ((serverConfig = serverConfigManager.getServerConfigById(Long.parseLong(serverId))) == null) {
            this.buildLogger.addErrorLogEntry("Could not find Artifactpry server. Please check the Artifactory server in the task configuration.");
            return TaskResultBuilder.newBuilder((CommonTaskContext)deploymentTaskContext).failedWithError().build();
        }
        this.repositoryKey = (String)deploymentTaskContext.getConfigurationMap().get((Object)"artifactory.deployment.deploymentRepository");
        if (StringUtils.isBlank(this.repositoryKey)) {
            this.repositoryKey = (String)deploymentTaskContext.getConfigurationMap().get((Object)"deploymentRepository");
        }
        this.artifactsRootDirectory = deploymentTaskContext.getRootDirectory().getAbsolutePath();
        String username = (String)deploymentTaskContext.getConfigurationMap().get((Object)"artifactory.deployment.username");
        String password = (String)deploymentTaskContext.getConfigurationMap().get((Object)"artifactory.deployment.password");
        if (StringUtils.isBlank(username) && StringUtils.isBlank(password)) {
            username = serverConfig.getUsername();
            password = serverConfig.getPassword();
        }
        this.client = new ArtifactoryBuildInfoClient(serverConfig.getUrl(), username, password, new BuildInfoLog(log));
        try {
            RuntimeTaskDefinition artifactDownloadTask = TaskUtils.findDownloadArtifactsTask(deploymentTaskContext.getCommonContext().getRuntimeTaskDefinitions());
            FilesCollector filesCollector = new FilesCollector(this.artifactsRootDirectory, (TaskDefinition)artifactDownloadTask);
            Map<String, Set<File>> artifacts = filesCollector.getCollectedFiles();
            Set<DeployDetails> deployDetailsSet = this.createDeploymentDetailsForArtifacts(artifacts);
            this.deploy(deployDetailsSet);
            result = TaskResultBuilder.newBuilder((CommonTaskContext)deploymentTaskContext).success().build();
        }
        catch (Exception e) {
            this.buildLogger.addErrorLogEntry("Error while deploying artifacts to Artifactory: " + e.getMessage());
            result = TaskResultBuilder.newBuilder((CommonTaskContext)deploymentTaskContext).failedWithError().build();
        }
        finally {
            this.client.close();
        }
        return result;
    }

    private void deploy(Set<DeployDetails> deployDetailsSet) throws IOException {
        for (DeployDetails deployDetails : deployDetailsSet) {
            this.buildLogger.addBuildLogEntry("Deploying: " + deployDetails.getArtifactPath() + " to: " + deployDetails.getTargetRepository());
            this.client.deployArtifact(deployDetails);
        }
    }

    private Set<DeployDetails> createDeploymentDetailsForArtifacts(Map<String, Set<File>> artifacts) {
        HashSet<DeployDetails> deployDetailList = Sets.newHashSet();
        for (String path : artifacts.keySet()) {
            Set<File> filesForPath = artifacts.get(path);
            for (File file : filesForPath) {
                deployDetailList.add(this.createDeployDetailsForOneArtifact(file, path));
            }
        }
        return deployDetailList;
    }

    private DeployDetails createDeployDetailsForOneArtifact(File artifact, String pathToArtifact) {
        DeployDetails.Builder deployDetailsBuilder = new DeployDetails.Builder();
        try {
            Map<String, String> checksum = FileChecksumCalculator.calculateChecksums(artifact, "SHA1", "MD5");
            deployDetailsBuilder.artifactPath(this.createArtifactPath(artifact.getPath(), pathToArtifact)).file(artifact).targetRepository(this.repositoryKey).sha1(checksum.get("SHA1")).md5(checksum.get("MD5"));
            return deployDetailsBuilder.build();
        }
        catch (Exception e) {
            throw new RuntimeException("Error while creating Artifact details. " + e.getMessage(), e);
        }
    }

    private String createArtifactPath(String artifactPath, String subDir) {
        int numberOfSeparators = StringUtils.isBlank(subDir) ? 1 : 2;
        int start = this.artifactsRootDirectory.length() + subDir.length() + numberOfSeparators;
        return StringUtils.substring(artifactPath, start).replace("\\", "/");
    }
}

