/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.processor;

import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.build.BuildDefinition;
import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.build.CustomBuildProcessor;
import com.atlassian.bamboo.build.artifact.ArtifactManager;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionContext;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionContextImpl;
import com.atlassian.bamboo.security.SecureToken;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.task.AbstractBuildTask;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jfrog.bamboo.context.AbstractBuildContext;
import org.jfrog.bamboo.context.GradleBuildContext;
import org.jfrog.bamboo.util.TaskDefinitionHelper;
import org.jfrog.bamboo.util.version.VcsHelper;

public class GradlePropertiesCopier
extends AbstractBuildTask
implements CustomBuildProcessor {
    private static final Logger log = Logger.getLogger(GradlePropertiesCopier.class);
    private volatile ArtifactManager artifactManager;
    private BuildLoggerManager buildLoggerManager;

    @NotNull
    public BuildContext call() throws Exception {
        PlanResultKey planResultKey = this.buildContext.getPlanResultKey();
        BuildLogger buildLogger = this.buildLoggerManager.getLogger((ResultKey)planResultKey);
        BuildDefinition definition = this.buildContext.getBuildDefinition();
        File checkoutDir = VcsHelper.getCheckoutDirectory(this.buildContext);
        if (checkoutDir == null) {
            return this.buildContext;
        }
        List taskDefinitions = definition.getTaskDefinitions();
        TaskDefinition gradleDefinition = TaskDefinitionHelper.findGradleDefinition(taskDefinitions);
        if (gradleDefinition == null) {
            log.debug("Current build is not a gradle build");
            return this.buildContext;
        }
        if (checkoutDir.exists()) {
            File gradleProps;
            GradleBuildContext gradleBuildContext = (GradleBuildContext)AbstractBuildContext.createContextFromMap(gradleDefinition.getConfiguration());
            String location = "";
            String directory = gradleBuildContext.getBuildScript();
            if (StringUtils.isNotBlank(directory)) {
                location = directory;
            }
            if ((gradleProps = new File(new File(checkoutDir, location), "gradle.properties")).exists()) {
                TaskDefinition def = TaskDefinitionHelper.findGradleDefinition(this.buildContext.getRuntimeTaskDefinitions());
                String securityToken = (String)this.buildContext.getRuntimeTaskContext().getRuntimeContextForTask(def).get("securityToken");
                ArtifactDefinitionContextImpl artifact = new ArtifactDefinitionContextImpl("gradle", false, SecureToken.createFromString((String)securityToken));
                artifact.setLocation(location);
                artifact.setCopyPattern(gradleProps.getName());
                HashMap config = Maps.newHashMap();
                this.artifactManager.publish(buildLogger, planResultKey, checkoutDir, (ArtifactDefinitionContext)artifact, config, 1);
            }
        }
        return this.buildContext;
    }

    public void setArtifactManager(ArtifactManager artifactManager) {
        this.artifactManager = artifactManager;
    }

    public void setBuildLoggerManager(BuildLoggerManager buildLoggerManager) {
        this.buildLoggerManager = buildLoggerManager;
    }
}

