/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.promotion;

import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.variable.VariableDefinition;
import com.atlassian.bamboo.variable.VariableDefinitionManager;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.codehaus.jackson.map.introspect.JacksonAnnotationIntrospector;
import org.jfrog.bamboo.release.action.ReleasePromotionAction;
import org.jfrog.bamboo.util.ActionLog;
import org.jfrog.build.api.builder.PromotionBuilder;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryBuildInfoClient;

public class PromotionThread
extends Thread {
    public static final String NEXUS_PUSH_PROPERTY_PREFIX = "bintrayOsoPush.";
    transient Logger log = Logger.getLogger(PromotionThread.class);
    private ReleasePromotionAction action;
    private ArtifactoryBuildInfoClient client;
    private String bambooUsername;
    private ActionLog releaseLog;

    public PromotionThread(ReleasePromotionAction action, ArtifactoryBuildInfoClient client, String bambooUsername) {
        this.action = action;
        this.client = client;
        this.bambooUsername = bambooUsername;
        this.releaseLog = ReleasePromotionAction.promotionContext.getActionLog();
        this.releaseLog.setLogger(this.log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            ReleasePromotionAction.promotionContext.getLock().lock();
            ReleasePromotionAction.promotionContext.setBuildKey(this.action.getBuildKey());
            ReleasePromotionAction.promotionContext.setBuildNumber(this.action.getBuildNumber());
            ReleasePromotionAction.promotionContext.setDone(false);
            ReleasePromotionAction.promotionContext.getLog().clear();
            if (this.performPromotion() && "pushToNexusMode".equals(this.action.getPromotionMode())) {
                this.executePushToNexusPlugin();
            }
        }
        catch (Exception e) {
            String message = "An error occurred: " + e.getMessage();
            this.releaseLog.logError(message, e);
        }
        finally {
            try {
                this.client.close();
            }
            finally {
                ReleasePromotionAction.promotionContext.setDone(true);
                ReleasePromotionAction.promotionContext.getLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executePushToNexusPlugin() throws IOException {
        this.releaseLog.logError("Executing 'Promotion to Bintray and Central' plugin ...");
        VariableDefinitionManager varDefManager = this.action.getVariableDefinitionManager();
        PlanIdentifier planIdentifier = this.action.getPlanManager().getPlanIdentifierForPermissionCheckingByKey(this.action.getPlanKey());
        if (planIdentifier == null) {
            String message = "Plugin execution failed: Couldn't find nexusPush variables.<br/>";
            this.releaseLog.logError(message);
            return false;
        }
        HashMap<String, String> executeRequestParams = Maps.newHashMap();
        executeRequestParams.put("build.name", this.action.getImmutableBuild().getName());
        executeRequestParams.put("build.number", this.action.getBuildNumber().toString());
        List planVariables = varDefManager.getPlanVariables(planIdentifier);
        for (VariableDefinition planVariable : planVariables) {
            String key = planVariable.getKey();
            if (!StringUtils.isNotBlank(key) || !key.startsWith(NEXUS_PUSH_PROPERTY_PREFIX)) continue;
            executeRequestParams.put(StringUtils.removeStart(key, NEXUS_PUSH_PROPERTY_PREFIX), planVariable.getValue());
        }
        HttpResponse nexusPushResponse = null;
        try {
            nexusPushResponse = this.client.executePromotionUserPlugin("bintrayOsoPush", this.action.getImmutableBuild().getName(), this.action.getBuildNumber().toString(), null);
            StatusLine responseStatusLine = nexusPushResponse.getStatusLine();
            if (200 == responseStatusLine.getStatusCode()) {
                this.releaseLog.logMessage("Plugin successfully executed!");
                boolean key = true;
                return key;
            }
            String responseContent = this.entityToString(nexusPushResponse);
            String message = "Plugin execution failed: " + responseStatusLine + "<br/>" + responseContent;
            this.releaseLog.logError(message);
            boolean bl = false;
            return bl;
        }
        finally {
            HttpEntity entity;
            if (nexusPushResponse != null && (entity = nexusPushResponse.getEntity()) != null) {
                EntityUtils.consume(entity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean performPromotion() throws IOException {
        this.releaseLog.logMessage("Promoting build ...");
        PromotionBuilder promotionBuilder = new PromotionBuilder().status(this.action.getTarget()).comment(this.action.getComment()).ciUser(this.bambooUsername).targetRepo(this.action.getPromotionRepo()).dependencies(this.action.isIncludeDependencies()).copy(this.action.isUseCopy()).dryRun(true);
        this.releaseLog.logMessage("Performing dry run promotion (no changes are made during dry run) ...");
        String buildName = this.action.getImmutableBuild().getName();
        String buildNumber = this.action.getBuildNumber().toString();
        HttpResponse dryResponse = null;
        HttpResponse wetResponse = null;
        try {
            dryResponse = this.client.stageBuild(buildName, buildNumber, promotionBuilder.build());
            if (this.checkSuccess(dryResponse, true)) {
                this.releaseLog.logMessage("Dry run finished successfully. Performing promotion ...");
                wetResponse = this.client.stageBuild(buildName, buildNumber, promotionBuilder.dryRun(false).build());
                if (this.checkSuccess(wetResponse, false)) {
                    this.releaseLog.logMessage("Promotion completed successfully!");
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            HttpEntity entity;
            if (dryResponse != null && (entity = dryResponse.getEntity()) != null) {
                EntityUtils.consume(entity);
            }
            if (wetResponse != null && (entity = wetResponse.getEntity()) != null) {
                EntityUtils.consume(entity);
            }
        }
    }

    private boolean checkSuccess(HttpResponse response, boolean dryRun) throws IOException {
        StatusLine status = response.getStatusLine();
        String content = this.entityToString(response);
        if (status.getStatusCode() != 200) {
            if (dryRun) {
                String message = "Promotion failed during dry run (no change in Artifactory was done): " + status + "<br/>" + content;
                this.releaseLog.logMessage(message);
            } else {
                String message = "Promotion failed. View Artifactory logs for more details: " + status + "<br/>" + content;
                this.releaseLog.logError(message);
            }
            return false;
        }
        JsonFactory factory = this.createJsonFactory();
        JsonParser parser = factory.createJsonParser(content);
        JsonNode root = parser.readValueAsTree();
        JsonNode messagesNode = root.get("messages");
        for (JsonNode node : messagesNode) {
            String level = node.get("level").getTextValue();
            String message = node.get("message").getTextValue();
            if (!"WARNING".equals(level) && !"ERROR".equals(level) || message.startsWith("No items were")) continue;
            String errorMessage = "Received " + level + ": " + message;
            this.releaseLog.logError(errorMessage);
            return false;
        }
        return true;
    }

    private JsonFactory createJsonFactory() {
        JsonFactory jsonFactory = new JsonFactory();
        ObjectMapper mapper = new ObjectMapper(jsonFactory);
        mapper.getSerializationConfig().setAnnotationIntrospector(new JacksonAnnotationIntrospector());
        mapper.getSerializationConfig().setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
        jsonFactory.setCodec(mapper);
        return jsonFactory;
    }

    private String entityToString(HttpResponse response) throws IOException {
        HttpEntity entity = response.getEntity();
        InputStream is = entity.getContent();
        return IOUtils.toString(is, "UTF-8");
    }
}

