/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.release.action;

import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.build.CustomBuildProcessor;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.credentials.CredentialsAccessor;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.CurrentBuildResult;
import com.atlassian.bamboo.variable.CustomVariableContext;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jfrog.bamboo.context.AbstractBuildContext;
import org.jfrog.bamboo.release.action.AbstractBuildAction;
import org.jfrog.bamboo.release.provider.AbstractReleaseProvider;
import org.jfrog.bamboo.release.provider.ReleaseProvider;
import org.jfrog.bamboo.util.TaskDefinitionHelper;

public class ArtifactoryPostBuildCompleteAction
extends AbstractBuildAction
implements CustomBuildProcessor {
    private static final Logger log = Logger.getLogger(ArtifactoryPostBuildCompleteAction.class);
    private BuildLoggerManager buildLoggerManager;
    private CustomVariableContext customVariableContext;
    private CredentialsAccessor credentialsAccessor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public BuildContext call() throws Exception {
        BuildLogger logger = this.buildLoggerManager.getLogger((ResultKey)this.buildContext.getPlanResultKey());
        this.setBuildLogger(logger);
        List taskDefinitions = this.buildContext.getBuildDefinition().getTaskDefinitions();
        TaskDefinition mavenOrGradleDefinition = TaskDefinitionHelper.findMavenOrGradleDefinition(taskDefinitions);
        if (mavenOrGradleDefinition == null) {
            log.debug("[RELEASE] Task definition is not Maven or Gradle");
            return this.buildContext;
        }
        Map configuration = mavenOrGradleDefinition.getConfiguration();
        BuildContext parentBuildContext = this.buildContext.getParentBuildContext();
        if (parentBuildContext == null) {
            log.debug("[RELEASE] No parent build context found, resuming normally");
            return this.buildContext;
        }
        Map customBuildData = parentBuildContext.getBuildResult().getCustomBuildData();
        configuration.putAll(customBuildData);
        AbstractBuildContext config = AbstractBuildContext.createContextFromMap(configuration);
        if (config == null || !config.releaseManagementContext.isActivateReleaseManagement()) {
            log.debug("[RELEASE] Release management is not active, resuming normally");
            return this.buildContext;
        }
        ReleaseProvider provider = AbstractReleaseProvider.createReleaseProvider(config, this.buildContext, logger, this.customVariableContext, this.credentialsAccessor);
        if (provider == null) {
            return this.buildContext;
        }
        provider.prepare();
        try {
            provider.reloadFromConfig(configuration);
            provider.afterReleaseVersionChange(Boolean.parseBoolean((String)customBuildData.get("modifiedFilesForReleaseVersion")));
            CurrentBuildResult result = this.buildContext.getBuildResult();
            if (BuildState.SUCCESS.equals((Object)result.getBuildState())) {
                this.log("Build completed successfully");
                provider.afterSuccessfulReleaseVersionBuild();
                provider.beforeDevelopmentVersionChange();
                boolean modified = provider.transformDescriptor(configuration, false);
                provider.afterDevelopmentVersionChange(modified);
            }
        }
        finally {
            provider.buildCompleted(this.buildContext);
        }
        return this.buildContext;
    }

    public void setBuildLoggerManager(BuildLoggerManager buildLoggerManager) {
        this.buildLoggerManager = buildLoggerManager;
    }

    public void setCustomVariableContext(CustomVariableContext customVariableContext) {
        this.customVariableContext = customVariableContext;
    }

    public void setCredentialsAccessor(CredentialsAccessor credentialsAccessor) {
        this.credentialsAccessor = credentialsAccessor;
    }
}

