/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.release.action;

import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.build.CustomPreBuildAction;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.credentials.CredentialsAccessor;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.variable.CustomVariableContext;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jfrog.bamboo.context.AbstractBuildContext;
import org.jfrog.bamboo.release.action.AbstractBuildAction;
import org.jfrog.bamboo.release.provider.AbstractReleaseProvider;
import org.jfrog.bamboo.release.provider.ReleaseProvider;
import org.jfrog.bamboo.util.TaskDefinitionHelper;

public class ArtifactoryPreBuildAction
extends AbstractBuildAction
implements CustomPreBuildAction {
    private static final Logger log = Logger.getLogger(ArtifactoryPreBuildAction.class);
    private BuildLoggerManager buildLoggerManager;
    private CustomVariableContext customVariableContext;
    private CredentialsAccessor credentialsAccessor;

    @NotNull
    public BuildContext call() throws Exception {
        BuildLogger logger = this.buildLoggerManager.getLogger((ResultKey)this.buildContext.getPlanResultKey());
        this.setBuildLogger(logger);
        List taskDefinitions = this.buildContext.getBuildDefinition().getTaskDefinitions();
        if (taskDefinitions.isEmpty()) {
            this.log("No task definitions found for this build");
            return this.buildContext;
        }
        TaskDefinition mavenOrGradleDefinition = TaskDefinitionHelper.findMavenOrGradleDefinition(taskDefinitions);
        if (mavenOrGradleDefinition == null) {
            log.debug("[RELEASE] Build is not a Maven or Gradle build");
            return this.buildContext;
        }
        Map configuration = mavenOrGradleDefinition.getConfiguration();
        BuildContext parentBuildContext = this.buildContext.getParentBuildContext();
        if (parentBuildContext == null) {
            log.debug("[RELEASE] Release management is not active, resuming normally");
            return this.buildContext;
        }
        Map customBuildData = parentBuildContext.getBuildResult().getCustomBuildData();
        configuration.putAll(customBuildData);
        AbstractBuildContext config = AbstractBuildContext.createContextFromMap(configuration);
        if (config == null || !config.releaseManagementContext.isActivateReleaseManagement() || !config.releaseManagementContext.isReleaseMgmtEnabled()) {
            log.debug("[RELEASE] Release management is not active, resuming normally");
            return this.buildContext;
        }
        ReleaseProvider provider = AbstractReleaseProvider.createReleaseProvider(config, this.buildContext, logger, this.customVariableContext, this.credentialsAccessor);
        if (provider == null) {
            String message = "Release Provider could not be built";
            log.error(logger.addBuildLogEntry(message));
            this.buildContext.getBuildResult().addBuildErrors(Arrays.asList(message));
            return this.buildContext;
        }
        log.info(logger.addBuildLogEntry("[RELEASE] Release Build Active"));
        provider.prepare();
        provider.beforeReleaseVersionChange();
        boolean modified = provider.transformDescriptor(configuration, true);
        customBuildData.put("modifiedFilesForReleaseVersion", String.valueOf(modified));
        customBuildData.put("currentCheckoutBranch", provider.getCurrentCheckoutBranch());
        customBuildData.put("currentWorkingBranch", provider.getCurrentWorkingBranch());
        customBuildData.put("baseCommitIsh", provider.getBaseCommitIsh());
        customBuildData.put("releaseBranchCreated", String.valueOf(provider.isReleaseBranchCreated()));
        customBuildData.put("currentChangeListId", String.valueOf(provider.getCurrentChangeListId()));
        return this.buildContext;
    }

    public void setBuildLoggerManager(BuildLoggerManager buildLoggerManager) {
        this.buildLoggerManager = buildLoggerManager;
    }

    public void setCustomVariableContext(CustomVariableContext customVariableContext) {
        this.customVariableContext = customVariableContext;
    }

    public void setCredentialsAccessor(CredentialsAccessor credentialsAccessor) {
        this.credentialsAccessor = credentialsAccessor;
    }
}

