/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.release.action;

import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.build.ViewBuildResults;
import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plugin.RemoteAgentSupported;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.atlassian.bamboo.v2.build.trigger.ManualBuildTriggerReason;
import com.atlassian.bamboo.v2.build.trigger.TriggerReason;
import com.atlassian.bamboo.variable.VariableDefinitionManager;
import com.atlassian.user.User;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.opensymphony.xwork.ActionContext;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.acegisecurity.acls.Permission;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.dispatcher.HttpParameters;
import org.apache.struts2.dispatcher.Parameter;
import org.jfrog.bamboo.admin.ServerConfig;
import org.jfrog.bamboo.admin.ServerConfigManager;
import org.jfrog.bamboo.context.AbstractBuildContext;
import org.jfrog.bamboo.promotion.PromotionContext;
import org.jfrog.bamboo.promotion.PromotionThread;
import org.jfrog.bamboo.release.action.MavenSyncUtils;
import org.jfrog.bamboo.release.action.ModuleVersionHolder;
import org.jfrog.bamboo.release.vcs.VcsTypes;
import org.jfrog.bamboo.util.TaskDefinitionHelper;
import org.jfrog.bamboo.util.TaskUtils;
import org.jfrog.bamboo.util.version.VersionHelper;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryBuildInfoClient;

@RemoteAgentSupported
public class ReleasePromotionAction
extends ViewBuildResults {
    public static final String PROMOTION_PUSH_TO_NEXUS_MODE = "pushToNexusMode";
    public static final String NEXUS_PUSH_PLUGIN_NAME = "bintrayOsoPush";
    public static final String NEXT_INTEG_KEY = "version.nextIntegValue";
    public static final String RELEASE_VALUE_KEY = "version.releaseValue";
    public static final String CURRENT_VALUE_KEY = "version.currentValue";
    public static final String RELEASE_PROP_KEY = "version.releaseProp";
    public static final String MODULE_KEY = "version.key";
    private static final Logger log = Logger.getLogger(ReleasePromotionAction.class);
    private static final String PROMOTION_NORMAL_MODE = "normalMode";
    private static final Map<String, String> MODULE_VERSION_TYPES = ImmutableMap.of("oneVersionAllModules", "One version for all modules.", "versionPerModule", "Version per module", "useExistingVersion", "Use existing module versions");
    public static PromotionContext promotionContext = new PromotionContext();
    ServerConfigManager serverConfigManager = ServerConfigManager.getInstance();
    private String promotionMode = "normalMode";
    private boolean promoting = true;
    private String promotionRepo = "";
    private VariableDefinitionManager variableDefinitionManager;
    private String comment = "";
    private String target = "";
    private boolean useCopy;
    private boolean includeDependencies;
    private String artifactoryReleaseManagementUrl = "";
    private String moduleVersionConfiguration = "oneVersionAllModules";
    private boolean createVcsTag = true;
    private String tagUrl;
    private String tagComment;
    private String nextDevelopmentComment = "[artifactory-release] Next development version";
    private String releasePublishingRepo;
    private String stagingComment = "";
    private boolean useReleaseBranch = true;
    private CapabilityContext capabilityContext;
    private String releaseBranch;
    private List<ModuleVersionHolder> versions;

    public String execute() throws Exception {
        String superResult = super.execute();
        if ("error".equals(superResult)) {
            return "error";
        }
        BuildResultsSummary summary = this.getBuildResultsSummary();
        if (summary == null) {
            log.error("This build has no results summary");
            return "error";
        }
        return "input";
    }

    public List<ModuleVersionHolder> getVersions() throws RepositoryException, IOException {
        VersionHelper versionHelper;
        AbstractBuildContext context;
        TaskDefinition definition;
        if (this.versions == null && (definition = this.getReleaseTaskDefinition()) != null && (context = AbstractBuildContext.createContextFromMap(definition.getConfiguration())) != null && (versionHelper = VersionHelper.getHelperAccordingToType(context, this.getCapabilityContext())) != null) {
            int latestBuildNumberWithBuildInfo = this.findLatestBuildNumberWithBuildInfo();
            this.setVersions(versionHelper.filterPropertiesForRelease(this.getMutablePlan(), latestBuildNumberWithBuildInfo));
        }
        return this.versions;
    }

    public void setVersions(List<ModuleVersionHolder> versions) {
        this.versions = versions;
    }

    private int findLatestBuildNumberWithBuildInfo() {
        List summaries = this.resultsSummaryManager.getResultSummariesForPlan((ImmutablePlan)this.getMutablePlan(), 0, 100);
        Collections.sort(summaries, new Comparator<ResultsSummary>(){

            @Override
            public int compare(ResultsSummary o1, ResultsSummary o2) {
                if (o1.getBuildNumber() > o2.getBuildNumber()) {
                    return -1;
                }
                if (o2.getBuildNumber() < o2.getBuildNumber()) {
                    return 1;
                }
                return 0;
            }
        });
        for (ResultsSummary summary : summaries) {
            boolean biActive;
            if (!summary.getBuildState().equals((Object)BuildState.SUCCESS) || !(biActive = Boolean.parseBoolean((String)summary.getCustomBuildData().get("org.jfrog.bamboo.buildInfo.activated")))) continue;
            return summary.getBuildNumber();
        }
        return -1;
    }

    public boolean isGradle() {
        TaskDefinition taskDefinition = this.getReleaseTaskDefinition();
        if (taskDefinition == null) {
            return false;
        }
        return StringUtils.endsWith(taskDefinition.getPluginKey(), "artifactoryGradleTask");
    }

    public boolean isMaven() {
        TaskDefinition taskDefinition = this.getReleaseTaskDefinition();
        if (taskDefinition == null) {
            return false;
        }
        return StringUtils.endsWith(taskDefinition.getPluginKey(), "maven3Task");
    }

    public boolean isGit() {
        TaskDefinition taskDefinition = this.getReleaseTaskDefinition();
        if (taskDefinition == null) {
            return false;
        }
        return VcsTypes.GIT.name().equals(taskDefinition.getConfiguration().get("artifactory.vcs.type"));
    }

    public boolean isReleaseConfigured() {
        TaskDefinition taskDefinition = this.getReleaseTaskDefinition();
        if (taskDefinition == null) {
            return false;
        }
        return StringUtils.isNotBlank((String)taskDefinition.getConfiguration().get("artifactory.vcs.type"));
    }

    public Map<String, String> getModuleVersionTypes() {
        return MODULE_VERSION_TYPES;
    }

    public String doReleaseBuild() throws RepositoryException, IOException {
        List taskDefinitions = this.getMutablePlan().getBuildDefinition().getTaskDefinitions();
        if (taskDefinitions.isEmpty()) {
            log.warn("No task definitions defined, cannot execute release build");
            return "error";
        }
        User user = this.getUser();
        PlanKey planKey = this.getMutablePlan().getPlanKey();
        if (user == null || planKey == null) {
            return "error";
        }
        this.setBuildKey(planKey.getKey());
        HashMap<String, String> configuration = Maps.newHashMap();
        HttpParameters parameters = ActionContext.getContext().getParameters();
        configuration.put("activateReleaseManagement", String.valueOf(true));
        configuration.put("tagUrl", this.getTagUrl());
        configuration.put("nextDevelopmentComment", this.getNextDevelopmentComment());
        configuration.put("stagingComment", this.getStagingComment());
        configuration.put("release.management.repoKey", this.getReleasePublishingRepo());
        configuration.put("tagComment", this.getTagComment());
        configuration.put("releaseBranch", this.getReleaseBranch());
        Parameter useReleaseBranchParam = (Parameter)parameters.get("useReleaseBranch");
        boolean useReleaseBranch = useReleaseBranchParam != null && Boolean.parseBoolean(useReleaseBranchParam.getValue());
        configuration.put("useReleaseBranch", String.valueOf(useReleaseBranch));
        Parameter createVcsTagParam = (Parameter)parameters.get("createVcsTag");
        boolean createVcsTag = createVcsTagParam != null && Boolean.parseBoolean(createVcsTagParam.getValue());
        configuration.put("createVcsTag", String.valueOf(createVcsTag));
        configuration.put("moduleVersionConfiguration", this.getModuleVersionConfiguration());
        TaskDefinition definition = TaskDefinitionHelper.findMavenOrGradleDefinition(taskDefinitions);
        if (definition == null) {
            log.error("No Maven or Gradle task found in job");
            return "error";
        }
        AbstractBuildContext context = AbstractBuildContext.createContextFromMap(definition.getConfiguration());
        VersionHelper helper = VersionHelper.getHelperAccordingToType(context, this.getCapabilityContext());
        helper.addVersionFieldsToConfiguration((Map)parameters, configuration, this.getModuleVersionConfiguration(), definition.getConfiguration());
        this.planExecutionManager.startManualExecution((ImmutableChain)this.getPlanJob().getParent(), user, configuration, Maps.newHashMap());
        return "success";
    }

    public String getSelectedServerId() {
        TaskDefinition definition = this.getReleaseTaskDefinition();
        if (definition == null) {
            return "";
        }
        Map configuration = definition.getConfiguration();
        Map filtered = Maps.filterKeys(configuration, new Predicate<String>(){

            @Override
            public boolean apply(String input) {
                return StringUtils.endsWith(input, "artifactoryServerId");
            }
        });
        return (String)filtered.values().iterator().next();
    }

    private Job getPlanJob() {
        return (Job)this.getMutablePlan();
    }

    public String getModuleVersionConfiguration() {
        return this.moduleVersionConfiguration;
    }

    public void setModuleVersionConfiguration(String moduleVersionConfiguration) {
        this.moduleVersionConfiguration = moduleVersionConfiguration;
    }

    public boolean isCreateVcsTag() {
        return this.createVcsTag;
    }

    public void setCreateVcsTag(boolean createVcsTag) {
        this.createVcsTag = createVcsTag;
    }

    public String getTagUrl() throws RepositoryException, IOException {
        if (this.tagUrl != null) {
            return this.tagUrl;
        }
        String url = this.getDefaultTagUrl();
        List<ModuleVersionHolder> moduleVersionHolders = this.getVersions();
        if (moduleVersionHolders.isEmpty()) {
            return url;
        }
        url = url + moduleVersionHolders.get(0).getReleaseValue();
        return url;
    }

    public void setTagUrl(String tagUrl) {
        this.tagUrl = tagUrl;
    }

    public String getTagComment() throws RepositoryException, IOException {
        if (this.tagComment == null) {
            List<ModuleVersionHolder> versions1 = this.getVersions();
            String releaseValue = !versions1.isEmpty() ? versions1.get(0).getReleaseValue() : "1.0.0";
            return "[artifactory-release] Release version " + releaseValue;
        }
        return this.tagComment;
    }

    public void setTagComment(String tagComment) {
        this.tagComment = tagComment;
    }

    public String getNextDevelopmentComment() {
        return this.nextDevelopmentComment != null ? this.nextDevelopmentComment : "";
    }

    public void setNextDevelopmentComment(String nextDevelopmentComment) {
        this.nextDevelopmentComment = nextDevelopmentComment;
    }

    public List<String> getPublishingRepos() {
        String serverId = this.getSelectedServerId();
        if (StringUtils.isBlank(serverId)) {
            return Lists.newArrayList();
        }
        ServerConfigManager component = ServerConfigManager.getInstance();
        return component.getDeployableRepos(Long.parseLong(serverId));
    }

    public String getReleasePublishingRepo() {
        if (StringUtils.isBlank(this.releasePublishingRepo)) {
            TaskDefinition definition = this.getReleaseTaskDefinition();
            if (definition == null) {
                return "";
            }
            Map configuration = definition.getConfiguration();
            Map filtered = Maps.filterKeys(configuration, new Predicate<String>(){

                @Override
                public boolean apply(String input) {
                    return StringUtils.endsWith(input, "publishingRepo") || StringUtils.endsWith(input, "deployableRepo");
                }
            });
            return (String)filtered.values().iterator().next();
        }
        return this.releasePublishingRepo;
    }

    public void setReleasePublishingRepo(String releasePublishingRepo) {
        this.releasePublishingRepo = releasePublishingRepo;
    }

    private String getDefaultTagUrl() {
        TaskDefinition definition = this.getReleaseTaskDefinition();
        if (definition == null) {
            return "";
        }
        AbstractBuildContext context = AbstractBuildContext.createContextFromMap(definition.getConfiguration());
        if (context == null) {
            return "";
        }
        return StringUtils.trimToEmpty(context.releaseManagementContext.getVcsTagBase());
    }

    public boolean isUseReleaseBranch() {
        return this.useReleaseBranch;
    }

    public void setUseReleaseBranch(boolean useReleaseBranch) {
        this.useReleaseBranch = useReleaseBranch;
    }

    public String getReleaseBranch() throws RepositoryException, IOException {
        if (this.releaseBranch == null) {
            TaskDefinition definition = this.getReleaseTaskDefinition();
            if (definition == null) {
                return "";
            }
            Map configuration = definition.getConfiguration();
            AbstractBuildContext context = AbstractBuildContext.createContextFromMap(configuration);
            String url = context.releaseManagementContext.getGitReleaseBranch();
            List<ModuleVersionHolder> moduleVersionHolders = this.getVersions();
            if (moduleVersionHolders.isEmpty()) {
                return url;
            }
            return url + moduleVersionHolders.get(0).getReleaseValue();
        }
        return this.releaseBranch;
    }

    public void setReleaseBranch(String releaseBranch) {
        this.releaseBranch = releaseBranch;
    }

    public String getStagingComment() {
        return this.stagingComment;
    }

    public void setStagingComment(String stagingComment) {
        this.stagingComment = stagingComment;
    }

    public CapabilityContext getCapabilityContext() {
        return this.capabilityContext;
    }

    public void setCapabilityContext(CapabilityContext capabilityContext) {
        this.capabilityContext = capabilityContext;
    }

    public String getReleaseValue() throws RepositoryException, IOException {
        List<ModuleVersionHolder> versions = this.getVersions();
        if (versions == null || versions.isEmpty()) {
            return "";
        }
        return versions.get(0).getReleaseValue();
    }

    public String getNextIntegValue() throws RepositoryException, IOException {
        List<ModuleVersionHolder> versions = this.getVersions();
        if (versions == null || versions.isEmpty()) {
            return "";
        }
        return versions.get(0).getNextIntegValue();
    }

    public boolean isReleaseBuild() {
        Plan plan = this.getMutablePlan();
        TaskDefinition mavenOrGradleDefinition = TaskDefinitionHelper.findMavenOrGradleDefinition(plan.getBuildDefinition().getTaskDefinitions());
        if (mavenOrGradleDefinition == null) {
            return false;
        }
        ResultsSummary summary = this.getResultsSummary();
        return summary != null && this.shouldShow(summary.getCustomBuildData());
    }

    private boolean shouldShow(Map<String, String> customData) {
        return customData.containsKey("org.jfrog.bamboo.buildInfo.activated") && Boolean.valueOf(customData.get("org.jfrog.bamboo.buildInfo.activated")) != false && customData.containsKey("org.jfrog.bamboo.release.activated") && Boolean.valueOf(customData.get("org.jfrog.bamboo.release.activated")) != false;
    }

    public boolean isPermittedToPromote() {
        return this.bambooPermissionManager.hasPlanPermission((Permission)BambooPermission.BUILD, PlanKeys.getPlanKey((String)this.getPlanKey()));
    }

    private TaskDefinition getReleaseTaskDefinition() {
        Job job = this.getPlanJob();
        if (job == null) {
            return null;
        }
        List taskDefinitions = job.getBuildDefinition().getTaskDefinitions();
        return TaskDefinitionHelper.findReleaseTaskDefinition(taskDefinitions);
    }

    public String doPromote() throws IOException {
        Integer number;
        String key = promotionContext.getBuildKey();
        if (StringUtils.isNotBlank(key) && StringUtils.isBlank(this.getBuildKey())) {
            this.setBuildKey(key);
        }
        if ((number = promotionContext.getBuildNumber()) != null && this.getBuildNumber() == null) {
            this.setBuildNumber(number);
        }
        if (this.getMutablePlan() == null) {
            return "input";
        }
        if (!this.isPermittedToPromote()) {
            log.error("You are not permitted to execute build promotion.");
            return "error";
        }
        ServerConfigManager component = ServerConfigManager.getInstance();
        TaskDefinition definition = TaskUtils.getMavenOrGradleTaskDefinition((ImmutablePlan)this.getMutablePlan());
        if (definition == null) {
            return "error";
        }
        String serverId = this.getSelectedServerId(definition);
        if (StringUtils.isBlank(serverId)) {
            log.error("No selected Artifactory server Id");
            return "error";
        }
        ServerConfig serverConfig = component.getServerConfigById(Long.parseLong(serverId));
        if (serverConfig == null) {
            log.error("Error while retrieving target repository list: Could not find Artifactory server configuration by the ID " + serverId);
            return "error";
        }
        Map taskConfiguration = definition.getConfiguration();
        AbstractBuildContext context = AbstractBuildContext.createContextFromMap(taskConfiguration);
        ArtifactoryBuildInfoClient client = TaskUtils.createClient(this.serverConfigManager, serverConfig, context, log);
        ResultsSummary summary = this.getResultsSummary();
        TriggerReason reason = summary.getTriggerReason();
        String username = "";
        if (reason instanceof ManualBuildTriggerReason) {
            username = ((ManualBuildTriggerReason)reason).getUserName();
        }
        new PromotionThread(this, client, username).start();
        this.promoting = false;
        return "success";
    }

    public List<String> getResult() {
        return promotionContext.getLog();
    }

    public boolean isDone() {
        return promotionContext.isDone();
    }

    public String getPromotionMode() {
        return this.promotionMode;
    }

    public void setPromotionMode(String promotionMode) {
        this.promotionMode = promotionMode;
    }

    public Map<String, String> getSupportedPromotionModes() {
        HashMap<String, String> promotionModes = Maps.newHashMap();
        promotionModes.put(PROMOTION_NORMAL_MODE, "Normal");
        TaskDefinition definition = TaskUtils.getMavenOrGradleTaskDefinition((ImmutablePlan)this.getMutablePlan());
        if (MavenSyncUtils.isPushToNexusEnabled(this.serverConfigManager, definition, this.getSelectedServerId(definition))) {
            promotionModes.put(PROMOTION_PUSH_TO_NEXUS_MODE, "Promote to Bintray and Central");
        }
        return promotionModes;
    }

    public List<String> getPromotionTargets() {
        return Lists.newArrayList("Released", "Rolled-back");
    }

    public List<String> getPromotionRepos() {
        TaskDefinition definition = TaskUtils.getMavenOrGradleTaskDefinition((ImmutablePlan)this.getMutablePlan());
        if (definition == null) {
            return Lists.newArrayList();
        }
        String selectedServerId = this.getSelectedServerId(definition);
        if (StringUtils.isBlank(selectedServerId)) {
            log.warn("No Artifactory server Id found");
            return Lists.newArrayList();
        }
        ServerConfigManager component = ServerConfigManager.getInstance();
        return component.getDeployableRepos(Long.parseLong(selectedServerId));
    }

    public String getSelectedServerId(TaskDefinition definition) {
        if (definition == null) {
            return "";
        }
        Map configuration = definition.getConfiguration();
        Map filtered = Maps.filterKeys(configuration, new Predicate<String>(){

            @Override
            public boolean apply(String input) {
                return StringUtils.endsWith(input, "artifactoryServerId");
            }
        });
        return (String)filtered.values().iterator().next();
    }

    public String getPromotionRepo() {
        return this.promotionRepo;
    }

    public void setPromotionRepo(String promotionRepo) {
        this.promotionRepo = promotionRepo;
    }

    public boolean isPromoting() {
        return this.promoting;
    }

    public void setPromoting(boolean promoting) {
        this.promoting = promoting;
    }

    public VariableDefinitionManager getVariableDefinitionManager() {
        return this.variableDefinitionManager;
    }

    public void setVariableDefinitionManager(VariableDefinitionManager variableDefinitionManager) {
        this.variableDefinitionManager = variableDefinitionManager;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean isUseCopy() {
        return this.useCopy;
    }

    public void setUseCopy(boolean useCopy) {
        this.useCopy = useCopy;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public boolean isIncludeDependencies() {
        return this.includeDependencies;
    }

    public void setIncludeDependencies(boolean includeDependencies) {
        this.includeDependencies = includeDependencies;
    }

    public String getArtifactoryReleaseManagementUrl() {
        return this.artifactoryReleaseManagementUrl;
    }

    public void setArtifactoryReleaseManagementUrl(String artifactoryReleaseManagementUrl) {
        this.artifactoryReleaseManagementUrl = artifactoryReleaseManagementUrl;
    }

    public String doGetLog() {
        return "success";
    }
}

