/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.release.action.condition;

import com.atlassian.bamboo.build.DefaultJob;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plugins.web.conditions.AbstractPlanPermissionCondition;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.task.TaskDefinition;
import java.util.List;
import java.util.Map;
import org.acegisecurity.acls.Permission;
import org.jfrog.bamboo.context.AbstractBuildContext;

public class ReleasePromotionActionCondition
extends AbstractPlanPermissionCondition {
    private PlanManager planManager;

    public boolean shouldDisplay(Map<String, Object> context) {
        String planKey = (String)context.get("planKey");
        if (planKey == null) {
            return false;
        }
        PlanKey plan = PlanKeys.getPlanKey((String)planKey);
        if (!this.bambooPermissionManager.hasPlanPermission((Permission)BambooPermission.BUILD, plan)) {
            return false;
        }
        DefaultJob job = (DefaultJob)this.planManager.getPlanByKey(plan);
        if (job == null) {
            return false;
        }
        List taskDefs = job.getBuildDefinition().getTaskDefinitions();
        for (TaskDefinition taskDef : taskDefs) {
            AbstractBuildContext buildContext;
            if (!taskDef.isEnabled() || (buildContext = AbstractBuildContext.createContextFromMap(taskDef.getConfiguration())) == null || !buildContext.releaseManagementContext.isReleaseMgmtEnabled()) continue;
            return true;
        }
        return false;
    }

    public void setPlanManager(PlanManager planManager) {
        this.planManager = planManager;
    }
}

