/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.release.provider;

import com.atlassian.bamboo.build.BuildDefinition;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.credentials.CredentialsAccessor;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.CurrentBuildResult;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.jfrog.bamboo.context.AbstractBuildContext;
import org.jfrog.bamboo.context.GradleBuildContext;
import org.jfrog.bamboo.context.Maven3BuildContext;
import org.jfrog.bamboo.release.action.ModuleVersionHolder;
import org.jfrog.bamboo.release.provider.GradleReleaseProvider;
import org.jfrog.bamboo.release.provider.MavenReleaseProvider;
import org.jfrog.bamboo.release.provider.ReleaseProvider;
import org.jfrog.bamboo.release.vcs.AbstractVcsCoordinator;
import org.jfrog.bamboo.release.vcs.VcsCoordinator;
import org.jfrog.bamboo.util.version.VcsHelper;

public abstract class AbstractReleaseProvider
implements ReleaseProvider {
    private static final Logger log = Logger.getLogger(AbstractReleaseProvider.class);
    private boolean isReleaseEnabled;
    protected VcsCoordinator coordinator;
    protected final AbstractBuildContext buildContext;
    protected final BuildLogger buildLogger;
    protected final BuildContext context;

    protected AbstractReleaseProvider(AbstractBuildContext buildContext, BuildContext context, BuildLogger buildLogger, CustomVariableContext customVariableContext, CredentialsAccessor credentialsAccessor) {
        this.context = context;
        this.buildContext = buildContext;
        this.buildLogger = buildLogger;
        this.isReleaseEnabled = buildContext.releaseManagementContext.isReleaseMgmtEnabled();
        this.coordinator = AbstractVcsCoordinator.createVcsCoordinator(context, this.getTaskConfiguration(context.getBuildDefinition()), buildLogger, customVariableContext, credentialsAccessor);
    }

    protected abstract Map<? extends String, ? extends String> getTaskConfiguration(BuildDefinition var1);

    public static ReleaseProvider createReleaseProvider(AbstractBuildContext buildContext, BuildContext context, BuildLogger buildLogger, CustomVariableContext customVariableContext, CredentialsAccessor credentialsAccessor) {
        if (buildContext instanceof GradleBuildContext) {
            return new GradleReleaseProvider(buildContext, context, buildLogger, customVariableContext, credentialsAccessor);
        }
        if (buildContext instanceof Maven3BuildContext) {
            return new MavenReleaseProvider(buildContext, context, buildLogger, customVariableContext, credentialsAccessor);
        }
        return null;
    }

    @Override
    public void prepare() throws IOException {
        if (this.isReleaseEnabled) {
            try {
                this.coordinator.prepare();
            }
            catch (Exception e) {
                this.failBuild(e);
                throw new IOException(e);
            }
        }
    }

    @Override
    public void afterDevelopmentVersionChange(boolean modified) throws IOException {
        try {
            this.coordinator.afterDevelopmentVersionChange(modified);
        }
        catch (Exception e) {
            this.failBuild(e);
            throw new IOException(e);
        }
    }

    @Override
    public void beforeReleaseVersionChange() throws IOException, InterruptedException {
        try {
            this.coordinator.beforeReleaseVersionChange();
        }
        catch (Exception e) {
            this.failBuild(e);
            throw new IOException(e);
        }
    }

    @Override
    public void afterReleaseVersionChange(boolean modified) throws IOException {
        try {
            this.coordinator.afterReleaseVersionChange(modified);
        }
        catch (Exception e) {
            this.failBuild(e);
            throw new IOException(e);
        }
    }

    @Override
    public void afterSuccessfulReleaseVersionBuild() throws IOException {
        try {
            this.coordinator.afterSuccessfulReleaseVersionBuild();
        }
        catch (Exception e) {
            this.failBuild(e);
            throw new IOException(e);
        }
    }

    @Override
    public void beforeDevelopmentVersionChange() throws IOException {
        try {
            this.coordinator.beforeDevelopmentVersionChange();
        }
        catch (Exception e) {
            this.failBuild(e);
            throw new IOException(e);
        }
    }

    @Override
    public void buildCompleted(BuildContext buildContext) throws IOException {
        try {
            this.coordinator.buildCompleted(buildContext);
        }
        catch (Exception e) {
            this.failBuild(e);
            throw new IOException(e);
        }
    }

    private void failBuild(Exception e) {
        CurrentBuildResult result = this.context.getBuildResult();
        result.addBuildErrors(Arrays.asList(e.getMessage()));
        result.setBuildState(BuildState.FAILED);
    }

    @Override
    public String getCurrentCheckoutBranch() {
        return this.coordinator.getCheckoutBranch();
    }

    @Override
    public void setCurrentCheckoutBranch(String checkoutBranch) {
        this.coordinator.setCheckoutBranch(checkoutBranch);
    }

    @Override
    public String getCurrentWorkingBranch() {
        return this.coordinator.getCurrentWorkingBranch();
    }

    @Override
    public void setCurrentWorkingBranch(String currentWorkingBranch) {
        this.coordinator.setCurrentWorkingBranch(currentWorkingBranch);
    }

    @Override
    public void setBaseCommitIsh(String commitIsh) {
        this.coordinator.setCommitIsh(commitIsh);
    }

    @Override
    public String getBaseCommitIsh() {
        return this.coordinator.getCommitIsh();
    }

    @Override
    public void setReleaseBranchCreated(boolean releaseBranchCreated) {
        this.coordinator.setReleaseBranchCreated(releaseBranchCreated);
    }

    @Override
    public boolean isReleaseBranchCreated() {
        return this.coordinator.isReleaseBranchCreated();
    }

    protected Map<String, String> buildMapAccordingToStatus(Map<String, String> conf, boolean release) {
        List<ModuleVersionHolder> holders = ModuleVersionHolder.buildFromConf(conf);
        HashMap<String, String> result = Maps.newHashMap();
        for (ModuleVersionHolder holder : holders) {
            String value = release ? holder.getReleaseValue() : holder.getNextIntegValue();
            result.put(holder.getKey(), value);
        }
        return result;
    }

    @Nullable
    protected File getSourceDir() throws RepositoryException {
        return VcsHelper.getCheckoutDirectory(this.context);
    }

    protected void log(String message) {
        log.info(this.buildLogger.addBuildLogEntry("[RELEASE] " + message));
    }

    @Override
    public int getCurrentChangeListId() {
        return this.coordinator.getCurrentChangeListId();
    }

    @Override
    public void setCurrentChangeListId(int changeListId) {
        this.coordinator.setCurrentChangeListId(changeListId);
    }

    @Override
    public void reloadFromConfig(Map<String, String> configuration) {
        String checkoutBranch = configuration.get("currentCheckoutBranch");
        this.setCurrentCheckoutBranch(checkoutBranch);
        String workingBranch = configuration.get("currentWorkingBranch");
        this.setCurrentWorkingBranch(workingBranch);
        String baseCommitIsh = configuration.get("baseCommitIsh");
        this.setBaseCommitIsh(baseCommitIsh);
        String releaseBranchCreated = configuration.get("releaseBranchCreated");
        this.setReleaseBranchCreated(Boolean.parseBoolean(releaseBranchCreated));
        String currentChangeListId = configuration.get("currentChangeListId");
        if (StringUtils.isNotBlank(currentChangeListId)) {
            this.setCurrentChangeListId(Integer.parseInt(currentChangeListId));
        }
    }
}

