/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.release.vcs;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.v2.build.BuildContext;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.jfrog.bamboo.release.vcs.VcsManager;
import org.jfrog.bamboo.util.version.VcsHelper;

public abstract class AbstractVcsManager
implements VcsManager {
    private static final Logger log = Logger.getLogger(AbstractVcsManager.class);
    private BuildContext context;
    private final BuildLogger buildLogger;

    public AbstractVcsManager(BuildContext context, BuildLogger buildLogger) {
        this.context = context;
        this.buildLogger = buildLogger;
    }

    @Nullable
    protected File getAndValidateCheckoutDirectory() {
        File checkoutDir = VcsHelper.getCheckoutDirectory(this.context);
        if (checkoutDir == null) {
            throw new IllegalStateException("Unable to resolve checkout directory.");
        }
        return checkoutDir;
    }

    protected void log(String message) {
        log.info(this.buildLogger.addBuildLogEntry("[RELEASE] " + message));
    }

    protected BuildContext getContext() {
        return this.context;
    }

    @Nullable
    protected Map<String, String> getTaskConfiguration() {
        List tasks = this.getContext().getBuildDefinition().getTaskDefinitions();
        for (int i = 0; i < tasks.size(); ++i) {
            if (tasks.get(i) == null || !((TaskDefinition)tasks.get(i)).getPluginKey().contains("bamboo-artifactory-plugin")) continue;
            return ((TaskDefinition)tasks.get(i)).getConfiguration();
        }
        return null;
    }
}

