/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.release.vcs.git;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import org.eclipse.jgit.api.errors.InvalidTagNameException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.revwalk.RevObject;

public class DeleteTagCommand
extends GitCommand<Object> {
    private RevObject id;
    private String name;
    private String message;
    private PersonIdent tagger;
    private boolean signed;
    private boolean forceUpdate;

    protected DeleteTagCommand(Repository repo) {
        super(repo);
    }

    @Override
    public RefUpdate.Result call() throws JGitInternalException, ConcurrentRefUpdateException, InvalidTagNameException, NoHeadException {
        this.checkCallable();
        RepositoryState state = this.repo.getRepositoryState();
        this.processOptions(state);
        Map<String, Ref> tags = this.repo.getTags();
        for (Map.Entry<String, Ref> entry : tags.entrySet()) {
            if (!entry.getKey().equals(this.getName())) continue;
            Ref value = entry.getValue();
            try {
                RefUpdate update = this.repo.updateRef(value.getName());
                update.setForceUpdate(true);
                RefUpdate.Result delete = update.delete();
                return delete;
            }
            catch (IOException e) {
                throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfTagCommand, e);
            }
        }
        throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfTagCommand);
    }

    private void processOptions(RepositoryState state) throws InvalidTagNameException {
        if (this.tagger == null) {
            this.tagger = new PersonIdent(this.repo);
        }
        if (this.name == null || !Repository.isValidRefName("refs/tags/" + this.name)) {
            throw new InvalidTagNameException(MessageFormat.format(JGitText.get().tagNameInvalid, this.name == null ? "<null>" : this.name));
        }
        if (this.signed) {
            throw new UnsupportedOperationException(JGitText.get().signingNotSupportedOnTag);
        }
    }

    public String getName() {
        return this.name;
    }

    public DeleteTagCommand setName(String name) {
        this.checkCallable();
        this.name = name;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public DeleteTagCommand setMessage(String message) {
        this.checkCallable();
        this.message = message;
        return this;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public DeleteTagCommand setSigned(boolean signed) {
        this.signed = signed;
        return this;
    }

    public PersonIdent getTagger() {
        return this.tagger;
    }

    public DeleteTagCommand setTagger(PersonIdent tagger) {
        this.tagger = tagger;
        return this;
    }

    public RevObject getObjectId() {
        return this.id;
    }

    public DeleteTagCommand setObjectId(RevObject id) {
        this.id = id;
        return this;
    }

    public boolean isForceUpdate() {
        return this.forceUpdate;
    }

    public DeleteTagCommand setForceUpdate(boolean forceUpdate) {
        this.forceUpdate = forceUpdate;
        return this;
    }
}

