/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.release.vcs.git;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.opensymphony.xwork.TextProvider;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.SshTransport;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.jgit.util.FS;
import org.jetbrains.annotations.Nullable;
import org.jfrog.bamboo.release.vcs.AbstractVcsManager;
import org.jfrog.bamboo.release.vcs.git.DeleteTagCommand;
import org.jfrog.bamboo.release.vcs.git.GitAuthenticationType;
import org.jfrog.bamboo.release.vcs.git.ResetCommand;
import org.jfrog.bamboo.release.vcs.git.SshPushCommand;

public class GitManager
extends AbstractVcsManager {
    private static final Logger log = Logger.getLogger(GitManager.class);
    private static final String REF_PREFIX = "refs/heads/";
    private static final String REFS_TAGS = "refs/tags/";
    private BuildLogger buildLogger;
    private TextProvider textProvider;
    private String username = "";
    private String password = "";
    private String url = "";
    private String sshKey = "";
    private String sshPassphrase = "";
    private String authenticationType = "";

    public GitManager(BuildContext context, BuildLogger buildLogger) {
        super(context, buildLogger);
        this.buildLogger = buildLogger;
        this.initVcsConfiguration();
    }

    private void initVcsConfiguration() {
        Map<String, String> confMap = this.getTaskConfiguration();
        if (confMap != null) {
            this.url = confMap.get("artifactory.vcs.git.url");
            this.authenticationType = confMap.get("artifactory.vcs.git.authenticationType");
            this.username = confMap.get("artifactory.vcs.git.username");
            this.password = confMap.get("artifactory.vcs.git.password");
            this.sshKey = confMap.get("artifactory.vcs.git.ssh.key");
            this.sshPassphrase = confMap.get("artifactory.vcs.git.ssh.passphrase");
        }
    }

    @Override
    public void commitWorkingCopy(String commitMessage) throws IOException, InterruptedException {
        try (Git git = this.createGitApi();){
            git.commit().setMessage(commitMessage).setAll(true).setCommitter(new PersonIdent(git.getRepository())).call();
        }
        catch (Exception e) {
            String message = "An error " + e.getMessage() + " occurred while committing the working copy";
            log.error("[RELEASE] " + message, e);
            this.buildLogger.addErrorLogEntry("[RELEASE] " + message, (Throwable)e);
            throw new IOException(message, e);
        }
    }

    @Override
    public void createTag(String tagUrl, String commitMessage) throws IOException, InterruptedException {
        try (Git git = this.createGitApi();){
            git.tag().setMessage(commitMessage).setName(tagUrl).call();
        }
        catch (Exception e) {
            String message = "An error " + e.getMessage() + " occurred while creating a tag " + tagUrl;
            log.error("[RELEASE] " + message, e);
            this.buildLogger.addErrorLogEntry("[RELEASE] " + message, (Throwable)e);
            throw new IOException("An error occurred while creating a tag", e);
        }
    }

    @Override
    public String getRemoteUrl() {
        return this.url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCurrentCommitHash() throws IOException {
        File workingDir = this.getGitDir();
        try (FileRepository localRepository = null;){
            localRepository = new FileRepository(workingDir);
            ObjectId objId = localRepository.resolve("HEAD");
            String string = objId != null ? objId.getName() : null;
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCurrentBranch() throws IOException {
        File workingDir = this.getGitDir();
        try (FileRepository localRepository = null;){
            localRepository = new FileRepository(workingDir);
            String string = localRepository.getBranch();
            return string;
        }
    }

    public void setBuildLogger(BuildLogger buildLogger) {
        this.buildLogger = buildLogger;
    }

    public void setTextProvider(TextProvider textProvider) {
        this.textProvider = textProvider;
    }

    public void checkoutBranch(String branch, boolean create) throws IOException {
        this.log("Checking out branch: " + branch);
        try (Git git = this.createGitApi();){
            git.checkout().setCreateBranch(create).setForce(create).setName(branch).call();
        }
        catch (Exception e) {
            String message = "An error '" + e.getMessage() + "' occurred while checking out branch: " + branch;
            log.error(message, e);
            this.buildLogger.addErrorLogEntry(message, (Throwable)e);
            throw new IOException(message, e);
        }
    }

    public void push(String url, String branch) throws IOException {
        try (Git git = this.createGitApi();){
            Object result;
            PushCommand pushCommand = this.buildPushCommand(git);
            pushCommand.setRefSpecs(new RefSpec(REF_PREFIX + branch)).setRemote(url);
            this.log("Pushing branch: " + branch + " to url: " + url);
            try {
                result = pushCommand.call();
            }
            catch (Exception ire) {
                String message = "An error '" + ire.getMessage() + "' occurred while pushing branch: " + branch + " to url: " + url;
                log.error("[RELEASE] " + message, ire);
                this.buildLogger.addErrorLogEntry("[RELEASE] " + message, (Throwable)ire);
                throw new IOException(message, ire);
            }
            Iterator iterator = result.iterator();
            while (iterator.hasNext()) {
                PushResult pushResult = (PushResult)iterator.next();
                if (!StringUtils.isNotBlank(pushResult.getMessages())) continue;
                this.log(pushResult.getMessages());
            }
        }
    }

    public void pushTag(String remoteUrl, String tagUrl) throws IOException {
        String escapedTagName = tagUrl.replace(' ', '_');
        try (Git git = this.createGitApi();){
            Object result;
            PushCommand pushCommand = this.buildPushCommand(git);
            pushCommand.setRefSpecs(new RefSpec(REFS_TAGS + escapedTagName)).setRemote(remoteUrl);
            this.log("Pushing tag: " + escapedTagName + " to url " + remoteUrl);
            try {
                result = pushCommand.call();
            }
            catch (Exception ire) {
                String message = "An error '" + ire.getMessage() + "' occurred while pushing tag: " + tagUrl + " to:" + remoteUrl;
                log.error("[RELEASE] " + message, ire);
                this.buildLogger.addErrorLogEntry("[RELEASE] " + message, (Throwable)ire);
                throw new IOException(message, ire);
            }
            Iterator iterator = result.iterator();
            while (iterator.hasNext()) {
                PushResult pushResult = (PushResult)iterator.next();
                if (!StringUtils.isNotBlank(pushResult.getMessages())) continue;
                this.log(pushResult.getMessages());
            }
        }
    }

    public void deleteLocalBranch(String branch) throws IOException {
        try (Git git = this.createGitApi();){
            this.log("Deleting local branch: " + branch);
            git.branchDelete().setBranchNames(branch).setForce(true).call();
        }
        catch (Exception e) {
            String message = "An error '" + e.getMessage() + "' occurred while deleting local branch: " + branch;
            log.error("[RELEASE] " + message, e);
            this.buildLogger.addErrorLogEntry("[RELEASE] " + message, (Throwable)e);
            throw new IOException(message, e);
        }
    }

    public void deleteRemoteBranch(String repository, String branch) throws IOException {
        try (Git git = this.createGitApi();){
            Object results;
            PushCommand pushCommand = this.buildPushCommand(git);
            pushCommand.setRefSpecs(new RefSpec(":refs/heads/" + branch)).setRemote(repository);
            this.log("Deleting remote branch: " + branch + " from " + repository);
            try {
                results = pushCommand.call();
            }
            catch (Exception e) {
                String message = "An error '" + e.getMessage() + "' occurred while deleting remote branch: " + branch + " from remote: " + repository;
                log.error("[RELEASE] " + message, e);
                this.buildLogger.addErrorLogEntry("[RELEASE] " + message, (Throwable)e);
                throw new IOException(message, e);
            }
            Iterator iterator = results.iterator();
            while (iterator.hasNext()) {
                PushResult result = (PushResult)iterator.next();
                if (!StringUtils.isNotBlank(result.getMessages())) continue;
                this.log(result.getMessages());
            }
        }
    }

    public void deleteLocalTag(String tag) throws IOException {
        try (Git git = this.createGitApi();){
            DeleteTagCommand deleteTagCommand = new DeleteTagCommand(git.getRepository());
            deleteTagCommand.setName(tag);
            this.log("Deleting local tag: " + tag);
            try {
                RefUpdate.Result result = deleteTagCommand.call();
                log.debug("Result of deletion of local tag: " + (Object)((Object)result));
            }
            catch (Exception e) {
                String message = "An error '" + e.getMessage() + "' occurred when deleting local tag: " + tag;
                log.error("[RELEASE] " + message, e);
                this.buildLogger.addErrorLogEntry("[RELEASE] " + message, (Throwable)e);
                throw new IOException(message, e);
            }
        }
    }

    public void revertWorkingCopy(String ish) throws GitAPIException, IOException {
        this.log("Reverting local copy to: " + ish);
        try (Git git = this.createGitApi();){
            Repository repository = git.getRepository();
            ResetCommand resetCommand = new ResetCommand(repository);
            resetCommand.setMode(ResetCommand.ResetType.HARD).setRef(ish).call();
        }
    }

    public void deleteRemoteTag(String repository, String tag) throws IOException {
        try (Git git = this.createGitApi();){
            Object results;
            PushCommand pushCommand = this.buildPushCommand(git);
            pushCommand.setRefSpecs(new RefSpec(":refs/tags/" + tag)).setRemote(repository);
            this.log("Deleting remote tag: " + tag + " from " + repository);
            try {
                results = pushCommand.call();
            }
            catch (Exception e) {
                String message = "An error '" + e.getMessage() + "' occurred when deleting remote tag: " + tag + " from remote: " + repository;
                log.error("[RELEASE] " + message, e);
                this.buildLogger.addErrorLogEntry("[RELEASE] " + message, (Throwable)e);
                throw new IOException(message, e);
            }
            Iterator iterator = results.iterator();
            while (iterator.hasNext()) {
                PushResult result = (PushResult)iterator.next();
                if (!StringUtils.isNotBlank(result.getMessages())) continue;
                this.log(result.getMessages());
            }
        }
    }

    private PushCommand buildPushCommand(Git git) throws IOException {
        PushCommand pushCommand;
        GitAuthenticationType authType = this.getAuthType();
        this.buildLogger.addBuildLogEntry("[RELEASE] Using SCM authentication type: " + (Object)((Object)authType));
        if (authType == GitAuthenticationType.PASSWORD || authType == GitAuthenticationType.NONE) {
            pushCommand = git.push();
            pushCommand.setForce(true);
            UsernamePasswordCredentialsProvider provider = new UsernamePasswordCredentialsProvider(this.username, this.password);
            pushCommand.setCredentialsProvider(provider);
        } else {
            Transport transport = this.createSshTransport();
            pushCommand = new SshPushCommand(git.getRepository(), transport);
        }
        return pushCommand;
    }

    private Git createGitApi() throws IOException {
        File workingDir = this.getGitDir();
        FileRepositoryBuilder builder = new FileRepositoryBuilder();
        builder.setGitDir(workingDir);
        return new Git(((FileRepositoryBuilder)builder.setup()).build());
    }

    private File getGitDir() {
        File gitDirectory = new File(this.getAndValidateCheckoutDirectory(), ".git");
        if (!gitDirectory.exists()) {
            throw new IllegalStateException("Git Dir: " + gitDirectory.getAbsolutePath() + " Does not exist");
        }
        return gitDirectory;
    }

    private Transport createSshTransport() throws IOException {
        String url = this.getRemoteUrl();
        try (Transport transport = null;
             Git git = this.createGitApi();){
            transport = Transport.open(git.getRepository(), url);
            if (transport instanceof SshTransport) {
                GitSshSessionFactory factory = new GitSshSessionFactory(this.sshKey, this.sshPassphrase);
                ((SshTransport)transport).setSshSessionFactory(factory);
            }
        }
        return transport;
    }

    private GitAuthenticationType getAuthType() {
        if (GitAuthenticationType.SSH_KEYPAIR.name().equals(this.authenticationType)) {
            return GitAuthenticationType.SSH_KEYPAIR;
        }
        if (GitAuthenticationType.PASSWORD.name().equals(this.authenticationType)) {
            return GitAuthenticationType.PASSWORD;
        }
        return GitAuthenticationType.NONE;
    }

    private static class GitSshSessionFactory
    extends JschConfigSessionFactory {
        private final String key;
        private final String passphrase;

        GitSshSessionFactory(@Nullable String key, @Nullable String passphrase) {
            this.key = key;
            this.passphrase = passphrase;
        }

        @Override
        protected void configure(OpenSshConfig.Host hc, Session session) {
            session.setConfig("StrictHostKeyChecking", "no");
        }

        @Override
        protected JSch getJSch(OpenSshConfig.Host hc, FS fs) throws JSchException {
            JSch jsch = super.getJSch(hc, fs);
            jsch.removeAllIdentity();
            if (StringUtils.isNotEmpty(this.key)) {
                jsch.addIdentity("identityName", this.key.getBytes(), null, this.passphrase.getBytes());
            }
            return jsch;
        }
    }
}

