/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.release.vcs.git;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

public class ResetCommand
extends GitCommand<Ref> {
    private String ref;
    private ResetType mode;

    public ResetCommand(Repository repo) {
        super(repo);
    }

    @Override
    public Ref call() throws GitAPIException {
        Ref r;
        this.checkCallable();
        try {
            RevCommit commit;
            ObjectId commitId;
            boolean merging = false;
            if (this.repo.getRepositoryState().equals((Object)RepositoryState.MERGING) || this.repo.getRepositoryState().equals((Object)RepositoryState.MERGING_RESOLVED)) {
                merging = true;
            }
            try {
                commitId = this.repo.resolve(this.ref);
            }
            catch (IOException e) {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().cannotRead, this.ref), e);
            }
            RevWalk rw = new RevWalk(this.repo);
            try {
                commit = rw.parseCommit(commitId);
            }
            catch (IOException e) {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().cannotReadCommit, commitId.toString()), e);
            }
            finally {
                rw.dispose();
            }
            RefUpdate ru = this.repo.updateRef("HEAD");
            ru.setNewObjectId(commitId);
            String refName = Repository.shortenRefName(this.ref);
            String message = "reset --" + this.mode.toString().toLowerCase() + " " + refName;
            ru.setRefLogMessage(message, false);
            if (ru.forceUpdate() == RefUpdate.Result.LOCK_FAILURE) {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().cannotLock, ru.getName()));
            }
            switch (this.mode) {
                case HARD: {
                    this.checkoutIndex(commit);
                    break;
                }
                case MIXED: {
                    this.resetIndex(commit);
                    break;
                }
            }
            if (this.mode != ResetType.SOFT && merging) {
                this.resetMerge();
            }
            this.setCallable(false);
            r = ru.getRef();
        }
        catch (IOException e) {
            throw new JGitInternalException("Error while executing reset command");
        }
        return r;
    }

    public ResetCommand setRef(String ref) {
        this.ref = ref;
        return this;
    }

    public ResetCommand setMode(ResetType mode) {
        this.mode = mode;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetIndex(RevCommit commit) throws IOException {
        DirCache dc = null;
        try {
            dc = this.repo.lockDirCache();
            dc.clear();
            DirCacheBuilder dcb = dc.builder();
            dcb.addTree(new byte[0], 0, this.repo.newObjectReader(), commit.getTree());
            dcb.commit();
        }
        finally {
            if (dc != null) {
                dc.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkoutIndex(RevCommit commit) throws IOException {
        DirCache dc = null;
        try {
            dc = this.repo.lockDirCache();
            DirCacheCheckout checkout = new DirCacheCheckout(this.repo, dc, commit.getTree());
            checkout.setFailOnConflict(false);
            checkout.checkout();
        }
        finally {
            if (dc != null) {
                dc.unlock();
            }
        }
    }

    private void resetMerge() throws IOException {
        this.repo.writeMergeHeads(null);
        this.repo.writeMergeCommitMsg(null);
    }

    public static enum ResetType {
        SOFT,
        MIXED,
        HARD;

    }
}

