/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.release.vcs.perforce;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.v2.build.BuildContext;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jfrog.bamboo.release.vcs.AbstractVcsManager;
import org.jfrog.build.vcs.perforce.PerforceClient;

public class PerforceManager
extends AbstractVcsManager {
    private PerforceClient perforce;
    private String port = "";
    private String client = "";
    private String username = "";
    private String password = "";

    public PerforceManager(BuildContext context, BuildLogger buildLogger) {
        super(context, buildLogger);
        Map<String, String> confMap = this.getTaskConfiguration();
        if (confMap != null) {
            this.port = confMap.get("artifactory.vcs.p4.port");
            this.client = confMap.get("artifactory.vcs.p4.client");
            this.username = confMap.get("artifactory.vcs.p4.username");
            this.password = confMap.get("artifactory.vcs.p4.password");
        }
    }

    public void prepare() throws IOException {
        String charset;
        PerforceClient.Builder builder = new PerforceClient.Builder();
        String hostAddress = this.port;
        if (!hostAddress.contains(":")) {
            hostAddress = "localhost:" + hostAddress;
        }
        builder.hostAddress(hostAddress).client(this.client);
        if (!StringUtils.isEmpty(this.username)) {
            builder.username(this.username).password(this.password);
        }
        if (!StringUtils.isBlank(charset = System.getenv("P4CHARSET"))) {
            builder.charset(charset);
        }
        this.perforce = builder.build();
    }

    public void commitWorkingCopy(int changeListId, String commitMessage) throws IOException {
        this.perforce.commitWorkingCopy(changeListId, commitMessage);
    }

    @Override
    public void commitWorkingCopy(String commitMessage) throws IOException, InterruptedException {
        throw new UnsupportedOperationException("Use the overloaded method");
    }

    public void createTag(String label, String commitMessage, String changeListId) throws IOException {
        this.perforce.createLabel(label, commitMessage, changeListId);
    }

    @Override
    public void createTag(String tagUrl, String commitMessage) throws IOException, InterruptedException {
        throw new UnsupportedOperationException("Use the overloaded method");
    }

    @Override
    public String getRemoteUrl() {
        throw new UnsupportedOperationException("Remote URL not supported");
    }

    public void revertWorkingCopy(int changeListId) throws IOException {
        this.perforce.revertWorkingCopy(changeListId);
    }

    public void deleteLabel(String tagUrl) throws IOException {
        this.perforce.deleteLabel(tagUrl);
    }

    public void edit(int changeListId, File releaseVersion) throws IOException {
        this.perforce.editFile(changeListId, releaseVersion);
    }

    public int createNewChangeList() throws IOException {
        return this.perforce.createNewChangeList();
    }

    public void deleteChangeList(int changeListId) throws IOException {
        this.perforce.deleteChangeList(changeListId);
    }

    public int getDefaultChangeListId() throws IOException {
        return this.perforce.getDefaultChangeListId();
    }

    public void closeConnection() throws IOException {
        this.perforce.closeConnection();
    }
}

