/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.security;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import javax.annotation.concurrent.ThreadSafe;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ThreadSafe
public class EncryptionHelper {
    private static final Logger log = Logger.getLogger(EncryptionHelper.class);
    private static String DESEDE_ENCRYPTION_SCHEME = "DESede";
    private static ThreadLocal<Cipher> threadLocalEncrypter = new ThreadLocal<Cipher>(){

        @Override
        protected Cipher initialValue() {
            try {
                return Cipher.getInstance(DESEDE_ENCRYPTION_SCHEME);
            }
            catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
                log.error("Cannot create encrypter", e);
                return null;
            }
        }
    };
    private static ThreadLocal<Cipher> threadLocalDecrypter = new ThreadLocal<Cipher>(){

        @Override
        protected Cipher initialValue() {
            try {
                return Cipher.getInstance(DESEDE_ENCRYPTION_SCHEME);
            }
            catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
                log.error("Cannot create decrypter", e);
                return null;
            }
        }
    };

    @NotNull
    public static String encrypt(@Nullable String stringToEncrypt) {
        if (StringUtils.isEmpty((CharSequence)stringToEncrypt)) {
            return "";
        }
        try {
            byte[] encrypted = EncryptionHelper.getEncrypter().doFinal(stringToEncrypt.getBytes(StandardCharsets.UTF_8));
            return Base64.getMimeEncoder().encodeToString(encrypted);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to encrypt.", e);
        }
    }

    @NotNull
    public static String decrypt(@Nullable String data) {
        if (StringUtils.isEmpty((CharSequence)data)) {
            return "";
        }
        try {
            byte[] encrypted = Base64.getMimeDecoder().decode(data);
            return new String(EncryptionHelper.getDecrypter().doFinal(encrypted), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to decrypt.", e);
        }
    }

    private static SecretKey generateSecret() throws InvalidKeySpecException, InvalidKeyException, NoSuchAlgorithmException {
        DESedeKeySpec myKeySpec = new DESedeKeySpec("Beetlejuice version $version (c) Copyright 2003-2005 Pols Consulting Limited".getBytes(StandardCharsets.UTF_8));
        SecretKeyFactory myKeyFactory = SecretKeyFactory.getInstance(DESEDE_ENCRYPTION_SCHEME);
        return myKeyFactory.generateSecret(myKeySpec);
    }

    private static Cipher getDecrypter() throws InvalidKeySpecException, InvalidKeyException, NoSuchAlgorithmException {
        SecretKey secretKey = EncryptionHelper.generateSecret();
        Cipher decrypter = threadLocalDecrypter.get();
        decrypter.init(2, secretKey);
        return decrypter;
    }

    private static Cipher getEncrypter() throws InvalidKeySpecException, InvalidKeyException, NoSuchAlgorithmException {
        SecretKey secretKey = EncryptionHelper.generateSecret();
        Cipher encrypter = threadLocalEncrypter.get();
        encrypter.init(1, secretKey);
        return encrypter;
    }
}

