/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.task;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.TaskType;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.CurrentBuildResult;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.spring.container.ContainerManager;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jfrog.bamboo.admin.ServerConfig;
import org.jfrog.bamboo.admin.ServerConfigManager;
import org.jfrog.bamboo.configuration.BuildParamsOverrideManager;
import org.jfrog.bamboo.context.GenericContext;
import org.jfrog.bamboo.util.BuildInfoLog;
import org.jfrog.bamboo.util.TaskUtils;
import org.jfrog.bamboo.util.generic.GenericBuildInfoHelper;
import org.jfrog.bamboo.util.generic.GenericData;
import org.jfrog.bamboo.util.version.VcsHelper;
import org.jfrog.build.api.Artifact;
import org.jfrog.build.api.Build;
import org.jfrog.build.api.builder.ModuleBuilder;
import org.jfrog.build.client.DeployDetails;
import org.jfrog.build.extractor.BuildInfoExtractorUtils;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryBuildInfoClient;
import org.jfrog.build.extractor.clientConfiguration.util.PublishedItemsHelper;
import org.jfrog.build.extractor.clientConfiguration.util.spec.SpecsHelper;

public class ArtifactoryGenericDeployTask
implements TaskType {
    public static final String TASK_NAME = "artifactoryGenericTask";
    private static final Logger log = Logger.getLogger(ArtifactoryGenericDeployTask.class);
    private final EnvironmentVariableAccessor environmentVariableAccessor;
    private PluginAccessor pluginAccessor;
    private BuildLogger logger;
    private GenericBuildInfoHelper buildInfoHelper;
    private CustomVariableContext customVariableContext;
    private BuildParamsOverrideManager buildParamsOverrideManager;

    public ArtifactoryGenericDeployTask(EnvironmentVariableAccessor environmentVariableAccessor) {
        this.environmentVariableAccessor = environmentVariableAccessor;
        ContainerManager.autowireComponent((Object)this);
        this.buildParamsOverrideManager = new BuildParamsOverrideManager(this.customVariableContext);
    }

    public void setPluginAccessor(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public void setCustomVariableContext(CustomVariableContext customVariableContext) {
        this.customVariableContext = customVariableContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public TaskResult execute(@NotNull TaskContext taskContext) throws TaskException {
        String vcsUrl;
        this.logger = taskContext.getBuildLogger();
        this.logger.addBuildLogEntry("Bamboo Artifactory Plugin version: " + this.getArtifactoryVersion());
        if (!taskContext.isFinalising()) {
            log.error(this.logger.addErrorLogEntry("Artifactory Generic Deploy Task must run as a final Task!"));
            return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).failed().build();
        }
        BuildContext context = taskContext.getBuildContext();
        CurrentBuildResult result = context.getBuildResult();
        if (result.getBuildState().equals((Object)BuildState.FAILED)) {
            log.error(this.logger.addErrorLogEntry("Build failed, not deploying to Artifactory."));
            return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).success().build();
        }
        GenericContext genericContext = new GenericContext((Map<String, String>)taskContext.getConfigurationMap());
        HashMap<String, String> env = Maps.newHashMap();
        env.putAll(this.environmentVariableAccessor.getEnvironment((CommonTaskContext)taskContext));
        env.putAll(this.environmentVariableAccessor.getEnvironment());
        String vcsRevision = VcsHelper.getRevisionKey(context);
        if (StringUtils.isBlank(vcsRevision)) {
            vcsRevision = "";
        }
        if (StringUtils.isBlank(vcsUrl = VcsHelper.getVcsUrl(context))) {
            vcsUrl = "";
        }
        this.buildInfoHelper = new GenericBuildInfoHelper(env, vcsRevision, vcsUrl);
        this.buildInfoHelper.init(this.buildParamsOverrideManager, context);
        ServerConfigManager serverConfigManager = ServerConfigManager.getInstance();
        ServerConfig serverConfig = serverConfigManager.getServerConfigById(genericContext.getSelectedServerId());
        if (serverConfig == null) {
            throw new IllegalArgumentException("Could not find Artifactpry server. Please check the Artifactory server in the task configuration.");
        }
        String username = this.getUsername(genericContext, serverConfigManager, serverConfig);
        Build build = this.getBuild(genericContext, taskContext, username);
        try (ArtifactoryBuildInfoClient client = this.getClient(genericContext, taskContext, username, serverConfigManager, serverConfig);){
            File sourceCodeDirectory = this.getWorkingDirectory(context, taskContext);
            if (sourceCodeDirectory == null) {
                log.error(this.logger.addErrorLogEntry("No build directory found!"));
                TaskResult taskResult = TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).success().build();
                return taskResult;
            }
            if (genericContext.isUseFileSpecs()) {
                String spec = this.getFileSpecSource(genericContext, sourceCodeDirectory);
                this.deployByFileSpec(sourceCodeDirectory, taskContext, build, client, spec);
            } else {
                this.deployByLegacyPattern(sourceCodeDirectory, taskContext, build, client, genericContext);
            }
            if (genericContext.isPublishBuildInfo()) {
                this.publishBuildInfo(taskContext, client, build);
            }
        }
        Map customBuildData = result.getCustomBuildData();
        if (genericContext.isPublishBuildInfo() && !customBuildData.containsKey("org.jfrog.bamboo.buildInfo.activated")) {
            customBuildData.put("org.jfrog.bamboo.buildInfo.activated", "true");
        }
        return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).success().build();
    }

    private String getFileSpecSource(GenericContext genericContext, File sourceCodeDirectory) throws IOException {
        return genericContext.isFileSpecInJobConfiguration() ? genericContext.getJobConfigurationSpec() : TaskUtils.getSpecFromFile(sourceCodeDirectory, genericContext.getFilePathSpec());
    }

    private File getWorkingDirectory(BuildContext context, TaskContext taskContext) throws RepositoryException {
        File checkoutDir = VcsHelper.getCheckoutDirectory(context);
        if (checkoutDir != null) {
            return checkoutDir;
        }
        return taskContext.getWorkingDirectory();
    }

    private Multimap<String, File> buildTargetPathToFiles(File directory, GenericContext context) throws IOException {
        HashMultimap<String, File> result = HashMultimap.create();
        String deployPattern = context.getDeployPattern();
        deployPattern = StringUtils.replace(deployPattern, "\r\n", "\n");
        Multimap<String, String> pairs = PublishedItemsHelper.getPublishedItemsPatternPairs(deployPattern = StringUtils.replace(deployPattern, ",", "\n"));
        if (pairs.isEmpty()) {
            return result;
        }
        for (Map.Entry<String, String> entry : pairs.entries()) {
            Multimap<String, File> filesMap = PublishedItemsHelper.buildPublishingData(directory, entry.getKey(), entry.getValue());
            if (filesMap != null) {
                log.info(this.logger.addBuildLogEntry("For pattern: " + entry.getKey() + " " + filesMap.size() + " artifacts were found"));
                result.putAll(filesMap);
                continue;
            }
            log.warn(this.logger.addBuildLogEntry("For pattern: " + entry.getKey() + " no artifacts were found"));
        }
        return result;
    }

    private void deployByLegacyPattern(File sourceCodeDirectory, TaskContext taskContext, Build build, ArtifactoryBuildInfoClient client, GenericContext context) throws IOException, NoSuchAlgorithmException {
        Multimap<String, File> filesMap = this.buildTargetPathToFiles(sourceCodeDirectory, context);
        Set<DeployDetails> details = this.buildInfoHelper.createDeployDetailsAndAddToBuildInfo(build, filesMap, taskContext.getBuildContext(), context);
        for (DeployDetails detail : details) {
            client.deployArtifact(detail);
        }
    }

    private void logProperties(Map<String, String> props) {
        this.logger.addBuildLogEntry("Artifacts properties (Bamboo):");
        for (Map.Entry<String, String> entry : props.entrySet()) {
            this.logger.addBuildLogEntry(String.format("name: %s value: %s", entry.getKey(), entry.getValue()));
        }
    }

    private void deployByFileSpec(File sourceCodeDirectory, TaskContext taskContext, Build build, ArtifactoryBuildInfoClient client, String spec) throws IOException, NoSuchAlgorithmException {
        SpecsHelper specsHelper = new SpecsHelper(new BuildInfoLog(log, taskContext.getBuildLogger()));
        Map<String, String> buildProperties = this.buildInfoHelper.getDynamicPropertyMap(build);
        this.logProperties(buildProperties);
        this.buildInfoHelper.addCommonProperties(buildProperties);
        List<Artifact> artifacts = specsHelper.uploadArtifactsBySpec(spec, sourceCodeDirectory, buildProperties, client);
        ModuleBuilder moduleBuilder = new ModuleBuilder().id(taskContext.getBuildContext().getPlanName() + ":" + taskContext.getBuildContext().getBuildNumber()).artifacts(artifacts);
        build.setModules(Lists.newArrayList(moduleBuilder.build()));
    }

    public void publishBuildInfo(TaskContext taskContext, ArtifactoryBuildInfoClient client, Build build) throws IOException {
        BuildContext buildContext = taskContext.getBuildContext();
        this.getDependenciesFromContext(taskContext, build);
        client.sendBuildInfo(build);
        buildContext.getBuildResult().getCustomBuildData().put("org.jfrog.bamboo.buildInfo.serverUrl", client.getArtifactoryUrl());
    }

    private String getUsername(GenericContext context, ServerConfigManager serverConfigManager, ServerConfig serverConfig) {
        String username = this.buildInfoHelper.overrideParam(serverConfigManager.substituteVariables(context.getUsername()), "artifactory.override.deployer.username");
        if (StringUtils.isBlank(username)) {
            username = serverConfigManager.substituteVariables(serverConfig.getUsername());
        }
        return username;
    }

    private String getPassword(GenericContext context, ServerConfigManager serverConfigManager, ServerConfig serverConfig) {
        String password = this.buildInfoHelper.overrideParam(serverConfigManager.substituteVariables(context.getPassword()), "artifactory.override.deployer.password");
        if (StringUtils.isBlank(password)) {
            password = serverConfigManager.substituteVariables(serverConfig.getPassword());
        }
        return password;
    }

    private ArtifactoryBuildInfoClient getClient(GenericContext context, TaskContext taskContext, String username, ServerConfigManager serverConfigManager, ServerConfig serverConfig) {
        String serverUrl = serverConfigManager.substituteVariables(serverConfig.getUrl());
        BuildInfoLog bambooBuildInfoLog = new BuildInfoLog(log, taskContext.getBuildLogger());
        return new ArtifactoryBuildInfoClient(serverUrl, username, this.getPassword(context, serverConfigManager, serverConfig), bambooBuildInfoLog);
    }

    private Build getBuild(GenericContext context, TaskContext taskContext, String username) {
        BuildContext buildContext = taskContext.getBuildContext();
        return this.buildInfoHelper.extractBuildInfo(buildContext, taskContext.getBuildLogger(), context, username);
    }

    private void getDependenciesFromContext(TaskContext taskContext, Build build) throws IOException {
        String genericJson = (String)taskContext.getBuildContext().getParentBuildContext().getBuildResult().getCustomBuildData().get("genericJson");
        if (StringUtils.isNotBlank(genericJson)) {
            GenericData genericData = BuildInfoExtractorUtils.jsonStringToGeneric(genericJson, GenericData.class);
            build.getModules().get(0).setDependencies(genericData.getDependencies());
            build.setBuildDependencies(genericData.getBuildDependencies());
        }
    }

    public String getArtifactoryVersion() {
        Plugin plugin = this.pluginAccessor.getPlugin("org.jfrog.bamboo.bamboo-artifactory-plugin");
        if (plugin != null) {
            return plugin.getPluginInformation().getVersion();
        }
        return "";
    }
}

