/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.task;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.TaskType;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jfrog.bamboo.admin.ServerConfig;
import org.jfrog.bamboo.admin.ServerConfigManager;
import org.jfrog.bamboo.configuration.BuildParamsOverrideManager;
import org.jfrog.bamboo.context.GenericContext;
import org.jfrog.bamboo.util.BuildInfoLog;
import org.jfrog.bamboo.util.TaskDefinitionHelper;
import org.jfrog.bamboo.util.TaskUtils;
import org.jfrog.bamboo.util.generic.GenericArtifactsResolver;
import org.jfrog.bamboo.util.generic.GenericData;
import org.jfrog.build.api.Dependency;
import org.jfrog.build.api.dependency.BuildDependency;
import org.jfrog.build.extractor.BuildInfoExtractorUtils;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryDependenciesClient;
import org.jfrog.build.extractor.clientConfiguration.util.spec.SpecsHelper;

public class ArtifactoryGenericResolveTask
implements TaskType {
    private static final Logger log = Logger.getLogger(ArtifactoryGenericResolveTask.class);
    private BuildLogger logger;
    private BuildParamsOverrideManager buildParamsOverrideManager;

    public ArtifactoryGenericResolveTask(CustomVariableContext customVariableContext) {
        this.buildParamsOverrideManager = new BuildParamsOverrideManager(customVariableContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public TaskResult execute(@NotNull TaskContext taskContext) throws TaskException {
        this.logger = taskContext.getBuildLogger();
        List taskDefinitions = taskContext.getBuildContext().getRuntimeTaskDefinitions();
        boolean buildinfoFlag = false;
        TaskDefinition genericDeployDefinition = TaskDefinitionHelper.findGenericDeployDefinition(taskDefinitions);
        if (genericDeployDefinition != null) {
            buildinfoFlag = Boolean.valueOf((String)genericDeployDefinition.getConfiguration().get("artifactory.generic.publishBuildInfo"));
        }
        GenericContext genericContext = new GenericContext((Map<String, String>)taskContext.getConfigurationMap());
        try (ArtifactoryDependenciesClient client = this.getArtifactoryDependenciesClient(genericContext);){
            List<Object> dependencies;
            ArrayList<BuildDependency> buildDependencies;
            BuildInfoLog bambooBuildInfoLog = new BuildInfoLog(log, this.logger);
            if (genericContext.isUseFileSpecs()) {
                String spec;
                buildDependencies = Lists.newArrayList();
                String string = spec = genericContext.isFileSpecInJobConfiguration() ? genericContext.getJobConfigurationSpec() : TaskUtils.getSpecFromFile(taskContext.getWorkingDirectory(), genericContext.getFilePathSpec());
                if (StringUtils.isNotBlank(spec)) {
                    SpecsHelper specsHelper = new SpecsHelper(bambooBuildInfoLog);
                    dependencies = specsHelper.downloadArtifactsBySpec(spec, client, taskContext.getWorkingDirectory().getCanonicalPath());
                } else {
                    dependencies = Lists.newArrayList();
                }
            } else {
                GenericArtifactsResolver resolver = new GenericArtifactsResolver(taskContext, client, genericContext.getResolvePattern(), bambooBuildInfoLog);
                buildDependencies = resolver.retrieveBuildDependencies();
                dependencies = resolver.retrievePublishedDependencies();
            }
            if (buildinfoFlag) {
                this.addDependenciesToContext(taskContext, buildDependencies, dependencies);
            }
        }
        return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).success().build();
    }

    private void addDependenciesToContext(TaskContext taskContext, List<BuildDependency> buildDependencies, List<Dependency> dependencies) throws IOException {
        GenericData gd = new GenericData();
        gd.setBuildDependencies(buildDependencies);
        gd.setDependencies(dependencies);
        String json = BuildInfoExtractorUtils.buildInfoToJsonString(gd);
        taskContext.getBuildContext().getParentBuildContext().getBuildResult().getCustomBuildData().put("genericJson", json);
    }

    private ArtifactoryDependenciesClient getArtifactoryDependenciesClient(GenericContext genericContext) {
        String password;
        ServerConfigManager serverConfigManager = ServerConfigManager.getInstance();
        ServerConfig serverConfig = serverConfigManager.getServerConfigById(genericContext.getSelectedServerId());
        if (serverConfig == null) {
            throw new IllegalArgumentException("Could not find Artifactpry server. Please check the Artifactory server in the task configuration.");
        }
        String username = this.overrideParam(serverConfigManager.substituteVariables(genericContext.getUsername()), "artifactory.override.resolver.username");
        if (StringUtils.isBlank(username)) {
            username = serverConfigManager.substituteVariables(serverConfig.getUsername());
        }
        if (StringUtils.isBlank(password = this.overrideParam(serverConfigManager.substituteVariables(genericContext.getPassword()), "artifactory.override.resolver.password"))) {
            password = serverConfigManager.substituteVariables(serverConfig.getPassword());
        }
        String serverUrl = serverConfigManager.substituteVariables(serverConfig.getUrl());
        return new ArtifactoryDependenciesClient(serverUrl, username, password, new BuildInfoLog(log));
    }

    public String overrideParam(String originalValue, String overrideKey) {
        String overriddenValue = this.buildParamsOverrideManager.getOverrideValue(overrideKey);
        return overriddenValue.isEmpty() ? originalValue : overriddenValue;
    }
}

