/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.task;

import com.atlassian.bamboo.build.ErrorLogEntry;
import com.atlassian.bamboo.build.LogEntry;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.build.logger.LogInterceptor;
import com.atlassian.bamboo.build.logger.interceptors.ErrorMemorisingInterceptor;
import com.atlassian.bamboo.build.test.TestCollationService;
import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.process.ExternalProcessBuilder;
import com.atlassian.bamboo.process.ProcessService;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.atlassian.bamboo.v2.build.agent.capability.ReadOnlyCapabilitySet;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.utils.process.ExternalProcess;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.apache.tools.ant.types.Commandline;
import org.jetbrains.annotations.NotNull;
import org.jfrog.bamboo.admin.ServerConfig;
import org.jfrog.bamboo.admin.ServerConfigManager;
import org.jfrog.bamboo.builder.BuilderDependencyHelper;
import org.jfrog.bamboo.builder.GradleInitScriptHelper;
import org.jfrog.bamboo.context.AbstractBuildContext;
import org.jfrog.bamboo.context.GradleBuildContext;
import org.jfrog.bamboo.task.ArtifactoryTaskType;
import org.jfrog.bamboo.util.ConfigurationPathHolder;
import org.jfrog.bamboo.util.PluginProperties;
import org.jfrog.bamboo.util.TaskUtils;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;

public class ArtifactoryGradleTask
extends ArtifactoryTaskType {
    public static final String TASK_NAME = "artifactoryGradleTask";
    public static final String EXECUTABLE_NAME = SystemUtils.IS_OS_WINDOWS ? "gradle.bat" : "gradle";
    public static final String EXECUTABLE_WRAPPER_NAME = SystemUtils.IS_OS_WINDOWS ? "./gradlew.bat" : "./gradlew";
    private static final Logger log = Logger.getLogger(ArtifactoryGradleTask.class);
    private static final String GRADLE_KEY = "system.builder.gradle.";
    private final ProcessService processService;
    private final CapabilityContext capabilityContext;
    private BuilderDependencyHelper dependencyHelper;
    private String gradleDependenciesDir = null;
    private AdministrationConfiguration administrationConfiguration;

    public ArtifactoryGradleTask(ProcessService processService, EnvironmentVariableAccessor environmentVariableAccessor, CapabilityContext capabilityContext, TestCollationService testCollationService) {
        super(testCollationService, environmentVariableAccessor);
        this.processService = processService;
        this.capabilityContext = capabilityContext;
        this.dependencyHelper = new BuilderDependencyHelper("artifactoryGradleBuilder");
        ContainerManager.autowireComponent((Object)this.dependencyHelper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public TaskResult execute(@NotNull TaskContext context) throws TaskException {
        String subDirectory;
        ConfigurationPathHolder pathHolder;
        String altTasks;
        BuildLogger logger = this.getBuildLogger(context);
        String artifactoryPluginVersion = this.getArtifactoryVersion();
        logger.addBuildLogEntry("Bamboo Artifactory Plugin version: " + artifactoryPluginVersion);
        ErrorMemorisingInterceptor errorLines = new ErrorMemorisingInterceptor();
        logger.getInterceptorStack().add((LogInterceptor)errorLines);
        GradleBuildContext gradleBuildContext = this.createBuildContext(context);
        this.initEnvironmentVariables(gradleBuildContext);
        long serverId = gradleBuildContext.getArtifactoryServerId();
        File rootDirectory = context.getRootDirectory();
        try {
            this.gradleDependenciesDir = this.extractGradleDependencies(serverId, rootDirectory, gradleBuildContext);
        }
        catch (IOException e) {
            this.gradleDependenciesDir = null;
            logger.addBuildLogEntry((LogEntry)new ErrorLogEntry("Error occurred while preparing Artifactory Gradle Runner dependencies. Build Info support is disabled: " + e.getMessage()));
            log.error("Error occurred while preparing Artifactory Gradle Runner dependencies. Build Info support is disabled.", e);
        }
        String gradleCommandLine = this.getExecutable(gradleBuildContext);
        if (StringUtils.isBlank(gradleCommandLine)) {
            log.error(logger.addErrorLogEntry("Gradle executable is not defined!"));
            return TaskResultBuilder.newBuilder((CommonTaskContext)context).failed().build();
        }
        ArrayList<String> command = Lists.newArrayList(gradleCommandLine);
        String switches = gradleBuildContext.getSwitches();
        if (StringUtils.isNotBlank(switches)) {
            String[] switchTokens = StringUtils.split(switches, ' ');
            command.addAll(Arrays.asList(switchTokens));
        }
        String tasks = gradleBuildContext.getTasks();
        if (gradleBuildContext.releaseManagementContext.isActivateReleaseManagement() && StringUtils.isNotBlank(altTasks = gradleBuildContext.releaseManagementContext.getAlternativeTasks())) {
            tasks = altTasks;
        }
        if (StringUtils.isNotBlank(tasks)) {
            String[] taskTokens = StringUtils.split(tasks, ' ');
            command.addAll(Arrays.asList(taskTokens));
        }
        if ((pathHolder = this.getGradleInitScriptFile(context, gradleBuildContext, artifactoryPluginVersion)) != null) {
            if (!gradleBuildContext.useArtifactoryGradlePlugin()) {
                command.add("-I");
                command.add(Commandline.quoteArgument((String)pathHolder.getInitScriptPath()));
            }
            TaskUtils.appendBuildInfoPropertiesArgument(command, pathHolder.getClientConfPath());
            command.add("artifactoryPublish");
        }
        if (StringUtils.isNotBlank(subDirectory = gradleBuildContext.getBuildScript())) {
            rootDirectory = new File(rootDirectory, subDirectory);
        }
        String jdkPath = this.getConfiguredJdkPath(this.buildParamsOverrideManager, gradleBuildContext, this.capabilityContext);
        this.environmentVariables.put("JAVA_HOME", jdkPath);
        this.environmentVariables.putAll(this.getPasswordsMap(gradleBuildContext));
        log.debug("Running Gradle command: " + ((Object)command).toString());
        ExternalProcessBuilder processBuilder = new ExternalProcessBuilder().workingDirectory(rootDirectory).command(command).env(this.environmentVariables);
        try {
            ExternalProcess process = this.processService.createExternalProcess((CommonTaskContext)context, processBuilder);
            process.execute();
            if (process.getHandler() != null && !process.getHandler().succeeded()) {
                String externalProcessOutput = this.getErrorMessage(process);
                logger.addBuildLogEntry(externalProcessOutput);
                log.debug("Process command error: " + externalProcessOutput);
            }
            TaskResult taskResult = this.collectTestResults(gradleBuildContext, context, process);
            return taskResult;
        }
        finally {
            context.getBuildContext().getBuildResult().addBuildErrors(errorLines.getErrorStringList());
        }
    }

    private GradleBuildContext createBuildContext(TaskContext context) {
        HashMap<String, String> combinedMap = Maps.newHashMap();
        combinedMap.putAll((Map<String, String>)context.getConfigurationMap());
        BuildContext parentBuildContext = context.getBuildContext().getParentBuildContext();
        if (parentBuildContext != null) {
            Map customBuildData = parentBuildContext.getBuildResult().getCustomBuildData();
            combinedMap.putAll(customBuildData);
        }
        return new GradleBuildContext(combinedMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private ConfigurationPathHolder getGradleInitScriptFile(TaskContext taskContext, GradleBuildContext buildContext, String artifactoryPluginVersion) {
        JarFile gradleJar;
        InputStream initScriptStream;
        block23: {
            ZipEntry initScriptEntry;
            block22: {
                File gradleJarFile = new File(this.gradleDependenciesDir, PluginProperties.getPluginProperty("gradle.dependency.file.name"));
                if (!gradleJarFile.exists()) {
                    log.warn("Unable to locate the Gradle extractor. Build-info task will not be added.");
                    return null;
                }
                initScriptStream = null;
                gradleJar = null;
                gradleJar = new JarFile(gradleJarFile);
                initScriptEntry = gradleJar.getEntry("initscripttemplate.gradle");
                if (initScriptEntry != null) break block22;
                log.warn("Unable to locate the Gradle init script. Build-info task will not be added.");
                ConfigurationPathHolder configurationPathHolder = null;
                IOUtils.closeQuietly(initScriptStream);
                try {
                    if (gradleJar != null) {
                        gradleJar.close();
                    }
                }
                catch (IOException e) {
                    log.warn("Unable to close the Gradle extractor jar: " + e.getMessage());
                }
                return configurationPathHolder;
            }
            initScriptStream = gradleJar.getInputStream(initScriptEntry);
            if (initScriptStream != null) break block23;
            log.warn("Unable to locate the gradle init script template. Build-info task will not be added.");
            ConfigurationPathHolder configurationPathHolder = null;
            IOUtils.closeQuietly(initScriptStream);
            try {
                if (gradleJar != null) {
                    gradleJar.close();
                }
            }
            catch (IOException e) {
                log.warn("Unable to close the Gradle extractor jar: " + e.getMessage());
            }
            return configurationPathHolder;
        }
        String scriptTemplate = IOUtils.toString(initScriptStream);
        GradleInitScriptHelper initScriptHelper = new GradleInitScriptHelper();
        initScriptHelper.init(this.buildParamsOverrideManager, taskContext.getBuildContext());
        initScriptHelper.setAdministrationConfiguration(this.administrationConfiguration);
        ConfigurationPathHolder configurationPathHolder = initScriptHelper.createAndGetGradleInitScriptPath(this.gradleDependenciesDir, buildContext, taskContext.getBuildLogger(), scriptTemplate, this.environmentVariableAccessor.getEnvironment((CommonTaskContext)taskContext), this.environmentVariableAccessor.getEnvironment(), artifactoryPluginVersion);
        IOUtils.closeQuietly(initScriptStream);
        try {
            if (gradleJar != null) {
                gradleJar.close();
            }
        }
        catch (IOException e) {
            log.warn("Unable to close the Gradle extractor jar: " + e.getMessage());
        }
        return configurationPathHolder;
        catch (IOException e) {
            ConfigurationPathHolder configurationPathHolder2;
            try {
                log.warn("Unable to read from the Gradle extractor jar. Build-info task will not be added: " + e.getMessage());
                configurationPathHolder2 = null;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(initScriptStream);
                try {
                    if (gradleJar != null) {
                        gradleJar.close();
                    }
                }
                catch (IOException e2) {
                    log.warn("Unable to close the Gradle extractor jar: " + e2.getMessage());
                }
                throw throwable;
            }
            IOUtils.closeQuietly(initScriptStream);
            try {
                if (gradleJar != null) {
                    gradleJar.close();
                }
            }
            catch (IOException e3) {
                log.warn("Unable to close the Gradle extractor jar: " + e3.getMessage());
            }
            return configurationPathHolder2;
        }
    }

    public String getExecutable(AbstractBuildContext buildContext) throws TaskException {
        if (buildContext instanceof GradleBuildContext && ((GradleBuildContext)buildContext).isUseGradleWrapper()) {
            String gradleWrapperLocation = ((GradleBuildContext)buildContext).getGradleWrapperLocation();
            if (StringUtils.isNotBlank(gradleWrapperLocation)) {
                return gradleWrapperLocation;
            }
            return EXECUTABLE_WRAPPER_NAME;
        }
        ReadOnlyCapabilitySet capabilitySet = this.capabilityContext.getCapabilitySet();
        if (capabilitySet == null) {
            return null;
        }
        Capability capability = capabilitySet.getCapability(GRADLE_KEY + buildContext.getExecutable());
        if (capability == null) {
            throw new TaskException("Gradle capability: " + buildContext.getExecutable() + " is not defined, please check job configuration");
        }
        String path = capability.getValue() + File.separator + "bin" + File.separator + EXECUTABLE_NAME;
        if (!new File(path).exists()) {
            throw new TaskException("Executable '" + EXECUTABLE_NAME + "'  does not exist at path '" + path + "'");
        }
        return path;
    }

    private String extractGradleDependencies(long artifactoryServerId, File rootDirectory, GradleBuildContext context) throws IOException {
        if (artifactoryServerId == -1L) {
            return null;
        }
        return this.dependencyHelper.downloadDependenciesAndGetPath(rootDirectory, context, PluginProperties.getPluginProperty("gradle.dependency.file.name"));
    }

    public void setAdministrationConfiguration(AdministrationConfiguration administrationConfiguration) {
        this.administrationConfiguration = administrationConfiguration;
    }

    @NotNull
    private Map<String, String> getPasswordsMap(GradleBuildContext gradleBuildContext) {
        HashMap<String, String> result = new HashMap<String, String>();
        ServerConfigManager serverConfigManager = ServerConfigManager.getInstance();
        long selectedServerId = gradleBuildContext.getArtifactoryServerId();
        if (selectedServerId == -1L) {
            return result;
        }
        ServerConfig serverConfig = serverConfigManager.getServerConfigById(selectedServerId);
        if (serverConfig == null) {
            String warningMessage = "Found an ID of a selected Artifactory server configuration (" + selectedServerId + ") but could not find a matching configuration. Build info collection is disabled.";
            log.warn(warningMessage);
            return result;
        }
        String deployerPassword = this.buildParamsOverrideManager.getOverrideValue("artifactory.override.deployer.password");
        if (StringUtils.isBlank(deployerPassword)) {
            deployerPassword = serverConfigManager.substituteVariables(gradleBuildContext.getDeployerPassword());
        }
        if (StringUtils.isBlank(deployerPassword)) {
            deployerPassword = serverConfigManager.substituteVariables(serverConfig.getPassword());
        }
        ArtifactoryClientConfiguration clientConf = new ArtifactoryClientConfiguration(null);
        result.put(clientConf.resolver.getPrefix() + "password", serverConfig.getPassword());
        result.put(clientConf.publisher.getPrefix() + "password", deployerPassword);
        return result;
    }
}

