/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.task;

import com.atlassian.bamboo.build.ErrorLogEntry;
import com.atlassian.bamboo.build.LogEntry;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.build.logger.LogInterceptor;
import com.atlassian.bamboo.build.logger.interceptors.ErrorMemorisingInterceptor;
import com.atlassian.bamboo.build.test.TestCollationService;
import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.process.ExternalProcessBuilder;
import com.atlassian.bamboo.process.ProcessService;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.atlassian.bamboo.v2.build.agent.capability.ReadOnlyCapabilitySet;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.utils.process.ExternalProcess;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.apache.tools.ant.types.Commandline;
import org.jetbrains.annotations.NotNull;
import org.jfrog.bamboo.builder.BuilderDependencyHelper;
import org.jfrog.bamboo.context.AbstractBuildContext;
import org.jfrog.bamboo.context.IvyBuildContext;
import org.jfrog.bamboo.task.ArtifactoryTaskType;
import org.jfrog.bamboo.util.IvyDataHelper;
import org.jfrog.bamboo.util.PluginProperties;
import org.jfrog.bamboo.util.TaskUtils;

public class ArtifactoryIvyTask
extends ArtifactoryTaskType {
    public static final String TASK_NAME = "artifactoryIvyTask";
    public static final String EXECUTABLE_NAME = SystemUtils.IS_OS_WINDOWS ? "ant.bat" : "ant";
    private static final Logger log = Logger.getLogger(ArtifactoryIvyTask.class);
    private static final String IVY_KEY = "system.builder.ivy.";
    private final ProcessService processService;
    private final EnvironmentVariableAccessor environmentVariableAccessor;
    private final CapabilityContext capabilityContext;
    private BuilderDependencyHelper dependencyHelper;
    private String ivyDependenciesDir = "";
    private String buildInfoPropertiesFile = "";
    private boolean activateBuildInfoRecording;

    public ArtifactoryIvyTask(ProcessService processService, EnvironmentVariableAccessor environmentVariableAccessor, CapabilityContext capabilityContext, TestCollationService testCollationService) {
        super(testCollationService, environmentVariableAccessor);
        this.processService = processService;
        this.environmentVariableAccessor = environmentVariableAccessor;
        this.capabilityContext = capabilityContext;
        this.dependencyHelper = new BuilderDependencyHelper("artifactoryIvyBuilder");
        ContainerManager.autowireComponent((Object)this.dependencyHelper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public TaskResult execute(@NotNull TaskContext context) throws TaskException {
        String subDirectory;
        String antOpts;
        String targets;
        String buildFile;
        String executable;
        BuildLogger logger = this.getBuildLogger(context);
        String artifactoryPluginVersion = this.getArtifactoryVersion();
        logger.addBuildLogEntry("Bamboo Artifactory Plugin version: " + artifactoryPluginVersion);
        ErrorMemorisingInterceptor errorLines = new ErrorMemorisingInterceptor();
        logger.getInterceptorStack().add((LogInterceptor)errorLines);
        HashMap<String, String> combinedMap = Maps.newHashMap();
        combinedMap.putAll((Map<String, String>)context.getConfigurationMap());
        combinedMap.putAll(context.getBuildContext().getBuildDefinition().getCustomConfiguration());
        IvyBuildContext ivyBuildContext = new IvyBuildContext(combinedMap);
        this.initEnvironmentVariables(ivyBuildContext);
        File rootDirectory = context.getRootDirectory();
        long serverId = ivyBuildContext.getArtifactoryServerId();
        try {
            this.ivyDependenciesDir = this.extractIvyDependencies(serverId, rootDirectory, ivyBuildContext);
            log.info(logger.addBuildLogEntry("Ivy dependency directory found at: " + this.ivyDependenciesDir));
        }
        catch (IOException ioe) {
            this.ivyDependenciesDir = null;
            logger.addBuildLogEntry((LogEntry)new ErrorLogEntry("Error occurred while preparing Artifactory Ivy Runner dependencies. Build Info support is disabled: " + ioe.getMessage()));
            log.error("Error occurred while preparing Artifactory Ivy Runner dependencies. Build Info support is disabled.", ioe);
        }
        if (this.ivyDependenciesDir == null) {
            String message = "Ivy dependency directory not found.";
            logger.addErrorLogEntry(message);
            log.error(message);
        }
        if (StringUtils.isBlank(executable = this.getExecutable(ivyBuildContext))) {
            log.error(logger.addErrorLogEntry("Cannot find ivy executable"));
            return TaskResultBuilder.newBuilder((CommonTaskContext)context).failed().build();
        }
        Map globalEnv = this.environmentVariableAccessor.getEnvironment();
        HashMap<String, String> environment = Maps.newHashMap(globalEnv);
        if (StringUtils.isNotBlank(this.ivyDependenciesDir)) {
            IvyDataHelper ivyDataHelper = new IvyDataHelper(this.buildParamsOverrideManager, context, ivyBuildContext, this.environmentVariableAccessor, artifactoryPluginVersion);
            try {
                this.buildInfoPropertiesFile = ivyDataHelper.createBuildInfoPropsFileAndGetItsPath();
            }
            catch (IOException e) {
                throw new TaskException("Failed to create Build Info properties file.", (Throwable)e);
            }
            if (StringUtils.isNotBlank(this.buildInfoPropertiesFile)) {
                this.activateBuildInfoRecording = true;
                environment.put("buildInfoConfig.propertiesFile", this.buildInfoPropertiesFile);
                environment.putAll(ivyDataHelper.getPasswordsMap(ivyBuildContext));
            }
        }
        ArrayList<String> command = Lists.newArrayList(executable);
        if (this.activateBuildInfoRecording) {
            command.add("-lib");
            command.add(Commandline.quoteArgument((String)this.ivyDependenciesDir));
            command.add("-listener");
            command.add(Commandline.quoteArgument((String)"org.jfrog.build.extractor.listener.ArtifactoryBuildListener"));
            TaskUtils.appendBuildInfoPropertiesArgument(command, this.buildInfoPropertiesFile);
        }
        if (StringUtils.isNotBlank(buildFile = ivyBuildContext.getBuildFile())) {
            command.addAll(Arrays.asList("-f", buildFile));
        }
        if (StringUtils.isNotBlank(targets = ivyBuildContext.getTargets())) {
            String[] targetTokens = StringUtils.split(targets, ' ');
            command.addAll(Arrays.asList(targetTokens));
        }
        if (StringUtils.isNotBlank(antOpts = ivyBuildContext.getAntOpts())) {
            environment.put("ANT_OPTS", antOpts);
        }
        if (StringUtils.isNotBlank(ivyBuildContext.getEnvironmentVariables())) {
            environment.putAll(this.environmentVariableAccessor.splitEnvironmentAssignments(ivyBuildContext.getEnvironmentVariables(), false));
        }
        if (StringUtils.isNotBlank(subDirectory = ivyBuildContext.getWorkingSubDirectory())) {
            rootDirectory = new File(rootDirectory, subDirectory);
        }
        String jdkPath = this.getConfiguredJdkPath(this.buildParamsOverrideManager, ivyBuildContext, this.capabilityContext);
        environment.put("JAVA_HOME", jdkPath);
        log.debug("Running Ant command: " + ((Object)command).toString());
        ExternalProcessBuilder processBuilder = new ExternalProcessBuilder().workingDirectory(rootDirectory).command(command).env(environment);
        try {
            ExternalProcess process = this.processService.createExternalProcess((CommonTaskContext)context, processBuilder);
            process.execute();
            if (process.getHandler() != null && !process.getHandler().succeeded()) {
                String externalProcessOutput = this.getErrorMessage(process);
                logger.addBuildLogEntry(externalProcessOutput);
                log.debug("Process command error: " + externalProcessOutput);
            }
            TaskResult taskResult = TaskResultBuilder.newBuilder((CommonTaskContext)context).checkReturnCode(process).build();
            return taskResult;
        }
        finally {
            context.getBuildContext().getBuildResult().addBuildErrors(errorLines.getErrorStringList());
        }
    }

    private String extractIvyDependencies(long artifactoryServerId, File rootDirectory, IvyBuildContext context) throws IOException {
        if (artifactoryServerId == -1L) {
            return null;
        }
        return this.dependencyHelper.downloadDependenciesAndGetPath(rootDirectory, context, PluginProperties.getPluginProperty("ivy.dependency.file.name"));
    }

    public String getExecutable(AbstractBuildContext buildContext) throws TaskException {
        ReadOnlyCapabilitySet capabilitySet = this.capabilityContext.getCapabilitySet();
        if (capabilitySet == null) {
            return null;
        }
        Capability capability = capabilitySet.getCapability(IVY_KEY + buildContext.getExecutable());
        if (capability == null) {
            throw new TaskException("Ivy capability: " + buildContext.getExecutable() + " is not defined, please check job configuration");
        }
        String path = capability.getValue() + File.separator + "bin" + File.separator + EXECUTABLE_NAME;
        if (!new File(path).exists()) {
            throw new TaskException("Executable '" + EXECUTABLE_NAME + "'  does not exist at path '" + path + "'");
        }
        return path;
    }
}

