/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.task;

import com.atlassian.bamboo.build.ErrorLogEntry;
import com.atlassian.bamboo.build.LogEntry;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.build.logger.LogInterceptor;
import com.atlassian.bamboo.build.logger.interceptors.ErrorMemorisingInterceptor;
import com.atlassian.bamboo.build.test.TestCollationService;
import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.process.ExternalProcessBuilder;
import com.atlassian.bamboo.process.ProcessService;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.utils.process.ExternalProcess;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.apache.tools.ant.types.Commandline;
import org.jetbrains.annotations.NotNull;
import org.jfrog.bamboo.builder.ArtifactoryBuildInfoDataHelper;
import org.jfrog.bamboo.builder.BuilderDependencyHelper;
import org.jfrog.bamboo.context.AbstractBuildContext;
import org.jfrog.bamboo.context.Maven3BuildContext;
import org.jfrog.bamboo.task.ArtifactoryTaskType;
import org.jfrog.bamboo.util.MavenDataHelper;
import org.jfrog.bamboo.util.PluginProperties;
import org.jfrog.bamboo.util.TaskUtils;

public class ArtifactoryMaven3Task
extends ArtifactoryTaskType {
    public static final String TASK_NAME = "maven3Task";
    private static final Logger log = Logger.getLogger(ArtifactoryMaven3Task.class);
    private final ProcessService processService;
    private final EnvironmentVariableAccessor environmentVariableAccessor;
    private final CapabilityContext capabilityContext;
    private BuilderDependencyHelper dependencyHelper;
    private String mavenDependenciesDir;
    private String buildInfoPropertiesFile;
    private boolean activateBuildInfoRecording;

    public ArtifactoryMaven3Task(ProcessService processService, EnvironmentVariableAccessor environmentVariableAccessor, CapabilityContext capabilityContext, TestCollationService testCollationService) {
        super(testCollationService, environmentVariableAccessor);
        this.processService = processService;
        this.environmentVariableAccessor = environmentVariableAccessor;
        this.capabilityContext = capabilityContext;
        this.dependencyHelper = new BuilderDependencyHelper("artifactoryMaven3Builder");
        ContainerManager.autowireComponent((Object)this.dependencyHelper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public TaskResult execute(@NotNull TaskContext taskContext) throws TaskException {
        String subDirectory;
        BuildLogger logger = this.getBuildLogger(taskContext);
        String artifactoryPluginVersion = this.getArtifactoryVersion();
        logger.addBuildLogEntry("Bamboo Artifactory Plugin version: " + artifactoryPluginVersion);
        ErrorMemorisingInterceptor errorLines = new ErrorMemorisingInterceptor();
        logger.getInterceptorStack().add((LogInterceptor)errorLines);
        Maven3BuildContext mavenBuildContext = this.createBuildContext(taskContext);
        this.initEnvironmentVariables(mavenBuildContext);
        long serverId = mavenBuildContext.getArtifactoryServerId();
        File rootDirectory = taskContext.getRootDirectory();
        try {
            this.mavenDependenciesDir = this.extractMaven3Dependencies(rootDirectory, serverId, mavenBuildContext);
        }
        catch (IOException e) {
            this.mavenDependenciesDir = null;
            logger.addBuildLogEntry((LogEntry)new ErrorLogEntry("Error occurred while preparing Artifactory Maven Runner dependencies. Build Info support is disabled: " + e.getMessage()));
            log.error("Error occurred while preparing Artifactory Maven Runner dependencies. Build Info support is disabled.", e);
        }
        if (StringUtils.isNotBlank(this.mavenDependenciesDir)) {
            MavenDataHelper mavenDataHelper = new MavenDataHelper(this.buildParamsOverrideManager, taskContext, mavenBuildContext, this.environmentVariableAccessor, artifactoryPluginVersion);
            try {
                this.buildInfoPropertiesFile = mavenDataHelper.createBuildInfoPropsFileAndGetItsPath();
            }
            catch (IOException e) {
                throw new TaskException("Failed to create Build Info properties file.", (Throwable)e);
            }
            if (StringUtils.isNotBlank(this.buildInfoPropertiesFile)) {
                this.activateBuildInfoRecording = true;
            }
            this.environmentVariables.putAll(((ArtifactoryBuildInfoDataHelper)mavenDataHelper).getPasswordsMap(mavenBuildContext));
        }
        if (StringUtils.isNotBlank(subDirectory = mavenBuildContext.getWorkingSubDirectory())) {
            rootDirectory = new File(rootDirectory, subDirectory);
        }
        List<String> command = this.getCommand(mavenBuildContext);
        String mavenHome = this.getMavenHome(mavenBuildContext);
        if (StringUtils.isBlank(mavenHome)) {
            log.error(logger.addErrorLogEntry("Maven home is not defined!"));
            return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).failed().build();
        }
        this.appendClassPathArguments(command, mavenHome);
        this.appendClassWorldsConfArgument(command, mavenHome);
        this.appendBuildInfoPropertiesArgument(command);
        this.appendMavenOpts(command, mavenBuildContext);
        this.addMavenHome(command, mavenHome);
        this.addMavenMultiModuleProjectPath(command, rootDirectory);
        command.add("org.codehaus.plexus.classworlds.launcher.Launcher");
        this.appendGoals(command, mavenBuildContext);
        this.appendAdditionalMavenParameters(command, mavenBuildContext);
        log.debug("Running maven command: " + command.toString());
        ExternalProcessBuilder processBuilder = new ExternalProcessBuilder().workingDirectory(rootDirectory).command(command).env(this.environmentVariables);
        try {
            ExternalProcess process = this.processService.createExternalProcess((CommonTaskContext)taskContext, processBuilder);
            process.execute();
            if (process.getHandler() != null && !process.getHandler().succeeded()) {
                String externalProcessOutput = this.getErrorMessage(process);
                logger.addBuildLogEntry(externalProcessOutput);
                log.debug("Process command error: " + externalProcessOutput);
            }
            TaskResult taskResult = this.collectTestResults(mavenBuildContext, taskContext, process);
            return taskResult;
        }
        finally {
            taskContext.getBuildContext().getBuildResult().addBuildErrors(errorLines.getErrorStringList());
        }
    }

    public String getExecutable(AbstractBuildContext context) throws TaskException {
        String jdkPath = this.getConfiguredJdkPath(this.buildParamsOverrideManager, context, this.capabilityContext);
        StringBuilder binPathBuilder = new StringBuilder(jdkPath);
        if (SystemUtils.IS_OS_WINDOWS) {
            binPathBuilder.append("bin").append(File.separator).append("java.exe");
        } else {
            String aixJdkLocation = "jre" + File.separator + "sh" + File.separator + "java";
            File aixJdk = new File(binPathBuilder.toString() + aixJdkLocation);
            if (aixJdk.isFile()) {
                binPathBuilder.append(aixJdkLocation);
            } else {
                binPathBuilder.append("bin").append(File.separator).append("java");
            }
        }
        String binPath = binPathBuilder.toString();
        binPath = this.getCanonicalPath(binPath);
        return binPath;
    }

    private Maven3BuildContext createBuildContext(TaskContext context) {
        HashMap<String, String> combinedMap = Maps.newHashMap();
        combinedMap.putAll((Map<String, String>)context.getConfigurationMap());
        BuildContext parentBuildContext = context.getBuildContext().getParentBuildContext();
        if (parentBuildContext != null) {
            Map customBuildData = parentBuildContext.getBuildResult().getCustomBuildData();
            combinedMap.putAll(customBuildData);
        }
        return new Maven3BuildContext(combinedMap);
    }

    private void addMavenHome(List<String> command, String mavenHome) {
        command.add(Commandline.quoteArgument((String)("-Dmaven.home=" + mavenHome)));
    }

    private void addMavenMultiModuleProjectPath(List<String> command, File rootDirectory) {
        command.add(Commandline.quoteArgument((String)("-Dmaven.multiModuleProjectDirectory=" + rootDirectory.getPath())));
    }

    private List<String> getCommand(Maven3BuildContext mavenBuildContext) throws TaskException {
        ArrayList<String> command = Lists.newArrayList();
        String executable = this.getExecutable(mavenBuildContext);
        if (StringUtils.isBlank(executable)) {
            log.error("No Maven executable found");
            return command;
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            command.add("cmd.exe");
            command.add("/c");
            command.add("call");
            command.add(Commandline.quoteArgument((String)executable));
        } else {
            command.add(Commandline.quoteArgument((String)executable));
        }
        return command;
    }

    private void appendMavenOpts(List<String> arguments, Maven3BuildContext mavenBuildContext) {
        String mavenOpts = mavenBuildContext.getMavenOpts();
        if (StringUtils.isNotBlank(mavenOpts)) {
            String[] mavenOptsToken;
            for (String opt : mavenOptsToken = StringUtils.split(mavenOpts, " ")) {
                if (!StringUtils.isNotBlank(opt)) continue;
                arguments.add(Commandline.quoteArgument((String)opt));
            }
        }
    }

    private void appendClassPathArguments(List<String> arguments, String mavenHomePath) {
        String[] bootJars;
        arguments.add("-cp");
        StringBuilder classPathBuilder = this.getPathBuilder(mavenHomePath).append("boot");
        String mavenBootPath = classPathBuilder.toString();
        File mavenBootFolder = new File(mavenBootPath);
        if (!mavenBootFolder.isDirectory()) {
            throw new IllegalStateException("Could not find the Maven lib directory in the expected path: " + mavenBootPath + ".");
        }
        for (String bootJar : bootJars = mavenBootFolder.list()) {
            if (!StringUtils.startsWithIgnoreCase(bootJar, "plexus-classworlds") || !StringUtils.endsWithIgnoreCase(bootJar, ".jar")) continue;
            classPathBuilder.append(File.separator).append(bootJar);
            String classPath = this.getCanonicalPath(classPathBuilder.toString());
            arguments.add(Commandline.quoteArgument((String)classPath));
            return;
        }
        throw new IllegalStateException("Could not find plexus classworlds jar in " + mavenBootPath + ".");
    }

    private void appendGoals(List<String> arguments, Maven3BuildContext context) {
        String altTasks;
        String goals = context.getGoals();
        if (context.releaseManagementContext.isActivateReleaseManagement() && StringUtils.isNotBlank(altTasks = context.releaseManagementContext.getAlternativeTasks())) {
            goals = altTasks;
        }
        goals = this.getStringWithoutNewLines(goals);
        String[] goalArray = StringUtils.split(goals, " ");
        arguments.addAll(Arrays.asList(goalArray));
    }

    private void appendClassWorldsConfArgument(List<String> arguments, String mavenHomePath) {
        String m2ConfPath;
        String originalConfPath = this.getPathBuilder(mavenHomePath).append("bin").append(File.separator).append("m2.conf").toString();
        if (this.activateBuildInfoRecording) {
            try {
                List<String> m2ConfLines = FileUtils.readLines(new File(originalConfPath), "utf-8");
                m2ConfLines.add("load " + this.mavenDependenciesDir + File.separator + "*.jar");
                File tempM2Conf = File.createTempFile("artifactoryM2", "conf");
                FileUtils.writeLines(tempM2Conf, m2ConfLines);
                m2ConfPath = tempM2Conf.getCanonicalPath();
            }
            catch (IOException ioe) {
                throw new RuntimeException("Error occurred while writing Maven 3 customized m2.conf", ioe);
            }
        } else {
            m2ConfPath = originalConfPath;
        }
        arguments.add(Commandline.quoteArgument((String)("-Dclassworlds.conf=" + m2ConfPath)));
    }

    private void appendBuildInfoPropertiesArgument(List<String> arguments) {
        if (this.activateBuildInfoRecording) {
            TaskUtils.appendBuildInfoPropertiesArgument(arguments, this.buildInfoPropertiesFile);
        }
    }

    private String extractMaven3Dependencies(File rootDir, long artifactoryServerId, Maven3BuildContext mavenBuildContext) throws IOException {
        if (artifactoryServerId == -1L) {
            return null;
        }
        return this.dependencyHelper.downloadDependenciesAndGetPath(rootDir, mavenBuildContext, PluginProperties.getPluginProperty("maven3.dependency.file.name"));
    }

    private void appendAdditionalMavenParameters(List<String> arguments, Maven3BuildContext context) {
        String projectFile;
        String additionalParams = context.getAdditionalMavenParams();
        if (StringUtils.isNotBlank(additionalParams)) {
            String formattedParams = this.getStringWithoutNewLines(additionalParams);
            String[] paramArray = StringUtils.split(formattedParams, " ");
            arguments.addAll(Arrays.asList(paramArray));
        }
        if (StringUtils.isNotBlank(projectFile = context.getProjectFile())) {
            arguments.addAll(Arrays.asList("-f", projectFile));
        }
    }

    private String getMavenHome(Maven3BuildContext context) {
        return this.capabilityContext.getCapabilityValue("system.builder.maven." + context.getExecutable());
    }

    private String getStringWithoutNewLines(String stringToModify) {
        return StringUtils.replaceChars(stringToModify, "\r\n", "  ");
    }
}

