/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.task;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.build.test.TestCollationService;
import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.TaskType;
import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.atlassian.bamboo.v2.build.agent.capability.ReadOnlyCapabilitySet;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.utils.process.ExternalProcess;
import com.atlassian.utils.process.OutputHandler;
import com.atlassian.utils.process.PluggableProcessHandler;
import com.atlassian.utils.process.ProcessHandler;
import com.atlassian.utils.process.StringOutputHandler;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jfrog.bamboo.configuration.BuildParamsOverrideManager;
import org.jfrog.bamboo.context.AbstractBuildContext;

public abstract class ArtifactoryTaskType
implements TaskType {
    protected static final String JDK_LABEL_KEY = "system.jdk.";
    public static final String JAVA_HOME = "JAVA_HOME";
    protected Map<String, String> environmentVariables;
    protected PluginAccessor pluginAccessor;
    protected final EnvironmentVariableAccessor environmentVariableAccessor;
    private final TestCollationService testCollationService;
    protected BuildParamsOverrideManager buildParamsOverrideManager;
    protected CustomVariableContext customVariableContext;

    protected ArtifactoryTaskType(TestCollationService testCollationService, EnvironmentVariableAccessor environmentVariableAccessor) {
        ContainerManager.autowireComponent((Object)this);
        this.testCollationService = testCollationService;
        this.environmentVariableAccessor = environmentVariableAccessor;
        this.buildParamsOverrideManager = new BuildParamsOverrideManager(this.customVariableContext);
    }

    public void setCustomVariableContext(CustomVariableContext customVariableContext) {
        this.customVariableContext = customVariableContext;
    }

    public void setPluginAccessor(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    protected void initEnvironmentVariables(AbstractBuildContext buildContext) {
        HashMap<String, String> env = Maps.newHashMap();
        env.putAll(this.environmentVariableAccessor.getEnvironment());
        if (StringUtils.isNotBlank(buildContext.getEnvironmentVariables())) {
            env.putAll(this.environmentVariableAccessor.splitEnvironmentAssignments(buildContext.getEnvironmentVariables(), false));
        }
        this.environmentVariables = env;
    }

    public BuildLogger getBuildLogger(TaskContext taskContext) {
        return taskContext.getBuildLogger();
    }

    public TaskResult collectTestResults(AbstractBuildContext buildContext, TaskContext taskContext, ExternalProcess process) {
        TaskResultBuilder builder = TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).checkReturnCode(process);
        if (buildContext.isTestChecked() && buildContext.getTestDirectory() != null) {
            this.testCollationService.collateTestResults(taskContext, buildContext.getTestDirectory());
            builder.checkTestFailures();
        }
        return builder.build();
    }

    protected String getConfiguredJdkPath(BuildParamsOverrideManager buildParamsOverrideManager, AbstractBuildContext context, CapabilityContext capabilityContext) {
        if (this.shouldOverrideJdk()) {
            String envVarValue;
            String jdkEnvVarName = buildParamsOverrideManager.getOverrideValue("artifactory.task.override.jdk.env.var");
            if (StringUtils.isEmpty(jdkEnvVarName)) {
                jdkEnvVarName = JAVA_HOME;
            }
            if ((envVarValue = this.environmentVariables.get(jdkEnvVarName)) == null) {
                throw new RuntimeException("The task is configured to use the '" + jdkEnvVarName + "' environment variable for the build JDK, but this environment variable is not defined.");
            }
            return this.getPathBuilder(envVarValue).toString();
        }
        String jdkCapabilityKey = JDK_LABEL_KEY + context.getJdkLabel();
        ReadOnlyCapabilitySet capabilitySet = capabilityContext.getCapabilitySet();
        if (capabilitySet == null) {
            return null;
        }
        Capability capability = capabilitySet.getCapability(jdkCapabilityKey);
        if (capability == null) {
            return null;
        }
        String jdkHome = capability.getValue();
        if (StringUtils.isBlank(jdkHome)) {
            return null;
        }
        StringBuilder binPathBuilder = this.getPathBuilder(jdkHome);
        return binPathBuilder.toString();
    }

    public StringBuilder getPathBuilder(String basePath) {
        StringBuilder confPathBuilder = new StringBuilder(basePath);
        if (!basePath.endsWith(File.separator)) {
            confPathBuilder.append(File.separator);
        }
        return confPathBuilder;
    }

    public String getCanonicalPath(String path) {
        if (StringUtils.contains(path, " ")) {
            try {
                File f = new File(path);
                path = f.getCanonicalPath();
            }
            catch (IOException e) {
                throw new RuntimeException("IO Exception trying to get canonical path of item: " + path, e);
            }
        }
        return path;
    }

    public String getErrorMessage(ExternalProcess process) {
        StringOutputHandler errorStringHandler;
        OutputHandler errorHandler;
        ProcessHandler handler = process.getHandler();
        String commandLine = process.getCommandLine();
        StringBuilder message = new StringBuilder();
        if (handler.getException() != null) {
            message.append("Exception executing command \"").append(commandLine).append(" \n").append(handler.getException().getMessage()).append("\n").append(handler.getException()).append("\n");
        }
        String reason = null;
        if (handler instanceof PluggableProcessHandler && (errorHandler = ((PluggableProcessHandler)handler).getErrorHandler()) instanceof StringOutputHandler && (errorStringHandler = (StringOutputHandler)errorHandler).getOutput() != null) {
            reason = errorStringHandler.getOutput();
        }
        if (reason != null && reason.trim().length() > 0) {
            message.append("Error executing command \"").append(commandLine).append("\": ").append(reason);
        }
        return message.toString();
    }

    public String getArtifactoryVersion() {
        Plugin plugin = this.pluginAccessor.getPlugin("org.jfrog.bamboo.bamboo-artifactory-plugin");
        if (plugin != null) {
            return plugin.getPluginInformation().getVersion();
        }
        return "";
    }

    private boolean shouldOverrideJdk() {
        return Boolean.valueOf(this.buildParamsOverrideManager.getOverrideValue("artifactory.task.override.jdk"));
    }
}

