/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.util;

import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.task.TaskContext;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jfrog.bamboo.admin.ServerConfig;
import org.jfrog.bamboo.builder.ArtifactoryBuildInfoDataHelper;
import org.jfrog.bamboo.configuration.BuildParamsOverrideManager;
import org.jfrog.bamboo.context.AbstractBuildContext;
import org.jfrog.bamboo.context.Maven3BuildContext;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;

public class MavenDataHelper
extends ArtifactoryBuildInfoDataHelper {
    public MavenDataHelper(BuildParamsOverrideManager buildParamsOverrideManager, TaskContext context, AbstractBuildContext buildContext, EnvironmentVariableAccessor envVarAccessor, String artifactoryPluginVersion) {
        super(buildParamsOverrideManager, context, buildContext, envVarAccessor, artifactoryPluginVersion);
    }

    @Override
    protected void setClientData(AbstractBuildContext builder, ArtifactoryClientConfiguration clientConf, ServerConfig serverConfig, Map<String, String> environment) {
        long serverId;
        ServerConfig resolutionServerConfig;
        Maven3BuildContext buildContext = (Maven3BuildContext)builder;
        clientConf.publisher.setRecordAllDependencies(buildContext.isRecordAllDependencies());
        String resolutionRepo = this.overrideParam(buildContext.getResolutionRepo(), "artifactory.override.resolve.repo");
        if (this.isResolutionConfigured(buildContext, resolutionRepo) && (resolutionServerConfig = this.serverConfigManager.getServerConfigById(serverId = buildContext.getResolutionArtifactoryServerId())) != null) {
            clientConf.resolver.setContextUrl(resolutionServerConfig.getUrl());
            clientConf.resolver.setRepoKey(resolutionRepo);
            String username = buildContext.getResolverUserName();
            username = this.overrideParam(username, "artifactory.override.resolver.username");
            if (StringUtils.isBlank(username)) {
                username = resolutionServerConfig.getUsername();
            }
            clientConf.resolver.setUsername(username);
        }
    }

    @Override
    @NotNull
    public Map<String, String> getPasswordsMap(AbstractBuildContext builder) {
        Maven3BuildContext buildContext = (Maven3BuildContext)builder;
        Map<String, String> passwordsMap = super.getPasswordsMap(buildContext);
        if (this.serverConfig == null) {
            return passwordsMap;
        }
        String resolutionRepo = this.overrideParam(buildContext.getResolutionRepo(), "artifactory.override.resolve.repo");
        if (this.isResolutionConfigured(buildContext, resolutionRepo)) {
            ServerConfig resolutionServerConfig = this.serverConfigManager.getServerConfigById(buildContext.getResolutionArtifactoryServerId());
            String password = buildContext.getResolverPassword();
            if (StringUtils.isBlank(password = this.overrideParam(password, "artifactory.override.resolver.password"))) {
                password = resolutionServerConfig.getPassword();
            }
            this.clientConf.resolver.setPassword(password);
            passwordsMap.put(this.clientConf.resolver.getPrefix() + "password", this.clientConf.resolver.getPassword());
        }
        return passwordsMap;
    }

    private boolean isResolutionConfigured(Maven3BuildContext buildContext, String resolutionRepo) {
        return buildContext.isResolveFromArtifactory() && StringUtils.isNotBlank(resolutionRepo) && !"noResolutionRepoKeyConfigured".equals(resolutionRepo) && this.serverConfigManager.getServerConfigById(buildContext.getResolutionArtifactoryServerId()) != null;
    }
}

