/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.util;

import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.task.TaskDefinition;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.Nullable;

public abstract class TaskDefinitionHelper {
    private TaskDefinitionHelper() {
        throw new IllegalAccessError();
    }

    @Nullable
    public static TaskDefinition findMavenOrGradleDefinition(List<TaskDefinition> taskDefinitions) {
        if (taskDefinitions == null || taskDefinitions.isEmpty()) {
            return null;
        }
        TaskDefinition definition = TaskDefinitionHelper.findMavenDefinition(taskDefinitions);
        if (definition == null) {
            definition = TaskDefinitionHelper.findGradleDefinition(taskDefinitions);
        }
        return definition;
    }

    @Nullable
    public static TaskDefinition findGradleDefinition(List<? extends TaskDefinition> taskDefinitions) {
        if (taskDefinitions != null) {
            for (TaskDefinition taskDefinition : taskDefinitions) {
                if (!taskDefinition.isEnabled() || !StringUtils.endsWith(taskDefinition.getPluginKey(), "artifactoryGradleTask")) continue;
                return taskDefinition;
            }
        }
        return null;
    }

    @Nullable
    public static TaskDefinition findMavenDefinition(List<? extends TaskDefinition> taskDefinitions) {
        if (taskDefinitions != null) {
            for (TaskDefinition taskDefinition : taskDefinitions) {
                if (!taskDefinition.isEnabled() || !StringUtils.endsWith(taskDefinition.getPluginKey(), "maven3Task")) continue;
                return taskDefinition;
            }
        }
        return null;
    }

    @Nullable
    public static TaskDefinition findReleaseTaskDefinition(List<? extends TaskDefinition> taskDefinitions) {
        if (taskDefinitions != null) {
            for (TaskDefinition taskDefinition : taskDefinitions) {
                if (!"true".equals(taskDefinition.getConfiguration().get("enableReleaseManagement"))) continue;
                return taskDefinition;
            }
        }
        return null;
    }

    @Nullable
    public static TaskDefinition findGenericDeployDefinition(List<? extends TaskDefinition> taskDefinitions) {
        if (taskDefinitions != null) {
            for (TaskDefinition taskDefinition : taskDefinitions) {
                if (!StringUtils.endsWith(taskDefinition.getPluginKey(), "artifactoryGenericTask")) continue;
                return taskDefinition;
            }
        }
        return null;
    }

    @Nullable
    public static TaskDefinition findIvyTaskDefinition(List<TaskDefinition> taskDefinitions) {
        if (taskDefinitions != null) {
            for (TaskDefinition definition : taskDefinitions) {
                if (!StringUtils.endsWith(definition.getPluginKey(), "artifactoryIvyTask")) continue;
                return definition;
            }
        }
        return null;
    }

    public static TaskDefinition getPushToBintrayEnabledTaskDefinition(ImmutablePlan plan) {
        List taskDefinitions = plan.getBuildDefinition().getTaskDefinitions();
        TaskDefinition pushToBintrayEnabledTask = TaskDefinitionHelper.findMavenOrGradleDefinition(taskDefinitions);
        if (pushToBintrayEnabledTask == null) {
            pushToBintrayEnabledTask = TaskDefinitionHelper.findIvyTaskDefinition(taskDefinitions);
        }
        if (pushToBintrayEnabledTask == null) {
            pushToBintrayEnabledTask = TaskDefinitionHelper.findGenericDeployDefinition(taskDefinitions);
        }
        return pushToBintrayEnabledTask;
    }
}

